<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|    example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|    https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|    $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|    $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|    $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:    my-controller/index    -> my_controller/index
|        my-controller/my-method    -> my_controller/my_method
 */
$route['default_controller']   = 'welcome';
$route['404_override']         = '';
$route['translate_uri_dashes'] = FALSE;

/* API PATH OLD */
$route['api/insert_logs.php']                 = 'api/insert_logs/format/json';/*insert_logs.php*/
$route['api/selete_logs.php']                 = 'api/idoor_logs/format/json';/*selete_logs.php*/
$route['api/vc_token.php']                    = 'api/vc_token/format/json';/*vc_token.php*/
// $route['lock_qr.php']                     = 'api/lock_qr/format/json';/*lock_qr.php*/
// $route['bridge/sendBridgeLockAction.php'] = 'api/sendBridgeLockAction/format/json';/*bridge/sendBridgeLockAction.php ,,,,,url not found*/
// $route['bell_call_door.php']              = 'api/bell_call_door/format/json';/*lock_qr.php*/
// $route['login_sign_in.php']               = 'api/user_login/format/json';/*login_sign_in.php*/
// $route['sign_up']                         = 'api/sign_up/format/json';/*sign up user*/
// $route['forgot_password']                 = 'api/forgot_password/format/json';/*Forgot Password*/
// $route['logout']                          = 'api/logout/format/json';/*Logout*/
// $route['sync_details']                    = 'api/sync_details/format/json';/*Lock Listing*/
// $route['lock_upload']                     = 'api/lock_upload/format/json';/*Lock Add*/
// $route['lock_delete']                     = 'api/lock_delete/format/json';/*Lock Delete*/
// $route['lock_update']                     = 'api/lock_upload/format/json';/*Lock Update*/
// $route['update_profile']                  = 'api/sign_up/format/json';/*Lock Update*/


/* NEW DEVELOPMENT API */
$route['api/sign_up']              = 'api/user_register/format/json'; /* Sign UP API */
$route['api/update_profile']       = 'api/user_register/format/json'; /* Profile Update API */
$route['api/udpate_device_token']  = 'api/updateDevicetoken/format/json'; /* Device Token Update API */
$route['api/login']                = 'api/user_login/format/json'; /* Login API */
$route['api/logout']               = 'api/logout/format/json'; /* Logout API */
$route['api/forgot_password']      = 'api/forgot_password/format/json'; /* Forgot Password */
$route['api/add_lock']             = 'api/add_lock/format/json'; /* Add Lock */
$route['api/update_lock']          = 'api/add_lock/format/json'; /* Update Lock */
$route['api/sync_lock_list']       = 'api/sync_lock_list/format/json'; /* Sync Lock Details */
$route['api/delete_lock']          = 'api/delete_lock/format/json'; /* Delete Lock */
$route['api/verify_qr']            = 'api/verify_qr/format/json'; /* Verify QR */
$route['api/invite_user']          = 'api/invite_user/format/json'; /* Invite User */
$route['api/invite_user_list']     = 'api/invite_user_list/format/json'; /* Invited User List */
$route['api/approve_invited_user'] = 'api/approve_invited_user/format/json'; /* Approve Invited User */
$route['api/revoke_invited_user']  = 'api/revoke_invited_user/format/json'; /* Revoke API */
$route['api/finger_add_update']    = 'api/finger_add_update/format/json'; /* Finger Add OR Update API */
$route['api/delete_finger']        = 'api/delete_finger/format/json'; /* Delete Finger API */
$route['api/change_password']      = 'api/change_password/format/json'; /* Change Password API */


/* ADMIN PANEL PAGE PATH */
$route['change_password/(:any)']    = 'Change_password';/* Change Password */
$route['email_confirmation/(:any)'] = 'Change_password/email_confirmation'; /* Email Confirmation */
$route['admin']                     = 'admin/Login';
$route['admin/dashboard']           = 'admin/dashboard/dashboard';

$route['admin/lock/manage']         = 'admin/lock/lock/manage_lock';
$route['admin/lock/add']            = 'admin/lock/lock/add_lock'; 
$route['admin/lock/add/(:any)']     = 'admin/lock/lock/add_lock';

$route['admin/bridge/manage']         = 'admin/bridge/bridge/manage_bridge';
$route['admin/bridge/add']            = 'admin/bridge/bridge/add_bridge'; 
$route['admin/bridge/add/(:any)']     = 'admin/bridge/bridge/add_bridge';

$route['admin/user/manage']         = 'admin/user/user/manage_user';
$route['admin/user/manage/(:any)']  = 'admin/user/user/manage_user';
$route['admin/user/add']            = 'admin/user/user/add_user'; 
$route['admin/user/add/(:any)']     = 'admin/user/user/add_user';
