<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bridge extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model("admin/bridge/Bridge_model");
        $isLoggedIn = $this->session->userdata('isLoggedIn');

        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('admin/login');
        }
    }

    /*
        Author     : Naresh Lakhara
        Description: Manage Lock List
        Date       : 21-04-2022
    */
    public function manage_bridge() {   
        
        $this->load->view("admin/bridge/manage_bridge");
    }

    /*
        Author     : Naresh Lakhara
        Description: Manage Lock List
        Date       : 21-04-2022
    */
    public function manage_bridge_ajax() {
        
        $lock_list = $this->Bridge_model->manage_bridge_ajax();
        echo json_encode($lock_list);
        exit;
    } 

    /*
        Author      : Naresh Lakhara
        Description : Add Lock
        Date        : 22-04-2022
    */
    public function add_bridge() {
        
        $qr_string = $this->input->post('qr_string');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('qr_string', 'QR string', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /*Edit Record */
            $data = array();
            $id   = $this->uri->segment(4);
            if($id) {
                $data['edit_bridge'] = $this->Bridge_model->edit_bridge($id);
                // echo '<pre>';print_r($data); exit;
            }
            $this->load->view('admin/bridge/add_bridge',$data);
        }
        else {

            $qr_string = trim($this->input->post('qr_string'));
            $status    = $this->input->post('status');
            $edit_id    = $this->input->post('edit_id');

            $response = $this->Bridge_model->validate_qrstring($qr_string , $edit_id);

            if(!empty($response) && isset($response)) {
                
                $data = array('result' => 'failure', 'message' => 'QR is already exists.');
                echo json_encode($data);
                exit;

            } else {

                $data = array(
                    'qr_string'        => $qr_string,
                    'created_on'       => date("Y-m-d H:i:s"),               
                    'modified_on'      => date("Y-m-d H:i:s"),
                    'status'           => $status,  
                    'is_bridge'        => '1',
                );

                if(!empty(@$edit_id) && isset($edit_id)) {

                    $where_con = array('qr_id' => $edit_id);
                    $result = $this->Common_model->update_by_where_array('zo_lock_qr',$where_con, $data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'QR updated succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'QR not updated please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }

                } else {

                    $result   = $this->Common_model->insert_data('zo_lock_qr',$data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'QR added succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'QR not added please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }
                }
            }            
        }
    } 

    /*
        Author      : Naresh Lakhara
        Description : Regenerate QR
        Date        : 06-05-2022
    */
    public function regenerate_qr() {

        $qr_code = 'idoor-'.$_POST['qr_id'];

        if($qr_code) {

            $PNG_TEMP_DIR   = getcwd().'/uploads/qr_code/'.$qr_code.'_qr_code.png';

            if(!file_exists($PNG_TEMP_DIR)) {
                qr_code_generate($filename = $qr_code, $errorCorrectionLevel = 'L', $matrixPointSize = '10');
            }  

            $data = array('result' => 'success', 'message' => 'QR generated succussfully.');
            echo json_encode($data);
            exit;
        
        } else {

            $data = array('result' => 'failure', 'message' => 'Something went wrong please try again later.');
            echo json_encode($data);
            exit;
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Lock Reset
        Date        : 06-02-2022
    */
    public function bridge_reset() {

        $qr_id = $_POST['qr_id'];

        if($qr_id) {             

            $response = $this->Bridge_model->reset_bridge($qr_id);

            if(!empty($response) && isset($response)) {

                $data = array('result' => 'success', 'message' => 'Lock reset succussfully.');
                echo json_encode($data);
                exit;

            } else {

                $data = array('result' => 'failure', 'message' => 'Something went wrong please try again later.');
                echo json_encode($data);
                exit;
            }

        } else {

            $data = array('result' => 'failure', 'message' => 'Something went wrong please try again later.');
            echo json_encode($data);
            exit;
        }
    }   
}