<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
    Author     : Naresh Lakhara
    Description: Rest API Model setup
    Date       : 03-02-2022 
*/
class Api_model extends CI_Model {
	public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
   	
    /*
		Author     : Naresh Lakhara
		Date       : 04-03-2022
		Description: Login User
	*/
    public function login_user($user_name, $password, $app_info, $device_token, $device_os) {	

    	$qr = "SELECT *  FROM zo_tbl_user WHERE ( email = '$user_name' OR mobile_number = '$user_name' ) AND password = '$password' and status = '1' and is_delete = '0'";
		$query = $this->db->query($qr);

		$final_array = array();
		
		if($query->num_rows() > 0 ) {
			
			$result = $query->row_array();

			if(!empty($result['image']) && isset($result['image'])) {
				$image_url = base_url('uploads/user_image/'.$result['image']); 
			} else {
				$image_url = "";
			}

			$final_array = array(
				'user_id'       => (string)@$result['user_id'],
				'name'          => (string)@$result['name'],
				'email'         => (string)@$result['email'],
				'mobile_number' => (string)@$result['mobile_number'],
				'image'         => (string)@$image_url,
				'is_verify'     => (string)@$result['is_verify'],
			);

			/* Update info */
			$field = array(
				'is_login'			=>	'1',
				'app_info'			=>	@$app_info ? @$app_info : null,
				'device_token'		=>	@$device_token ? @$device_token : null,
				'device_os'			=>	@$device_os ? @$device_os : null,
				'last_logged_in'	=>	date('Y-m-d H:i:s')
			);
			$this->db->where(array('user_id' => $result['user_id']));
			$this->db->set($field);
			$this->db->update('zo_tbl_user');

			return $final_array;

		} else {

			return $final_array;
		}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 04-03-2022
		Description: Logs API
	*/
    public function idoor_logs($mac) {	

    	$qr = "SELECT * FROM idoor_log WHERE mac like '$mac'  ORDER BY l_id DESC ";
		
		$query = $this->db->query($qr);

		$final_array = array();
		
		if($query->num_rows() > 0 ) {			
			$final_array = $query->result_array();			
			return $final_array;
		} else {
			return $final_array;
		}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 04-03-2022
		Description: Logs API
	*/
    public function vc_token_add_update($device_id, $device_type, $device_token, $video_id, $ble_mac) {	

    	if($device_type == 'bell') {

    		if(!empty($ble_mac) && isset($ble_mac)) {

		    	$field_name 	 = array('video_call_id');
		    	$where_condition = array('device_ble_mac' => $ble_mac);
		    	$idoor_data      = $this->Common_model->single_record_fetch($field_name,'idoor_login',$where_condition);

		    	if(!empty($idoor_data) && isset($idoor_data)) {    		
	    			$video_id = $idoor_data['video_call_id'];
		    	} else {
	    			$data = array('status'  => 'false', 'message' => 'Video id not found.');
	            	response($data);
		    	}
    		} else {
    			$data = array('status'  => 'false', 'message' => 'Ble mac not found please check paramter');
            	response($data);
    		}
    	} else {
    		$video_id = $video_id;
    	}

    	$vc_token_data = array(
			'video_id'       => @$video_id ? @$video_id : "",
			'device_type'    => @$device_type ? @$device_type : "",
			'device_id'      => @$device_id ? @$device_id : "",
			'device_ble_mac' => @$ble_mac ? @$ble_mac : "",
			'device_token'   => @$device_token ? @$device_token : "",
    	);

    	$qr = "SELECT * FROM vc_token WHERE device_id = '$device_id'";
		$query = $this->db->query($qr);
		$num_rows = $query->num_rows();

		if(!empty($num_rows) && isset($num_rows)) {

			/*Same device token data available then delete*/
			$where_con = array('device_id' => $device_id);

			if($num_rows > 1){
				
				$this->Common_model->delete_by_where_array('vc_token', $where_con);
            		
            	/* After remove new token added */
            	$last_insert_id = $this->Common_model->insert_data('vc_token', $vc_token_data);

	            if(!empty($last_insert_id) && isset($last_insert_id)) {

	            	$data = array('status'  => 'true', 'message' => 'VC token added successfully.');
		            response($data);
		            exit;

	            } else {
		            $data = array('status'  => 'false', 'message' => 'VC token not added please try after sometime.');
		            response($data);
		            exit;            	
	            }

			} else {

				$last_insert_id = $this->Common_model->update_by_where_array('vc_token',$where_con, $vc_token_data);

	            if(!empty($last_insert_id) && isset($last_insert_id)) {

	            	$data = array('status'  => 'true', 'message' => 'VC token updated successfully.');
		            response($data);
		            exit;

	            } else {
		            $data = array('status'  => 'false', 'message' => 'VC token not updated please try after sometime.');
		            response($data);
		            exit;            	
	            }
			}

		} else {

            $last_insert_id = $this->Common_model->insert_data('vc_token',$vc_token_data);

            if(!empty($last_insert_id) && isset($last_insert_id)) {

            	$data = array('status'  => 'true', 'message' => 'VC token added successfully.');
	            response($data);
	            exit;

            } else {
	            $data = array('status'  => 'false', 'message' => 'VC token not added please try after sometime.');
	            response($data);
	            exit;            	
            }
		}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 04-03-2022
		Description: FCM send to bell call door
	*/
    public function fcm_send_to_bell_call_door($bell_ble_mac, $device_type, $lock_mac, $btn_action) {

    	$qr = "SELECT door_video_id FROM `bell_call_door` WHERE `bell_ble_mac`='$bell_ble_mac' ";
		
		$query = $this->db->query($qr);

		$final_array = array();
		
		if($query->num_rows() > 0 ) {

			$record = $query->result_array();

			foreach ($record as $key => $value) {
				
            	$door_video_id = $value['door_video_id'];

            	$response = $this->Common_model->Send_FCM($door_video_id, $device_type, $lock_mac, $btn_action);

            	if ($response == 'true') {
	                $result["status"] = "true";
	            } else {
	                $result["status"] = "false";
	            }
			}
			response($result);			
		} else {
        	
        	$result["status"] = "false";
			response($result);
		}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 05-04-2022
		Description: Scan QR
	*/
    public function scan_qr($qr_string, $u_id) {	

    	$qr = "SELECT * FROM `lock_QR` WHERE `qr_one_time`='$qr_string' ";
		$query = $this->db->query($qr);
		$final_array = array();
	
		if($query->num_rows() > 0 ) {
			
			if($query->num_rows() == '1') {
				
				$result        = $query->row_array();		
				$qr_id         = $result['qr_id'];
				$qr_scan_count = $result['qr_scan_count'];
				$qr_scan_count++;
				
				/*Qr Code Update*/
            	$sql = "UPDATE `lock_QR` SET `qr_scan_count` = '$qr_scan_count', `qr_one_time` = NULL WHERE `qr_one_time`='$qr_string' ";
				$query = $this->db->query($sql);

				if(!empty($query) && isset($query)) {

					$query_lfa = "SELECT * FROM `lock_family_access` WHERE `qr_id`='$qr_id' AND `u_id`='$u_id'";
					$fquery    = $this->db->query($query_lfa);

					if($fquery->num_rows() == '0') {
						$in_q = "INSERT INTO `lock_family_access` (`u_id`, `qr_id`)  VALUES ('$u_id','$qr_id')";
						$query = $this->db->query($in_q);
					}

					$response["status"]  = "true";
					$response['message'] = "Successfully";
					$response['Lock_QR'] = $result['qr_string'];
            		response($response);

				} else {

					$response["status"] = "false";
					$response['message'] = "QR Count Update Erorr ";
            		response($response);
				}

			} else {

				$response["status"] = "false";
				$response['message'] = "Multiple One Time QR value In our database ";
            	response($response);
			}

		} else {

	    	$qr    = "SELECT * FROM `lock_QR` WHERE `qr_id`='$qr_string'";
			$query = $this->db->query($qr);
			
			if($query->num_rows() > 0 ) {

				if($query->num_rows() == '1') {

			    	$qr2    = "SELECT * FROM `lock_QR` WHERE `qr_id`='$qr_string' AND `u_id` = '$u_id'";
					$query2 = $this->db->query($qr2);

					if($query2->num_rows() > 0 ) {

						if($query2->num_rows() == '1') {

							$result2       = $query2->row_array();
							$qr_scan_count = $result2['qr_scan_count'];
            				$qr_scan_count++;

							$query3    = "UPDATE `lock_QR` SET `qr_scan_count` = '$qr_scan_count' WHERE `qr_id`='$qr_string' AND `u_id` = '$u_id' ";
							$query_ext = $this->db->query($query3);

							if ($query_ext) {

								$response["status"]  = "true";
								$response['message'] = "Successfully";
								$response['Lock_QR'] = $result2['qr_string'];
            					response($response);							    
							
							} else {
							
								$response["status"]  = "false";
								$response['message'] = "QR Count Update Erorr ";
								response($response);
							}

						} else {

							$response["status"]  = "false";
							$response['message'] = "Lock ID AND User ID Multiples";
							response($response);
						}

					}  else {

						$response["status"]  = "false";
						$response['message'] = "Lock ID Not Assign User ID";
						response($response);
					}

				} else {

					$response["status"]  = "false";
					$response['message'] = "Multiple Lock ID";
					response($response);
				}

			} else {

				$response["status"]  = "false";
				$response['message'] = "QR Value Not Register in Our Database";
				response($response);
			}
		}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 05-04-2022
		Description: Bell Call Door, Clone of Old Code
	*/
    public function bell_call_door($action, $bell_ble_mac, $door_video_id) {

		$final_array = array();
    	$result      = array();

    	if(!empty($action) && isset($action) && !empty($bell_ble_mac) && isset($bell_ble_mac) & !empty($door_video_id) && isset($door_video_id)) {

    		if($action == 'insert') {

    			$query   = "SELECT * FROM `bell_call_door` WHERE `bell_ble_mac`= '$bell_ble_mac' AND `door_video_id`= '$door_video_id'";
				$queryexe = $this->db->query($query);

				if($queryexe->num_rows() == '0') {

            		$sql = "INSERT INTO `bell_call_door`(`bell_ble_mac`, `door_video_id`, `lock_mac`) VALUES ('$bell_ble_mac', '$door_video_id','')";

					$queryexe2 = $this->db->query($sql);

					if($queryexe2) {

						$query_login = "SELECT * FROM `idoor_login` WHERE `device_ble_mac`='$bell_ble_mac'";
						$queryexe3   = $this->db->query($query_login);

						if($queryexe3->num_rows() == '1') {

							$row_login = $queryexe3->row_array();	

							$result["video_call_id"] = $row_login['video_call_id'];
							$result["status"]        = "true";

							if (isset($_POST['lock_mac']) && !empty($_POST['lock_mac'])) {

							    $lock_mac   = $_POST['lock_mac'];
							    $q2 		= "UPDATE `bell_call_door` SET `lock_mac` = '$lock_mac' WHERE `bell_ble_mac` = '$bell_ble_mac'";
								$queryexe4  = $this->db->query($q2);

						        if ($queryexe4) {
						            $result["status"] = "true";
						        } else {
						            $result["status"] = "false";
						        }

							} else {

								$q3             = "SELECT * FROM `bell_call_door` WHERE `bell_ble_mac`= '$bell_ble_mac'";
								$q3_exe         = $this->db->query($q3);
								$bell_call_door = $q3_exe->result_array();

								foreach ($bell_call_door as $key => $value) {
									
									$lock_mac= $value['lock_mac'];

									if ($this->db->query("UPDATE `bell_call_door` SET `lock_mac` = '$lock_mac' WHERE `bell_ble_mac` = '$bell_ble_mac'")) {
									    $result["status"] = "true";
									} else {
									    $result["status"] = "false";
									}
								}							    
							}

						}

					} else {

                		$result["status"] = "false";
                		response($result);
					}

				} else {

					$query_login = "SELECT * FROM `idoor_login` WHERE `device_ble_mac`='$bell_ble_mac'";
					$exe1 = $this->db->query($query_login);

					if ($exe1->num_rows() == 1) {

						$row_login               = $exe1->row_array();
						$result['video_call_id'] = $row_login['video_call_id'];
						$result["status"]        = "true";

					    if (isset($_POST['lock_mac']) && !empty($_POST['lock_mac'])) {

					        $lock_mac = $_POST['lock_mac'];

				            if ($this->db->query("UPDATE `bell_call_door` SET `lock_mac` = '$lock_mac' WHERE `bell_ble_mac` = '$bell_ble_mac'")) {
				                $result["status"] = "true";
				            } else {
				                $result["status"] = "false";
				            }

					    } else {

					    	$q3             = "SELECT * FROM `bell_call_door` WHERE `bell_ble_mac`= '$bell_ble_mac'";
					    	$q3_exe         = $this->db->query($q3);
					    	$bell_call_door = $q3_exe->result_array();

					    	foreach ($bell_call_door as $key => $value) {
					    		
					    		$lock_mac= $value['lock_mac'];

					    		if ($this->db->query("UPDATE `bell_call_door` SET `lock_mac` = '$lock_mac' WHERE `bell_ble_mac` = '$bell_ble_mac'")) {
					    		    $result["status"] = "true";
					    		} else {
					    		    $result["status"] = "false";
					    		}
					    	}
					    }
					
					} else {

						$result['video_call_id'] = '';
						$result["status"]        = "false";
					}
				}

				$this->Common_model->iBell_Sync_Send_FCM($bell_ble_mac);

    		} elseif ($action == 'delete') {
    			
    			$sql = "DELETE FROM `bell_call_door` WHERE `bell_ble_mac`= '$bell_ble_mac' AND `door_video_id`= '$door_video_id'";

    			if ($this->db->query($sql)) {
    			    $result['video_call_id'] = '';
    			    $result["status"] = "true";
    			} else {
    			    $result['video_call_id'] = '';
    			    $result["status"] = "false";
    			}

				$this->Common_model->iBell_Sync_Send_FCM($bell_ble_mac);
    		}

			response($result);

    	} else if (!empty($bell_ble_mac) && isset($bell_ble_mac)) {
    		
	    	$qr = "SELECT * FROM `bell_call_door` WHERE `bell_ble_mac`= '$bell_ble_mac' ";
			$query = $this->db->query($qr);
			$final_array = $query->result_array();	
			response($final_array);

    	} else {

			response($final_array);
    	}
    }

    /*
		Author     : Naresh Lakhara
		Date       : 12-04-2022
		Description: Logout User
	*/
	public function user_logout($user_id) {
		$where_con = array('user_id'  => $user_id);
		$field     = array('is_login' => '0');
		$this->db->where($where_con);
		$this->db->set($field);
		$this->db->update('zo_tbl_user');
		$upated_rows = $this->db->affected_rows();		
		return $upated_rows;
	}

	/*
		Author     : Naresh Lakhara
		Date       : 07-04-2022
		Description: Update Device Token
	*/
	public function updatedeviceToken($u_id, $device_token, $app_info, $device_os)
	{
		$field = array('device_token' => $device_token , 'app_info' => @$app_info,  'device_os' => @$device_os);
		$this->db->where(array('user_id' => $u_id ));
		$this->db->set($field);
		$ret      = $this->db->update('zo_tbl_user');
		$aff_row  = $this->db->affected_rows();
		return $aff_row;
	}

	/*
		Author     : Naresh Lakhara
		Date       : 07-04-2022
		Description: Sync Details Fetch
	*/
	public function sync_details($user_id) {

		$sync_q    = "SELECT zyl.sync_lock_id,zyl.qr_id,zlq.qr_string,zyl.ref_lock_name,zyl.user_id,zyl.user_type, zyl.is_bridge FROM zo_sync_lock as zyl
		JOIN zo_lock_qr as zlq on zlq.qr_id = zyl.qr_id 
		WHERE zyl.user_id = '$user_id' AND zyl.status = '1' AND zyl.is_delete = '0' ";
		$exe = $this->db->query($sync_q);

		$final_array = array();

		if($exe->num_rows() > 0 ) {

			$data_get  = $exe->result_array(); 

			foreach ($data_get as $key => $value) {
					
				$assign_lock_q = "SELECT GROUP_CONCAT(sync_lock_id) as sync_lock_id FROM `zo_sync_lock` 
				WHERE qr_id = '".@$value['qr_id']."'";

				if($value['user_type'] == '2') {
					$assign_lock_q .= " AND user_type = '2'";
				}
				$exe           = $this->db->query($assign_lock_q);
				$data_get  	   = $exe->row_array(); 
				$sync_lock_ids = $data_get['sync_lock_id'];

				$finger_q    = "SELECT l_f.finger_id, l_f.finger_name, l_f.sync_lock_id, t_s_l.qr_id, l_f.setup, l_f.last_step, 
					l_f.user_id, t_u.name, t_u.email, (SELECT user_type FROM zo_sync_lock WHERE qr_id=t_s_l.qr_id AND user_id=l_f.user_id) as user_type  FROM zo_lock_finger as l_f
					JOIN zo_tbl_user as t_u on t_u.user_id = l_f.user_id 
					JOIN zo_sync_lock as t_s_l on t_s_l.sync_lock_id = l_f.sync_lock_id
					WHERE l_f.sync_lock_id IN ($sync_lock_ids)  AND l_f.status = '1' AND l_f.is_delete = '0' ";
				$exe2         = $this->db->query($finger_q);

				$finger_data  = $exe2->result_array(); 

				$final_array[] = array(
					'sync_lock_id'    => (string)@$value['sync_lock_id'],
					'qr_id'           => (string)@$value['qr_id'],
					'qr_string'       => (string)@$value['qr_string'],
					'ref_lock_name'   => (string)@$value['ref_lock_name'],
					'user_id'         => (string)@$value['user_id'],
					'user_type'       => (string)@$value['user_type'],
					'is_bridge'       => (string)@$value['is_bridge'],
					'fingerprint'	  => (array)@$finger_data, 					
				);
			}

			return $final_array;
					
		} else {

			return $final_array;
		}
	}

	/*
		Author     : Naresh Lakhara
		Date       : 13-04-2022
		Description: Verify QR Code
	*/
	public function verify_qr($user_id, $qr_string) {

		$sync_q   = "SELECT * FROM zo_lock_qr WHERE (qr_id = '$qr_string') AND status = '1' AND is_delete = '0' ";
		$exe      = $this->db->query($sync_q);

		$final_array = array();

		if($exe->num_rows() > 0 ) {

			$data_get  			 = $exe->row_array(); 
			$assign_lock_user_id = $data_get['u_id'];

			/* Collect QR string and QR ID */
			$data = array(
				'qr_id'     => (string)@$data_get['qr_id'],
				'lockQR'    => (string)@$data_get['qr_string'],
				'is_bridge' => (string)@$data_get['is_bridge'],
			);

			if(!empty($assign_lock_user_id) && isset($assign_lock_user_id)) {

				if($assign_lock_user_id == $user_id) {

					// /*Update User ID aggines QR*/
					// $qr_scan_count = ++$data_get['qr_scan_count'];
					// $up_data   = array('u_id' => $user_id, 'qr_scan_count' => $qr_scan_count);
					// $where_con = array('qr_id' => $data_get['qr_id']);
					// $this->Common_model->update_by_where_array('zo_lock_qr', $where_con, $up_data );
				
					$result = array('status' => 'true', 'message' => 'User is authorised to scan this QR.', 'data' => (array)$data);
		            response($result);
				
				} else {

					$result = array('status' => 'false', 'message' => 'User is not authorised to scan this QR.');
		            response($result);
				}

			} else {

				// /*Update User ID aggines QR*/
				// $up_data   = array('u_id' => $user_id, 'qr_scan_count' => '1');
				// $where_con = array('qr_id' => $data_get['qr_id']);
				// $this->Common_model->update_by_where_array('zo_lock_qr', $where_con, $up_data );

				$result = array('status' => 'true', 'message' => 'User is authorised to scan this QR', 'data' => (array)$data);
		        response($result);
			}
								
		} else {

			$result = array('status' => 'false', 'message' => 'QR code not found');
            response($result);
		}
	}

	/*
		Author     : Naresh Lakhara
		Date       : 13-04-2022
		Description: Verify QR Code
	*/
	public function invite_user($user_id, $qr_string, $email, $ref_lock_name) {
		
		$invitee_q          = "SELECT * FROM zo_lock_qr 
		WHERE (qr_string = '$qr_string' AND u_id ='$user_id' AND status = '1' AND is_delete = '0' )";		
		$exe        		= $this->db->query($invitee_q);		
		$lock_data_fetch  = $exe->row_array(); 
		
		if(!empty($lock_data_fetch) && isset($lock_data_fetch)) {

			$field      = array('sync_lock_id','qr_id','user_type','user_id','ref_lock_name');
			$where_con  = array('qr_id' => $lock_data_fetch['qr_id'] , 'user_id' => $user_id , 'user_type' => '1', 'status' => '1' , 'is_delete' => '0');
			$usert_type_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);  			

			/* MASTER USER CAN ONLY INVITE */
			if(!empty($usert_type_check) && isset($usert_type_check)) {

				/* INVITED USER IS AVAILABLE OR NOT CHECK*/
				$email_c     = "SELECT * FROM zo_tbl_user WHERE email = '$email' AND is_delete = '0' ";
				$exe1        = $this->db->query($email_c);
				$user_fetch  = $exe1->row_array();

				/* SEND EMAIL WHEN INVITE USER */
				$u_email     = "SELECT * FROM zo_tbl_user WHERE user_id = '$user_id' AND is_delete = '0' ";
				$exe2        = $this->db->query($u_email);
				$user_info   = $exe2->row_array();	

				/* USER CAN INVITE YOURSELF ONLY */
				if(@$user_fetch['user_id'] == @$user_id) {

					$result = array('status' => 'false', 'message' => 'Sorry ! you can not invite yourself.');
					response($result);

				} else {

					if(!empty($user_fetch) && isset($user_fetch)) {
					
		                $field      = array('invite_id');
		            	$where_con  = array('invite_user_id' => $user_id , 'qr_id' => $lock_data_fetch['qr_id'], 'family_user_id' => $user_fetch['user_id'], 'status' => '1', 'is_delete' => '0');
		            	$check_user = $this->Common_model->single_record_fetch($field, 'zo_user_invite', $where_con);   
						
						if(!empty($check_user) && isset($check_user)) {
					
							$invieee_user_data = array(
								'invite_user_id'   => $user_id,
								'qr_id'            => $lock_data_fetch['qr_id'],
								'family_user_id'   => $user_fetch['user_id'],
								'ref_lock_name'    => $ref_lock_name,				
								'invite_date_time' => date("Y-m-d H:i:s"),
								'request_type'     => '0',
								'status'           => '1',
								'created_on'       => date("Y-m-d H:i:s"),
								'modified_on'      => date("Y-m-d H:i:s"),
			                );

		            		$insert_id = $this->Common_model->insert_data('zo_user_invite', $invieee_user_data);
		            		$result = array('status' => 'true', 'message' => 'Invited successfully.');

		            		$subject = "iDoor Lock Invitation";
		            		$message = "<html>
		            		                <body>
		            		                <p>
		            		                	You are invited by <b>".$user_info['name']."</b> for iDoor lock <b>".$ref_lock_name.".</b><br>
		            							If you not registered using this email,<br> 
		            							Please registered your self first and login to iDoor app.<br> 
		            							Open request section and accept request to add iDoor lock to home section.<br><br>
		            		                	<br>Regards,<br>
		            		               	 	Team Idoor.
		            		                </p>
		            		                </body>
		            		            </html>";

		            		$to = $email;
		            		$mail_response = $this->Common_model->email_send($to,$subject,$message);

		            		/* PUSH NOTIFICAION SEND */
		            		$push_data  = array(
		            		    'title'       => 'iDoor',
		            		    'tag'         => 'invite_user',
		            		    'user_id' 	  =>  @$user_fetch['user_id'],
		            		    'body'        =>  "You are invited by ".@$user_info['name'],
		            		    'sound'       => 'default',
		            		    'badge'       => '1'
		            		);

		            		$final_push    = json_encode($push_data);
		            		$this->Common_model->send_push_notification(@$user_fetch['user_id'],'idoor_app', $final_push);		            		
		            		/* PUSH NOTIFICAION END SEND */


		            		response($result);

						} else {

							$invieee_user_data = array(
								'invite_user_id'   => $user_id,
								'qr_id'            => $lock_data_fetch['qr_id'],
								'family_user_id'   => $user_fetch['user_id'],
								'ref_lock_name'    => $ref_lock_name,								
								'invite_date_time' => date("Y-m-d H:i:s"),
								'request_type'     => '0',
								'status'           => '1',
								'created_on'       => date("Y-m-d H:i:s"),
								'modified_on'      => date("Y-m-d H:i:s"),
			                );

		            		$insert_id = $this->Common_model->insert_data('zo_user_invite', $invieee_user_data);

		            		$subject = "iDoor Lock Invitation";
		            		$message = "<html>
		            		                <body>
		            		                <p>
		            		                	You are invited by <b>".$user_info['name']."</b> for iDoor lock <b>".$ref_lock_name.".</b><br>
		            							If you not registered using this email,<br> 
		            							Please registered your self first and login to iDoor app.<br> 
		            							Open request section and accept request to add iDoor lock to home section.<br><br>
		            		                	<br>Regards,<br>
		            		               	 	Team Idoor.
		            		                </p>
		            		                </body>
		            		            </html>";

		            		$to = $email;
		            		$mail_response = $this->Common_model->email_send($to,$subject,$message);

		            		/* PUSH NOTIFICAION SEND */
		            		$push_data  = array(
		            		    'title'       => 'iDoor',
		            		    'tag'         => 'invite_user',
		            		    'user_id' 	  =>  @$user_fetch['user_id'],
		            		    'body'        =>  "You are invited by ".@$user_info['name'],
		            		    'sound'       => 'default',
		            		    'badge'       => '1'
		            		);

		            		$final_push    = json_encode($push_data);
		            		$this->Common_model->send_push_notification(@$user_fetch['user_id'],'idoor_app', $final_push);

		            		$result = array('status' => 'true', 'message' => 'Invited successfully.');
		            		response($result);
						}	            	

					}  else {

						$user_reg = array(
							'email'       => $email,
							'created_on'  => date("Y-m-d H:i:s"),
							'modified_on' => date("Y-m-d H:i:s"),
							'status' 	  => '2',
						);

		                $last_id = $this->Common_model->insert_data('zo_tbl_user', $user_reg);                
						
		                if(!empty($last_id) && isset($last_id)) {

		                	$invieee_user_data = array(
								'invite_user_id'   => $user_id,
								'qr_id'            => $lock_data_fetch['qr_id'],
								'family_user_id'   => $last_id,
								'ref_lock_name'    => $ref_lock_name,
								'invite_date_time' => date("Y-m-d H:i:s"),
								'request_type'     => '0',
								'status'           => '1',
								'created_on'       => date("Y-m-d H:i:s"),
								'modified_on'      => date("Y-m-d H:i:s"),
		                	);

		                	$insert_id = $this->Common_model->insert_data('zo_user_invite', $invieee_user_data);

		                	if($insert_id) {		                					

		                		$subject = "iDoor Lock Invitation";
		                		$message = "<html>
		                		                <body>
		                		                <p>
		                		                	You are invited by <b>".$user_info['name']."</b> for iDoor lock <b>".$ref_lock_name.".</b><br>
		                							If you not registered using this email,<br> 
		                							Please registered your self first and login to iDoor app.<br> 
		                							Open request section and accept request to add iDoor lock to home section.<br><br>
		                		                	<br>Regards,<br>
		                		               	 	Team Idoor.
		                		                </p>
		                		                </body>
		                		            </html>";

		                		$to = $email;
		                		$mail_response = $this->Common_model->email_send($to,$subject,$message);

		                		/* PUSH NOTIFICAION SEND */
		                		$push_data  = array(
		                		    'title'       => 'iDoor',
		                		    'tag'         => 'invite_user',
		                		    'user_id' 	  =>  @$user_fetch['user_id'],
		                		    'body'        =>  "You are invited by ".@$user_info['name'],
		                		    'sound'       => 'default',
		                		    'badge'       => '1'
		                		);

		                		$final_push    = json_encode($push_data);
		                		$this->Common_model->send_push_notification(@$user_fetch['user_id'],'idoor_app', $final_push);

		                		$result = array('status' => 'true', 'message' => 'Invited successfully.');
		                		response($result);

		                	} else {

		                		$result = array('status' => 'false', 'message' => 'You can not invite please try again later.');
		                		response($result);
		                	}

		                } else {

		                	$result = array('status' => 'false', 'message' => 'You can not invite please try again later.');
		                	response($result);
		                }
					}									
				}

			} else {

				$result = array('status' => 'false', 'message' => 'Master user can only invite.');
				response($result);
			}

		} else {

			$result = array('status' => 'false', 'message' => 'QR lock not found.');
			response($result);
		}
	}

	/*
		Author     : Naresh Lakhara
		Date       : 14-04-2022
		Description: Verify User
	*/
	public function verify_user($email, $user_id) {

		$u_check = "SELECT user_id, email,status, is_delete, is_verify FROM zo_tbl_user 
		WHERE (email = '$email' AND is_delete = '0')";

		if(!empty($user_id) && isset($user_id)) {
			$u_check .= " AND user_id != '$user_id' ";
		}

		$exe        = $this->db->query($u_check);
		$user_info  = $exe->row_array(); 
		
		if(!empty($user_info) && isset($user_info)) {

			if($user_info['status'] == '2') {

				$message      = "Invitee User Can update your profile";
				$result_flag  = "true";
				$status 	  = @$user_info['status'];
				$user_id 	  = @$user_info['user_id'];
			
			} else if($user_info['status'] == '1') {

				$message      = "Email address already exist.";
				$result_flag  = "false";
				$status 	  = @$user_info['status'];
				$user_id 	  = "0";

			} else {

				$message      = "Email not found our system so you can register.";
				$result_flag  = "true";
				$status 	  = "0";
				$user_id 	  = "0";				
			}

		} else {

			$message      = "Email not found our system so you can register.";
			$result_flag  = "true";
			$status 	  = "0";
			$user_id 	  = "0";
		}
		$final_array = array('result' => (string)$result_flag, 'message' => (string)$message, 'status' => (string)$status, 'user_id' => (string)@$user_id); 
		return $final_array;
	}

	/*
		Author      : Naresh Lakhara
		Date        : 14-04-2022
		Description : Invited Details fetch
		Note 		: 1 = Master User, 2 = Family User
	*/
	public function invite_user_list($user_id, $user_type, $qr_id) {

		$sync_q    = "SELECT zut.invite_id,zut.invite_user_id,zut.qr_id,zut.family_user_id,zut.invite_date_time,
		zut.accept_date_time,zut.request_type, zlq.qr_string, zut.status,zut.ref_lock_name ,zyl.ref_lock_name as parent_ref_lock_name 
		FROM zo_user_invite as zut 
		LEFT JOIN zo_sync_lock as zyl on zyl.qr_id = zut.qr_id AND zyl.user_id = zut.invite_user_id 
		LEFT JOIN zo_lock_qr as zlq on zlq.qr_id = zut.qr_id
		WHERE zut.is_delete = '0' AND zut.status = '1' ";

		if($user_type == '1') {
			$sync_q.= " AND zut.invite_user_id = '$user_id' AND zut.request_type != '2'";			
		} else {
			$sync_q.= " AND zut.family_user_id = '$user_id' AND zut.request_type IN(0,1)";			
		}

		if(!empty($qr_id) && isset($qr_id)) {
			$sync_q.= " AND zut.qr_id = '$qr_id'";	
		}

		$sync_q .= " GROUP BY zut.invite_id  ORDER BY zut.invite_id DESC";

		$exe = $this->db->query($sync_q);

		$final_array = array();

		if($exe->num_rows() > 0 ) {

			$data_get  = $exe->result_array(); 

			foreach ($data_get as $key => $value) {
				
				$field      = array('user_id','name','email');
				$where_con  = array('user_id' => @$value['invite_user_id']);
				$invite_user_data = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con); 

				$field      = array('user_id','name','email');
				$where_con  = array('user_id' => @$value['family_user_id']);
				$family_user_data = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);            

				if(@$value['request_type'] == '1') {
					$request_type = 'Active';
				} elseif(@$value['request_type'] == '2') {
					$request_type = 'Revoke';
				} else {
					$request_type = 'Invite';
				}

				$final_array[] = array(
					'invite_id'            => (string)@$value['invite_id'],
					'invite_user_id'       => (string)@$value['invite_user_id'],
					'invited_user_name'    => @$invite_user_data['name'] ? (string)@$invite_user_data['name'] : "",
					'qr_id'                => (string)@$value['qr_id'],
					'qr_string'            => (string)@$value['qr_string'],
					'family_user_id'       => (string)@$value['family_user_id'],
					// 'family_user_name'     =>  @$family_user_data['name'] ? (string)@$family_user_data['name'] : "",
					'family_user_name'    =>  @$family_user_data['email'] ? (string)@$family_user_data['email'] : "",
					'invite_date_time'     => (string)@$value['invite_date_time'],
					'accept_date_time'     => (string)@$value['accept_date_time'],
					'parent_ref_lock_name' => (string)@$value['parent_ref_lock_name'],					
					'ref_lock_name'        => (string)@$value['ref_lock_name'],					
					'request_type'         => (string)@$request_type,
				);
			}	

			return $final_array;
					
		} else {

			return $final_array;
		}
	}

	/*
		Author     : Naresh Lakhara
		Date       : 14-04-2022
		Description: Approve invited user
	*/
	public function approve_invited_user($invite_id) {

		$u_check = "SELECT * FROM zo_user_invite WHERE invite_id = '$invite_id' AND status = '1' AND is_delete = '0' ";		
		$exe        = $this->db->query($u_check);
		$invited_data  = $exe->row_array(); 

		if(!empty($invited_data) && isset($invited_data)) {

			$udpate_info = array(
				'accept_date_time' => date("Y-m-d H:i:s"),
				'request_type'     => '1',
				'modified_on'      => date("Y-m-d H:i:s"),
			);
			$where_con = array('invite_id' => $invite_id);
            $update_id = $this->Common_model->update_by_where_array('zo_user_invite', $where_con, $udpate_info);

            if(!empty($update_id) && isset($update_id)) {            	

            	/* LOCK CHECK */
            	$field      = array('sync_lock_id');
            	$where_con  = array(
					'qr_id'     => @$invited_data['qr_id'] , 
					'user_id'   => @$invited_data['family_user_id'] ,  
					'user_type' => '2',
            	);
            	$sync_lock_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

            	if(!empty($sync_lock_check) && isset($sync_lock_check)) {

            		$synk_lock_for_family = array(
						'qr_id'         => (string)@$invited_data['qr_id'],
						'ref_lock_name' => (string)@$invited_data['ref_lock_name'],
						'user_id'       => (string)@$invited_data['family_user_id'],
						'user_type'     => '2',
						'modified_on'   => date("Y-m-d H:i:s"),
						'status'		=> '1',
	            	);

                    $last_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $synk_lock_for_family );

                    if(!empty($last_id) && isset($last_id)) {

                    	/* PUSH NOTIFICAION SEND */
                    	$field        = array('user_id','name');
                    	$where_con    = array('user_id' => @$invited_data['family_user_id']);
                    	$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

                    	$push_data  = array(
                    	    'title'       => 'iDoor',
                    	    'tag'         => 'approve_invited_user',
                    	    'user_id' 	  =>  @$invited_data['invite_user_id'],
                    	    'body'        =>  "Invitation accepted by ".@$user_info['name'],
                    	    'sound'       => 'default',
                    	    'badge'       => '1'
                    	);
                    	$final_push    = json_encode($push_data);
                    	$this->Common_model->send_push_notification(@$invited_data['invite_user_id'],'idoor_app', $final_push);
                    	/* PUSH NOTIFICAION END SEND */

                    	$result = array('status' => "true", 'message' => "Accepted successfully.");
                    	response($result);

                    } else {

                    	$result = array('status' => 'false', 'message' => 'Something error found please try again later.' );
                    	response($result);
                    } 

            	} else {

	            	$synk_lock_for_family = array(
						'qr_id'         => (string)@$invited_data['qr_id'],
						'ref_lock_name' => (string)@$invited_data['ref_lock_name'],
						'user_id'       => (string)@$invited_data['family_user_id'],
						'user_type'     => '2',
						'created_on'    => date("Y-m-d H:i:s"),
						'modified_on'   => date("Y-m-d H:i:s"),
	            	);

	            	$last_id = $this->Common_model->insert_data('zo_sync_lock', $synk_lock_for_family);

	            	if(!empty($last_id) && isset($last_id)) {

	            		/* PUSH NOTIFICAION SEND */
	            		$field        = array('user_id','name');
	            		$where_con    = array('user_id' => @$invited_data['family_user_id']);
	            		$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

	            		$push_data  = array(
	            		    'title'       => 'iDoor',
	            		    'tag'         => 'approve_invited_user',
	            		    'user_id' 	  =>  @$invited_data['invite_user_id'],
	            		    'body'        =>  "Invitation approved by ".@$user_info['name'],
	            		    'sound'       => 'default',
	            		    'badge'       => '1'
	            		);

	            		$final_push    = json_encode($push_data);
	            		$this->Common_model->send_push_notification(@$invited_data['invite_user_id'],'idoor_app', $final_push);
	            		/* PUSH NOTIFICAION END SEND */

	            		$result = array('status' => "true", 'message' => "Accepted successfully.");
	            		response($result);

	            	} else {

	            		$result = array('status' => 'false', 'message' => 'Something error found please try again later.' );
	            		response($result);
	            	} 
            	}
            	           
            } else {

				$result = array('status' => 'false', 'message' => 'Something error found please try again later.' );
				response($result);
            }

		} else {

			$result = array('status' => 'false', 'message' => 'Invited data not found.' );
			response($result);
		}
	}

	/*
		Author     : Naresh Lakhara
		Date       : 14-04-2022
		Description: Revoke Invited User
	*/
	public function revoke_invited_user($invite_id, $user_id) {

		$u_check = "SELECT * FROM zo_user_invite WHERE invite_id = '$invite_id' AND status = '1' AND is_delete = '0' ";		
		$exe        = $this->db->query($u_check);
		$invited_data  = $exe->row_array(); 

		if(!empty($invited_data) && isset($invited_data)) {
		
			if($invited_data['request_type'] == '0') {

            	if($invited_data['invite_user_id'] == $user_id)  {

            		$invited_data_array = array(
						'invite_user_id'   => (string)@$invited_data['invite_user_id'],
						'qr_id'            => (string)@$invited_data['qr_id'],
						'family_user_id'   => (string)@$invited_data['family_user_id'],
						'ref_lock_name'    => (string)@$invited_data['ref_lock_name'],
						'invite_date_time' => date("Y-m-d H:i:s"),
						'accept_date_time' => date("Y-m-d H:i:s"),
						'request_type'     => '2',
						'created_on'       => date("Y-m-d H:i:s"),
						'modified_on'      => date("Y-m-d H:i:s"),
		            );

		            $last_id = $this->Common_model->insert_data('zo_user_invite', $invited_data_array);

		            if(!empty($last_id) && isset($last_id)) {

			            /* PUSH NOTIFICAION SEND */
	            		$field        = array('user_id','name');
	            		$where_con    = array('user_id' => @$invited_data['invite_user_id']);
	            		$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

	            		$push_data  = array(
	            		    'title'       => 'iDoor',
	            		    'tag'         => 'revoke_invited_user',
	            		    'user_id'     =>  @$invited_data['family_user_id'],
	            		    'body'        =>  "Invitation reject by ".@$user_info['name'],
	            		    'sound'       => 'default',
	            		    'badge'       => '1'
	            		);

	            		$final_push    = json_encode($push_data);
	            		$this->Common_model->send_push_notification(@$invited_data['family_user_id'],'idoor_app', $final_push);
	            		/* PUSH NOTIFICAION END SEND */

		            	/*if user reject invitation then. origional initation entry set as suspended*/
		            	$synk_lock_for_family = array('status' 	  => '0');
		            	$where_con2 		  = array('invite_id' => $invite_id);
			            $this->Common_model->update_by_where_array('zo_user_invite', $where_con2, $synk_lock_for_family ); 
                		
    		        	/*$field      =   array('sync_lock_id');
    		        	$where_con  =   array(
    						'qr_id'     => @$invited_data['qr_id'] , 
    						'user_id'   => @$invited_data['family_user_id'] ,  
    						'user_type' => '2',
    		        	);
    		        	$sync_lock_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

    		        	if(!empty($sync_lock_check) && isset($sync_lock_check)) {

    		        		$synk_lock_for_family = array('status' => '0', 'modified_on'   => date("Y-m-d H:i:s"));
    		                $last_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $synk_lock_for_family ); */
    		            
	    		            $result = array('status' => 'true', 'message' => 'Reject successfully.' );
		            		response($result);

    		            /*} else {

    		            	$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
    		            	response($result);
    		            }*/

		        	} else {

	            		$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
	            		response($result);
		        	}            		
            	} else {
            	            		
					$invited_data_array = array(
						'invite_user_id'   => (string)@$invited_data['invite_user_id'],
						'qr_id'            => (string)@$invited_data['qr_id'],
						'family_user_id'   => (string)@$invited_data['family_user_id'],
						'ref_lock_name'    => (string)@$invited_data['ref_lock_name'],
						'invite_date_time' => date("Y-m-d H:i:s"),
						'accept_date_time' => date("Y-m-d H:i:s"),
						'request_type'     => '2',
						'created_on'       => date("Y-m-d H:i:s"),
						'modified_on'      => date("Y-m-d H:i:s"),
		            );

		            $last_id = $this->Common_model->insert_data('zo_user_invite', $invited_data_array);

		            if(!empty($last_id) && isset($last_id)) {

		            	/* PUSH NOTIFICAION SEND */
		            	$field        = array('user_id','name');
		            	$where_con    = array('user_id' => @$invited_data['family_user_id']);
		            	$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

		            	$push_data  = array(
		            	    'title'       => 'iDoor',
		            	    'tag'         => 'revoke_invited_user',
		            	    'user_id'     =>  @$invited_data['invite_user_id'],
		            	    'body'        =>  "Invitation reject by ".@$user_info['name'],
		            	    'sound'       => 'default',
		            	    'badge'       => '1'
		            	);
		            	$final_push    = json_encode($push_data);
		            	$this->Common_model->send_push_notification(@$invited_data['invite_user_id'],'idoor_app', $final_push);
		            	/* PUSH NOTIFICAION END SEND */

		            	/*if user reject invitation then. origional initation entry set as suspended*/
		            	$synk_lock_for_family = array('status' 	  => '0');
		            	$where_con2 		  = array('invite_id' => $invite_id);
			            $this->Common_model->update_by_where_array('zo_user_invite', $where_con2, $synk_lock_for_family ); 
                		
    		        	/*$field      =   array('sync_lock_id');
    		        	$where_con  =   array(
    						'qr_id'     => @$invited_data['qr_id'] , 
    						'user_id'   => @$invited_data['family_user_id'] ,  
    						'user_type' => '2',
    		        	);
    		        	$sync_lock_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

    		        	if(!empty($sync_lock_check) && isset($sync_lock_check)) {

    		        		$synk_lock_for_family = array('status' => '0', 'modified_on'   => date("Y-m-d H:i:s"));
    		                $last_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $synk_lock_for_family ); */
    		            
	    		            $result = array('status' => 'true', 'message' => 'Reject successfully.' );
		            		response($result);

    		            /*} else {

    		            	$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
    		            	response($result);
    		            }*/

		        	} else {

	            		$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
	            		response($result);
		        	}
            	}

			} else {

				if($invited_data['invite_user_id'] == $user_id)  {

					$invited_data_array = array(
						'invite_user_id'   => (string)@$invited_data['invite_user_id'],
						'qr_id'            => (string)@$invited_data['qr_id'],
						'family_user_id'   => (string)@$invited_data['family_user_id'],
						'ref_lock_name'    => (string)@$invited_data['ref_lock_name'],
						'invite_date_time' => date("Y-m-d H:i:s"),
						'accept_date_time' => date("Y-m-d H:i:s"),
						'request_type'     => '2',
						'created_on'       => date("Y-m-d H:i:s"),
						'modified_on'      => date("Y-m-d H:i:s"),
		            );

		            $last_id = $this->Common_model->insert_data('zo_user_invite', $invited_data_array);

		            if(!empty($last_id) && isset($last_id)) {

		            	/* PUSH NOTIFICAION SEND */
		            	$field        = array('user_id','name');
		            	$where_con    = array('user_id' => @$invited_data['invite_user_id']);
		            	$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

		            	$push_data  = array(
		            	    'title'       => 'iDoor',
		            	    'tag'         => 'revoke_invited_user',
		            	    'user_id'     =>  @$invited_data['family_user_id'],
		            	    'body'        =>  "Invitation revoke by ".@$user_info['name'],
		            	    'sound'       => 'default',
		            	    'badge'       => '1'
		            	);

		            	$final_push    = json_encode($push_data);
		            	$this->Common_model->send_push_notification(@$invited_data['family_user_id'],'idoor_app', $final_push);
		            	/* PUSH NOTIFICAION END SEND */

		            	/*if user reject invitation then. origional initation entry set as suspended*/
		            	$synk_lock_for_family = array('status' 	  => '0');
		            	$where_con2 		  = array('invite_id' => $invite_id);
			            $this->Common_model->update_by_where_array('zo_user_invite', $where_con2, $synk_lock_for_family ); 
                		
    		        	$field      =   array('sync_lock_id');
    		        	$where_con  =   array(
    						'qr_id'     => @$invited_data['qr_id'] , 
    						'user_id'   => @$invited_data['family_user_id'] ,  
    						'user_type' => '2',
    		        	);
    		        	$sync_lock_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

    		        	if(!empty($sync_lock_check) && isset($sync_lock_check)) {

    		        		$synk_lock_for_family = array('status' => '0', 'modified_on'   => date("Y-m-d H:i:s"));
    		                $last_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $synk_lock_for_family ); 
    		            
	    		            $result = array('status' => 'true', 'message' => 'Revoke successfully.' );
            				response($result);

    		            } else {

    		            	$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
    		            	response($result);
    		            }

		        	} else {

	            		$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
	            		response($result);
		        	}            	

            	} else {

            		$invited_data_array = array(
						'invite_user_id'   => (string)@$invited_data['invite_user_id'],
						'qr_id'            => (string)@$invited_data['qr_id'],
						'family_user_id'   => (string)@$invited_data['family_user_id'],
						'ref_lock_name'    => (string)@$invited_data['ref_lock_name'],
						'invite_date_time' => date("Y-m-d H:i:s"),
						'accept_date_time' => date("Y-m-d H:i:s"),
						'request_type'     => '2',
						'created_on'       => date("Y-m-d H:i:s"),
						'modified_on'      => date("Y-m-d H:i:s"),
		            );

		            $last_id = $this->Common_model->insert_data('zo_user_invite', $invited_data_array);

		            if(!empty($last_id) && isset($last_id)) {

		            	/* PUSH NOTIFICAION SEND */
		            	$field        = array('user_id','name');
		            	$where_con    = array('user_id' => @$invited_data['family_user_id']);
		            	$user_info    = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);

		            	$push_data  = array(
		            	    'title'       => 'iDoor',
		            	    'tag'         => 'revoke_invited_user',
		            	    'user_id'     =>  @$invited_data['invite_user_id'],
		            	    'body'        =>  "Invitation revoke by ".@$user_info['name'],
		            	    'sound'       => 'default',
		            	    'badge'       => '1'
		            	);
		            	$final_push    = json_encode($push_data);
		            	$this->Common_model->send_push_notification(@$invited_data['invite_user_id'],'idoor_app', $final_push);
		            	/* PUSH NOTIFICAION END SEND */

		            	/*if user reject invitation then. origional initation entry set as suspended*/
		            	$synk_lock_for_family = array('status' 	  => '0');
		            	$where_con2 		  = array('invite_id' => $invite_id);
			            $this->Common_model->update_by_where_array('zo_user_invite', $where_con2, $synk_lock_for_family ); 
                		
    		        	$field      =   array('sync_lock_id');
    		        	$where_con  =   array(
    						'qr_id'     => @$invited_data['qr_id'] , 
    						'user_id'   => @$invited_data['family_user_id'] ,  
    						'user_type' => '2',
    		        	);
    		        	$sync_lock_check = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

    		        	if(!empty($sync_lock_check) && isset($sync_lock_check)) {

    		        		$synk_lock_for_family = array('status' => '0', 'modified_on'   => date("Y-m-d H:i:s"));
    		                $last_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $synk_lock_for_family ); 
    		            
	    		            $result = array('status' => 'true', 'message' => 'Revoke successfully.' );
            				response($result);

    		            } else {

    		            	$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
    		            	response($result);
    		            }

		        	} else {

	            		$result = array('status' => 'false', 'message' => 'Something error found please try again later' );
	            		response($result);
		        	}
            	}
			}

		} else {

			$result = array('status' => 'false', 'message' => 'Invited data not found.' );
			response($result);
		}
	}

	/*
		Author     	: Naresh Lakhara
		Date       	: 29-04-2022
		Description	: Delete Finger
	*/
	public function delete_finger($lock_data, $user_id) {

		$qr_id         = $lock_data['qr_id'];
		$l_query 	   = "SELECT GROUP_CONCAT(sync_lock_id) as sync_lock_id FROM `zo_sync_lock` WHERE qr_id = '$qr_id'";
		$exe           = $this->db->query($l_query);		
		$invited_data  = $exe->row_array(); 

		if(!empty($invited_data) && isset($invited_data)) {

			$sync_lock_ids = $invited_data['sync_lock_id'];
			$l_query 	   = "DELETE FROM zo_lock_finger WHERE sync_lock_id IN ($sync_lock_ids)";
			$exe           = $this->db->query($l_query);

			if($exe) {
				return true;
			} else {
				return false;				
			}
		} else {
			return false;
		}
	}
}

?>



