<?php $this->load->view('admin/header'); ?>
<?php $this->load->view('admin/sidebar'); ?>
<style type="text/css">
.regenerate_qr {
    background-color: #638585;
    color: white;
    border: 0;
    font-size: 14px;
    font-weight: 500;
    border-radius: 7px;
    padding: 10px 10px;
    cursor: pointer;
    white-space: nowrap;
}
</style>
<div class="main-panel">

    <div class="content-wrapper">
        <div class="row">
            <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="form-group text-left" style="color:#a4dcec;">
                            <h5>MANAGE LOCK</h5>
                        </div>
                        <div class="table-responsive pt-3">
                            <table id="dataTable" class="table table-bordered" width="100%">
                                <thead>
                                    <tr>
                                        <th>QR Id</th>
                                        <th>QR Code</th>
                                        <th>QR String</th>
                                        <th>Assigned Lock</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                        <th>Regenerate QR</th>
                                        <th>Reset Lock</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><span id="qr_id_append"><span></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <img src="" id="qr_code_append">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal" tabindex="-1" role="dialog" id="confirm_modal">
        <div class="modal-dialog" role="document">
            <input type="hidden" id="r_l_i" value="">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Hey ! Please Confirm.</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p style="text-align: left;">This will reset master user as well as family user access. Are you sure
                        to <strong>reset the lock </strong> ?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary yes_button">Yes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <?php $this->load->view('admin/footer'); ?>

    <script type="text/javascript">
    var table_ajax;
    table_ajax = jQuery('#dataTable').dataTable({
        "processing": true,
        "searching": true,
        "serverSide": true,
        "oLanguage": {
            "sEmptyTable": "No data found",
        },
        "ajax": {
            url: "<?php echo base_url('admin/lock/lock/manage_lock_ajax'); ?>",
            type: "post",
            data: function(d) {
                d.search_data = returnData();
                var order_by = d.order[0]['dir'];
                var order_for = d.order[0]['column'];
            },
            dataFilter: function(response) {
                var data = JSON.parse(response);
                var length = data.recordsTotal;
                return response;
            },
            complete: function() {
                // jQuery('.page-loader-wrapper').hide();
            },
            error: function() {
                // jQuery('.page-loader-wrapper').hide();
            }
        },
        "order": [
            [0, "desc"]
        ],
        "columns": [{
                "data": "qr_id",
                orderable: true,
                name: "qr_id"
            },
            {
                data: 'qr_code',
                orderable: false,
                render: function(data, type, row, meta) {
                    var qr_code = "<img id='" + row['qr_id'] +
                        "_no_qr' data-toggle='modal' data-target='#exampleModal' onclick='modal_called(" +
                        row['qr_id'] + ");' src='" + row['qr_code'] + "'></img>";
                    return qr_code;
                }
            },
            {
                "data": "qr_string",
                orderable: false,
                name: "qr_string"
            },
            {
                "data": "name",
                orderable: false,
                name: "name",
                render: function(data, type, row, meta) {

                    if (row['name'] != '-') {
                        var qr_code = "<a href='<?php echo base_url('admin/user/manage/'); ?>" + row[
                            'name'] + "'>" + row['name'] + "</a>";
                        return qr_code;
                    } else {
                        return row['name'];
                    }
                }

            },
            {
                "data": "status",
                orderable: false,
                name: "status"
            },
            {
                data: 'action',
                orderable: false,
                render: function(data, type, row, meta) {
                    var link = "<a href='add/" + row['qr_id'] + "'>Edit</a>";
                    return link;
                }
            },
            {
                data: 'generate_qr',
                orderable: false,
                render: function(data, type, row, meta) {
                    var link1 = "<button class='regenerate_qr' onclick='regenerate_qr(" + row['qr_id'] +
                        ");' >Regenerate QR</button>";
                    return link1
                }
            },
            {
                data: 'generate_qr',
                orderable: false,
                render: function(data, type, row, meta) {
                    if (row['name'] != '-') {
                        var lockReset =
                            "<button class='regenerate_qr' data-toggle='modal' data-target='#confirm_modal' id='reset_lock_" +
                            row['qr_id'] + "' onclick='resetLock(" + row['qr_id'] +
                            ");' >Reset Lock</button>";
                    } else {
                        var lockReset = "-";
                    }
                    return lockReset;
                }
            },
        ],
        fnServerParams: function(data) {
            data["order"].forEach(function(items, index) {
                data["order"][index]["column"] = data["columns"][items.column]["name"];
            });
        },
    });

    function returnData() {
        var searchAry = {};
        searchAry['apply_click'] = $("#apply_click").val();
        return searchAry;
    }

    function modal_called(qr_id) {
        var image_url = $('#' + qr_id + '_no_qr').attr('src');
        $("#qr_id_append").text('idoor-' + qr_id);
        $("#qr_code_append").attr("src", image_url);
    }

    function regenerate_qr(qr_id) {

        $.ajax({
            url: "<?php echo base_url('admin/lock/lock/regenerate_qr'); ?>",
            type: 'POST',
            data: {
                qr_id: qr_id
            },
            success: function(response) {
                var response = JSON.parse(response);
                if (response.result == 'failure') {
                    toastr.error(response.message);
                } else {
                    toastr.success(response.message);
                    // table_ajax.api().ajax.reload();   
                }
            }
        });
    }

    function resetLock(qr_id) {
        $("#r_l_i").val(qr_id);
    }

    $(".yes_button").on("click", function() {

        $.ajax({
            url: "<?php echo base_url('admin/lock/lock/lock_reset'); ?>",
            type: 'POST',
            data: {
                qr_id: $("#r_l_i").val()
            },
            success: function(response) {
                var response = JSON.parse(response);
                if (response.result == 'failure') {
                    toastr.error(response.message);
                } else {
                    $(".close").trigger("click");
                    toastr.success(response.message);
                    table_ajax.api().ajax.reload();
                }
            }
        });
    });
    </script>