<?php defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH.'libraries/REST_Controller.php';
/*
    Author     : Naresh Lakhara
    Description: Rest API Controller setup
    Date       : 03-02-2022 
*/
class Api extends REST_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Api_model','apimodel', True);
    }

    /*
       Author     : Naresh Lakhara
       Date       : 12-04-2022
       Description: Login API
    */
    public function user_login_post() {

        $user_name    = (string)@$this->input->post('user_name');
        $password     = (string)md5($this->input->post('password'));
        $app_info     = (string)@$this->input->post('app_info');
        $device_token = (string)@$this->input->post('device_token');
        $device_os    = (string)@$this->input->post('device_os');

        if(!empty($user_name) && !empty($password)) {

            $data = $this->apimodel->login_user($user_name, $password, $app_info, $device_token, $device_os);
                
            if(@$data['is_verify'] == '0') {

                $subject = "Email Confirmation";
                $url     = base_url('email_confirmation/').base64_encode(@$data['user_id']);

                $message = "<html>
                                <body>
                                <p>
                                Dear ".@$data['name']."<br><br>
                                We have received your sign up request.<br><br>
                                Please <a href='".$url."'>click here</a> to confirm your email. <br><br>
                                <br>If you have not made any request, please discard this email. <br></br>
                                <br>Regards,<br>
                                Team Idoor.
                                </p>
                                </body>
                            </html>";

                $to = @$data['email'];
                $mail_response = $this->Common_model->email_send($to, $subject, $message);

                $data = array('status'  => 'false', 'message' => 'Your account is not verified. Verification email is sent on your email address.');
                response($data);

            }  else {

                if(!empty($data) && isset($data)) {

                    $data = array('status'  => 'true', 'message' => 'Login successfully.', 'data' => $data);
                    response($data);

                } else {

                    $data = array('status'  => 'false', 'message' => 'Please enter valid credentials.');
                    response($data);
                }
            }

        }  else {

            $data = array('status'  => 'false', 'message' => 'Please enter valid parameter');
            response($data);
        }
    }
    
    /*
       Author     : Naresh Lakhara
       Date       : 04-03-2022
       Description: Logs API
    */
    public function idoor_logs_post() {

        $mac = $this->input->post('mac');
      
        if(!empty($mac) && !empty($mac)) {

            $data = $this->apimodel->idoor_logs($mac);
            
            if(!empty($data) && isset($data)) {

                response($data);

            } else {

                // $data = array('status'  => 'false');
                $data = array();
                response($data);
            }

        }  else {

            $data = array('status'  => 'false', 'message' => 'Please enter valid parameter');
            response($data);
        }
    }

    /*
       Author     : Naresh Lakhara
       Date       : 04-03-2022
       Description: VC Token Add || Update API
    */
    public function vc_token_post() {

        $video_id     = $this->input->post('video_id');
        $device_type  = $this->input->post('device_type');
        $device_id    = $this->input->post('device_id');
        $device_token = $this->input->post('device_token');
        $ble_mac      = $this->input->post('ble_mac');
        $lock_mac     = $this->input->post('lock_mac');
        $btn_action   = $this->input->post('btn_action');
        $bell_ble_mac = $this->input->post('bell_ble_mac');
        
        if((!empty($video_id) && isset($video_id) && !empty($device_type) && isset($device_type) && !empty($device_id) && isset($device_id) && (!empty($device_token) && isset($device_token) ) || !empty($ble_mac) && isset($ble_mac))) {
            
            $this->apimodel->vc_token_add_update($device_id, $device_type, $device_token, $video_id, $ble_mac);

        } elseif (!empty($video_id) && isset($video_id) && !empty($device_type) && isset($device_type) && !empty($lock_mac) && isset($lock_mac) && !empty($btn_action) && isset($btn_action) ) {
              
            $response = $this->Common_model->Send_FCM($video_id, $device_type, $lock_mac, $btn_action);  

            if(!empty($response) && isset($response)) {
                $data = array('status'  => 'true');
                response($data);
                exit;
            } else {
                $data = array('status'  => 'false');
                response($data);
                exit;
            }

        } elseif (!empty($bell_ble_mac) && isset($bell_ble_mac) && !empty($device_type) && isset($device_type) && !empty($lock_mac) && isset($lock_mac) && !empty($btn_action) && isset($btn_action)) {
            
            $this->apimodel->fcm_send_to_bell_call_door($bell_ble_mac, $device_type, $lock_mac, $btn_action);

        } else {

            $data = array('status'  => 'false', 'message' => 'Please enter valid parameter');
            response($data);
        }           
    }

    /*
       Author     : Naresh Lakhara
       Date       : 04-03-2022
       Description: Insert Logs
    */
    public function insert_logs_post() {

        $result = array();
        $yummy = json_decode(file_get_contents("php://input"));            
        $data = $yummy->vv;

        foreach ($data as $key => $value) {
            
            $insert_log[] = array(
                'uid'       => $value->uid,
                'uname'     => $value->uname,
                'mac'       => $value->mac,
                'operation' => $value->operation,
                'time'      => $value->time,
                'status'    => $value->status,
            );
        }

        if(!empty($insert_log) && isset($insert_log)) {

            $last_insert_id = $this->Common_model->insert_batch_data('idoor_log', $insert_log);

            if (!empty($last_insert_id) && isset($last_insert_id)) {
                $result["status"] = "true";
            } else {
                $result["status"] = "false";
            } 
            response($result);
        
        } else {

            $result["status"] = "false";            
            response($result);
        }
    }

    /*
       Author     : Naresh Lakhara
       Date       : 05-04-2022
       Description: Lock Qr 
    */
    public function lock_qr_post() {

        $qr_string = $this->input->post('qr_string');
        $u_id      = $this->input->post('u_id');

        if(!empty($qr_string) && isset($qr_string) && !empty($u_id) && isset($u_id)) {

            $scan_qr_info = $this->apimodel->scan_qr($qr_string, $u_id);

        } else {

            $data = array('status'  => 'false', 'message' => 'Please enter valid parameter');
            response($data);
        }
    }

    /*
       Author     : Naresh Lakhara
       Date       : 05-04-2022
       Description: Send Birdge API not using 
    */
    public function sendBridgeLockAction_post() {
        $data = array("statusCode" => "0", "message" => "Send successfully");
        response($data);    
    }

    /*
       Author     : Naresh Lakhara
       Date       : 05-04-2022
       Description: Bell Call Door
    */
    public function bell_call_door_post() {
        $action        = (string)@$this->input->post('action');
        $bell_ble_mac  = (string)@$this->input->post('bell_ble_mac');
        $door_video_id = (string)@$this->input->post('door_video_id');
        $this->apimodel->bell_call_door($action, $bell_ble_mac, $door_video_id);
    }  

    /*
       Author     : Naresh Lakhara
       Date       : 07-04-2022
       Description: Sign up User
    */
    public function sign_up_post() {
        $user_name      = (string)@$this->input->post('user_name');
        $password       = (string)@$this->input->post('password');
        $email_id       = (string)@$this->input->post('email_id');
        $country_code   = (string)@$this->input->post('country_code');
        $mobile_number  = (string)@$this->input->post('mobile_number');
        $otp_code       = (string)@$this->input->post('otp_code');
        $video_call_id  = (string)@$this->input->post('video_call_id');
        $device_ble_mac = (string)@$this->input->post('device_ble_mac');
        $u_id           = (string)@$this->input->post('u_id');

        if(!empty($user_name) && !empty($password) && !empty($email_id) && !empty($mobile_number)) {

            $where_con  = array('mobile_number' => $mobile_number , 'u_id !=' => $u_id );
            $mobile_number_check = $this->Common_model->get_number_of_rows_table('idoor_login','u_id', $where_con);

            $e_where_con  = array('email_id' => $email_id , 'u_id !=' => $u_id );
            $email_check = $this->Common_model->get_number_of_rows_table('idoor_login','u_id', $e_where_con);

            if(!empty($mobile_number_check) && isset($mobile_number_check)) {

                $result["status"]  = "false";
                $result["message"] = "Mobile number is already exists.";
                response($result);

            } elseif(!empty($email_check) && isset($email_check)) {

                $result["status"]  = "false";
                $result["message"] = "Email id is already exists.";
                response($result);

            } else {

                $image = "";
                if (!empty($_FILES['user_image']['name'])) {

                    $folder = 'uploads/user_image';
                    // $config['upload_path'] = './assets/'.$folder.'/';
                    $config['upload_path']    = $folder;
                    $config['allowed_types']  = 'gif|jpg|png|jpeg';
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('user_image')) {
                        $error = array('error' => $this->upload->display_errors());
                        $this->session->set_flashdata('error', $this->upload->display_errors());
                    } else {
                        $data = array('upload_data' => $this->upload->data());
                        $image = $data['upload_data']['file_name'];
                    }
                }
        
                if(!empty($u_id) && isset($u_id)) {

                    $user_array = array(
                        'user_name'      => $user_name,
                        'email_id'       => $email_id,
                        'country_code'   => @$country_code ? (string)@$country_code : "91",
                        'mobile_number'  => @$mobile_number ? (string)@$mobile_number : "",
                        'otp_code'       => @$otp_code ? (string)@$otp_code : null,
                        'video_call_id'  => @$video_call_id ? (string)@$video_call_id : null,
                        'device_ble_mac' => @$device_ble_mac ? (string)@$device_ble_mac : null,
                        'img_path'       => @$image ? (string)@$image : null,
                        'modified_on'     => date("Y-m-d H:i:s"),
                    );

                    $where_con = array('u_id' => $u_id);
                    $update_id = $this->Common_model->update_by_where_array('idoor_login', $where_con, $user_array );                   

                    if(!empty($update_id) && isset($update_id)) {

                        /* Email Confirmation */
                        $subject = "Email Confirmation";
                        $url     = base_url('email_confirmation/').base64_encode($u_id);

                        $message = "<html>
                                        <body>
                                        <p>
                                        Dear ".$user_name."<br><br>
                                        We have received your sign up request.<br><br>
                                        Please <a href='".$url."'>click here</a> to confirm your email. <br><br>
                                        <br>If you have not made any request, please discard this email. <br></br>
                                        <br>Regards,<br>
                                        Team Idoor.
                                        </p>
                                        </body>
                                    </html>";

                        $to = $email_id;
                        // $to = "qaorig1@gmail.com";
                        $mail_response = $this->Common_model->email_send($to,$subject,$message);

                        $result["status"]  = "true";
                        $result["message"] = "Profile updated successfully.";
                        response($result);

                    } else {

                        $result["status"]  = "false";
                        $result["message"] = "Profile not updated please try again later.";
                        response($result);
                    }

                } else {

                    $user_array = array(
                        'user_name'      => $user_name,
                        'password'       => $password,
                        'email_id'       => $email_id,
                        'country_code'   => @$country_code ? (string)@$country_code : "91",
                        'mobile_number'  => @$mobile_number ? (string)@$mobile_number : "",
                        'otp_code'       => @$otp_code ? (string)@$otp_code : null,
                        'video_call_id'  => @$video_call_id ? (string)@$video_call_id : null,
                        'device_ble_mac' => @$device_ble_mac ? (string)@$device_ble_mac : null,
                        'img_path'       => @$image ? (string)@$image : null,
                        'created_on'     => date("Y-m-d H:i:s"),
                    );

                    $insert_id = $this->Common_model->insert_data('idoor_login', $user_array);

                    if(!empty($insert_id) && isset($insert_id)) {

                        /* Email Confirmation */
                        $subject = "Email Confirmation";
                        $url     = base_url('email_confirmation/').base64_encode($insert_id);

                        $message = "<html>
                                        <body>
                                        <p>
                                        Dear ".$user_name."<br><br>
                                        We have received your sign up request.<br><br>
                                        Please <a href='".$url."'>click here</a> to confirm your email. <br><br>
                                        <br>If you have not made any request, please discard this email. <br></br>
                                        <br>Regards,<br>
                                        Team Idoor.
                                        </p>
                                        </body>
                                    </html>";

                        $to = $email_id;
                        // $to = "qaorig1@gmail.com";
                        $mail_response = $this->Common_model->email_send($to,$subject,$message);

                        $result["status"]  = "true";
                        $result["message"] = "User registered successfully.";
                        response($result);
                    } else {

                        $result["status"]  = "false";
                        $result["message"] = "User not added please try again later.";
                        response($result);
                    } 
                }               
            }

        } else {   

            $result["status"]  = "false";
            $result["message"] = "Please enter valid credentials.";
            response($result);
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 12-04-2022
        Description: Forgot Password API
    */
    public function forgot_password_post() {

        $email    = trim($this->input->post('email'));

        if(!empty($email) && isset($email)) {

            $field      = array('user_id','name','email');
            $where_con  = array('email' => $email);
            $check_user = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);            

            if(!empty($check_user) && isset($check_user)) {
                           
                /* Mail send */
                $employee_name = $check_user['name'];
                $append        = base64_encode($check_user['user_id']);
                $encode_url    = base_url("change_password/$append");

                $subject = "iDoor Reset Password";

                $message = "<html>
                                <body>
                                <p>
                                Dear ".$employee_name."<br><br>
                                We have received your request to reset the password. <br><br>
                                Please <a href='".$encode_url."'>click here</a> to reset your password. <br><br>
                                <br>If you have not made any request, please discard this email. <br></br>

                                <br>Regards,<br>
                                Team Idoor.
                                </p>
                                </body>
                            </html>";

                $to = $check_user['email'];
                $mail_response = $this->Common_model->email_send($to,$subject,$message);

                if($mail_response == true) {

                    /*Expiry Time Set For User*/
                    $date        = date("Y-m-d H:i:s");
                    $expiry_date = date("Y-m-d H:i:s", strtotime('+30 minutes', strtotime($date)));
                    $up_data     = array('expiry_date_time' => $expiry_date);
                    $where_con   = array('user_id' => $check_user['user_id']);                                     
                    $this->Common_model->update_by_where_array('zo_tbl_user', $where_con, $up_data );
                    /*Expiry Time end*/

                    $result = array('status' => 'true', 'message' => 'Mail sent successfully on your email address.');
                    response($result);
                    
                } else {

                    $result = array('status' => 'false', 'message' => 'Mail not send please try again later.');
                    response($result);                    
                }

            } else {

                $result = array('status' => 'false', 'message' => 'Please enter valid email address.');
                response($result);
            }
        
        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 07-04-2022
        Description: Logout User
    */
    public function logout_post()
    {            
        $user_id = $this->input->post("user_id");

        if(!empty($user_id)) {

            $upated_rows = $this->apimodel->user_logout($user_id);
            $result = array('status' => 'true', 'message' => 'Logout successfully.');
            response($result);           

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 12-04-2022
        Description: Update Device Token
    */
    public function updateDevicetoken_post()
    {
        $u_id         = (string)trim(@$this->input->post("user_id"));
        $device_token = (string)trim(@$this->post('device_token'));
        $app_info     = (string)@$this->input->post('app_info');
        $device_os    = (string)@$this->input->post('device_os');

        if(!empty($u_id))
        {
            $update_id = $this->apimodel->updatedeviceToken($u_id, $device_token, $app_info, $device_os);
            $result = array('status' => 'true', 'message' => 'Device token updated successfully.');
            response($result);

        } else {

            $result = array('status' => 'true', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 12-04-2022
        Description: Sync Lock Listing API
    */
    public function sync_lock_list_get() {

        $user_id  = $this->input->get("user_id");

        if(!empty($user_id) && isset($user_id))
        {
            $sync_info  = $this->apimodel->sync_details($user_id);

            if(!empty($sync_info) && isset($sync_info)) {

                $result = array('status' => 'true', 'message' => 'Sync lock details fetch successfully.', 'data' => $sync_info );
                response($result);

            } else {

                $result = array('status' => 'false', 'message' => 'Sync lock details not found.');
                response($result);
            }

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);            
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 12-04-2022
        Description: Lock Add Api
    */
    public function add_lock_post() {

        $ref_lock_name = $this->input->post('ref_lock_name');
        $user_id       = $this->input->post('user_id');
        $qr_string     = $this->input->post('qr_string');
        $sync_lock_id  = $this->input->post('sync_lock_id');
        $is_bridge     = $this->input->post('is_bridge');
        if(!empty($ref_lock_name) && !empty($user_id) && !empty($qr_string)  ) {
        
            $field               = array('sync_lock_id','qr_id');
            $where_con           = array('sync_lock_id' => $sync_lock_id);
            $user_connected_lock = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

            if(!empty($user_connected_lock) && isset($user_connected_lock)) {

               $sync_data = array(
                    'ref_lock_name' => @$ref_lock_name ? @$ref_lock_name : "0",
                    'user_id'       => (string)@$user_id,
                    'modified_on'   => date("Y-m-d H:i:s"),
                );

                $where_con = array('sync_lock_id' => $user_connected_lock['sync_lock_id'] , 'is_delete' => '0');
                $update_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $sync_data );

                if(!empty($update_id) && isset($update_id)) {
                        
                    $result = array('status' => 'true', 'message' => 'Lock updated successfully.', 'data' => array('sync_lock_id' => (string)$sync_lock_id));
                    response($result);

                } else {

                    $result = array('status' => 'false', 'message' => 'Lock not updated please try again later.');
                    response($result);

                }

            } else {
                    
                $field       = array('qr_id');
                $where_con   = array('qr_string' => $qr_string, 'status' => '1', 'is_delete' => '0');
                $get_qr_data = $this->Common_model->single_record_fetch($field, 'zo_lock_qr', $where_con);
                $u_qr_id     = @$get_qr_data['qr_id'];
                
                if(!empty($u_qr_id) && isset($u_qr_id)) {

                    $sync_data = array(
                        'qr_id'         => @$u_qr_id ? @$u_qr_id : null,
                        'ref_lock_name' => @$ref_lock_name ? @$ref_lock_name : "0",
                        'user_id'       => (string)@$user_id,
                        'user_type'     => '1',
                        'status'        => '1',
                        'created_on'    => date("Y-m-d H:i:s"),
                        'modified_on'   => date("Y-m-d H:i:s"),
                    );
                    if($is_bridge=='1'){
                        $sync_data['is_bridge']='1';
                    }
                    $field       = array('sync_lock_id');
                    $where_con   = array('qr_id' => "$u_qr_id", 'user_id' => "$user_id", 'user_type' => '1', 'status' => '1', 'is_delete' => '0');
                    $check_data = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

                    if(!empty($check_data) && isset($check_data)) {

                        $result = array('status' => 'false', 'message' => 'You have already added lock.');
                        response($result);

                    } else {

                        $insert_id = $this->Common_model->insert_data('zo_sync_lock', $sync_data);

                        if(!empty($insert_id) && isset($insert_id)) {

                            /*Update User ID against QR*/
                            $up_data   = array('u_id' => $user_id);
                            $where_con = array('qr_id' => $u_qr_id);
                            $this->Common_model->update_by_where_array('zo_lock_qr', $where_con, $up_data );
                                
                            $result = array('status' => 'true', 'message' => 'Lock added successfully.' ,'data' => array('sync_lock_id' => (string)$insert_id));
                            response($result);

                        } else {

                            $result = array('status' => 'false', 'message' => 'Lock not added please try again later.');
                            response($result);
                        }
                    }


                } else {

                    $result = array('status' => 'false', 'message' => 'QR not found.');
                    response($result);
                }
            }

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 12-04-2022
        Description : Delete Lock API
    */
    public function delete_lock_post() {

        $sync_lock_id  = $this->input->post("sync_lock_id");
        $user_id  = $this->input->post("user_id");

        if(!empty($sync_lock_id) && isset($sync_lock_id))
        {

            $field      = array('sync_lock_id');
            $where_con  = array('user_id' => $user_id , 'sync_lock_id' => $sync_lock_id );
            $check_data = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);

            if(!empty($check_data) && isset($check_data)) {

                $up_data   = array('is_delete'    => '1');
                $where_con = array('sync_lock_id' => $sync_lock_id);
                $update_id = $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, $up_data );

                if(!empty($update_id) && isset($update_id)) {

                    $result = array('status' => 'true' , 'message' => 'Deleted successfully.');
                    response($result);

                } else {

                    $result = array('status' => 'false' , 'message' => 'Lock not deleted please try again later.');
                    response($result);
                } 

            } else {

                $result = array('status' => 'false' , 'message' => 'Lock not deleted please try again later.');
                response($result);                 
            }            

        } else {

            $result = array('status' => 'false' , 'message' => 'Lock not deleted please try again later.');
            response($result);  
        }
    }

    /*
       Author     : Naresh Lakhara
       Date       : 12-04-2022
       Description: User Register
    */
    public function user_register_post() {

        $name          = (string)@$this->input->post('name');
        $email         = (string)@$this->input->post('email');
        $password      = (string)@$this->input->post('password');
        $mobile_number = (string)@$this->input->post('mobile_number');
        $user_id       = (string)@$this->input->post('user_id');

        if(!empty($name) && !empty($email) && ( $user_id ? $user_id : $password ) ) {

            $get_result = $this->apimodel->verify_user($email, $user_id);

            if(@$get_result['result'] == 'true') {

                $image = "";
                if (!empty($_FILES['user_image']['name'])) {

                    $folder = 'uploads/user_image';
                    // $config['upload_path'] = './assets/'.$folder.'/';
                    $config['upload_path']    = $folder;
                    $config['allowed_types']  = 'gif|jpg|png|jpeg';
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('user_image')) {
                        $error = array('error' => $this->upload->display_errors());
                        $this->session->set_flashdata('error', $this->upload->display_errors());
                    } else {
                        $data = array('upload_data' => $this->upload->data());
                        $image = $data['upload_data']['file_name'];
                    }
                }
                
                if(!empty($user_id) && isset($user_id)) {

                   $user_array = array(
                        'name'          => @$name ? @$name : null,
                        'email'         => @$email ? @$email : null,
                        'mobile_number' => @$mobile_number ? (string)@$mobile_number : null,
                        'image'         => @$image ? (string)@$image : null,
                        'modified_on'   => date("Y-m-d H:i:s"),
                    );

                    $where_con = array('user_id' => $user_id);
                    $update_id = $this->Common_model->update_by_where_array('zo_tbl_user', $where_con, $user_array);

                    if(!empty($update_id) && isset($update_id)) {

                        /*Last Data Get of Update User*/
                        $field            = array('user_id','name','email','mobile_number','image');
                        $where_con        = array('user_id' => $user_id);
                        $udpate_user_info = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);
                        if(!empty($udpate_user_info['image']) && isset($udpate_user_info['image'])) {
                            $udpate_user_info['image'] = base_url('uploads/user_image/'.$udpate_user_info['image']); 
                        } else {
                            $udpate_user_info['image'] = "";
                        }
                        /*Last Updated data */


                        /* Email Confirmation */
                        $subject = "iDoor Email Confirmation";
                        $url     = base_url('email_confirmation/').base64_encode($user_id);

                        $message = "<html>
                                        <body>
                                        <p>
                                        Dear ".$name."<br><br>
                                        We have received your sign up request.<br><br>
                                        Please <a href='".$url."'>click here</a> to confirm your email. <br><br>
                                        <br>If you have not made any request, please discard this email. <br></br>
                                        <br>Regards,<br>
                                        Team Idoor.
                                        </p>
                                        </body>
                                    </html>";

                        $to = $email;
                        $mail_response = $this->Common_model->email_send($to, $subject, $message);
                        
                        $result = array('status' => 'true', 'message' => 'Profile updated successfully.', 'data' => $udpate_user_info );
                        response($result);

                    } else {

                        $result = array('status' => 'false', 'message' => 'Profile not updated please try again later.' );
                        response($result);
                    }

                } else {

                    $user_array = array(
                        'name'          => @$name ? @$name : null,
                        'email'         => @$email ? @$email : null,
                        'password'      => $password ? md5($password) : null,
                        'mobile_number' => @$mobile_number ? (string)@$mobile_number : null,
                        'image'         => @$image ? (string)@$image : null,
                        'created_on'    => date("Y-m-d H:i:s"),
                        'modified_on'   => date("Y-m-d H:i:s"),                        
                    );

                    /*IF STATUS IS 2 MEANS INVITE USER SO THEY ARE UPATE YOUR PROFILE ONLY*/
                    if(@$get_result['status'] == '2') {
                        $where_con            = array('email' => $email);
                        $user_array['status'] = '1';
                        $this->Common_model->update_by_where_array('zo_tbl_user', $where_con, $user_array);
                        $insert_id = @$get_result['user_id'];
                    } else {
                        $insert_id = $this->Common_model->insert_data('zo_tbl_user', $user_array);
                    }

                    if(!empty($insert_id) && isset($insert_id)) {

                        /* Email Confirmation */
                        $subject = "iDoor Email Confirmation";
                        $url     = base_url('email_confirmation/').base64_encode($insert_id);

                        $message = "<html>
                                        <body>
                                        <p>
                                        Dear ".$name."<br><br>
                                        We have received your sign up request.<br><br>
                                        Please <a href='".$url."'>click here</a> to confirm your email. <br><br>
                                        <br>If you have not made any request, please discard this email. <br></br>
                                        <br>Regards,<br>
                                        Team Idoor.
                                        </p>
                                        </body>
                                    </html>";

                        $to = $email;
                        $mail_response = $this->Common_model->email_send($to, $subject, $message);

                        $result = array('status' => 'true', 'message' => 'Registered successfully, Please confirm your email address.' );
                        response($result);

                    } else {

                        $result = array('status' => 'false', 'message' => 'User not added please try again later.' );
                        response($result);
                    } 
                }   

            } elseif(@$get_result['result'] == 'false') {
                    
                $result = array('status' => 'false', 'message' => 'Email address already exist.' );
                response($result);

            } else {

                $result = array('status' => 'false', 'message' => 'Something error found please try again later.' );
                response($result);
            }   

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.' );
            response($result);
        }
    }

    /*
       Author      : Naresh Lakhara
       Date        : 13-04-2022
       Description : QR code is avaliable or not 
    */
    public function verify_qr_post() {

        $user_id   = (string)@$this->input->post('user_id');
        $qr_string = (string)@$this->input->post('qr_string');        

        if(!empty($qr_string) && !empty($user_id)) {        
            $response = $this->apimodel->verify_qr($user_id, $qr_string);
        } else {
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
       Author     : Naresh Lakhara
       Date       : 13-04-2022
       Description: Invite User API
    */
    public function invite_user_post() {

        $user_id       = (string)@$this->input->post('user_id');
        $qr_string     = (string)@$this->input->post('qr_string');
        $email         = (string)@$this->input->post('email');
        $ref_lock_name = (string)@$this->input->post('ref_lock_name');

        if(!empty($email) && !empty($qr_string) && !empty($user_id) && !empty($ref_lock_name)) {
            $response = $this->apimodel->invite_user($user_id, $qr_string, $email, $ref_lock_name);
        } else {    
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
       Author      : Naresh Lakhara
       Date        : 13-04-2022
       Description : Approve Invited User
    */
    public function approve_invited_user_post() {
        
        $invite_id       = (string)@$this->input->post('invite_id');

        if(!empty($invite_id) && isset($invite_id)) {

            $response = $this->apimodel->approve_invited_user($invite_id);
        
        } else {    
        
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);

        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 14-04-2022
        Description: Invited User List user type : 1 master user or 2 family user
    */
    public function invite_user_list_get() {

        $user_id    = $this->input->get("user_id");
        $user_type  = $this->input->get("user_type");
        $qr_id      = $this->input->get("qr_id");

        if(!empty($user_id) && isset($user_id) && !empty($user_type) )
        {
            $invite_info  = $this->apimodel->invite_user_list($user_id, $user_type, $qr_id);

            if(!empty($invite_info) && isset($invite_info)) {

                $result = array('status' => 'true', 'message' => 'Invited details fetch successfully.', 'data' => $invite_info );
                response($result);

            } else {

                $result = array('status' => 'false', 'message' => 'Invited details not found.');
                response($result);
            }

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);            
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 14-04-2022
        Description: Invited User List user type : 1 master user or 2 family user
    */
    public function revoke_invited_user_post() {

        $invite_id       = (string)@$this->input->post('invite_id');
        $user_id         = (string)@$this->input->post('user_id');

        if(!empty($invite_id) && isset($invite_id)) {
            $response = $this->apimodel->revoke_invited_user($invite_id, $user_id);        
        } else {
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 28-04-2022
        Description : Push Notification send
    */
    public function push_notification_test_get(){

        $push_data  = array(
            'title'       => 'iDoor',
            'tag'         => 'new_customer',
            'customer_id' =>  '1',
            'body'        => "Invited successfully.",
            'sound'       => 'default',
            'badge'       => '1'
        );

        $final_push    = json_encode($push_data);
        $this->Common_model->send_push_notification('1','testing-idoorapp', $final_push);
    }

    /*
        Author      : Naresh Lakhara
        Date        : 29-04-2022
        Description : Finger Add Or Update API
    */
    public function finger_add_update_post() {

        $finger_id    = (string)@$this->input->post('finger_id');
        $sync_lock_id = (string)@$this->input->post('sync_lock_id');
        $user_id      = (string)@$this->input->post('user_id');
        $finger_name  = (string)@$this->input->post('finger_name');
        $setup        = (string)@$this->input->post('setup');
        $last_step    = (string)@$this->input->post('last_step');

        if(!empty($sync_lock_id) && !empty($user_id) && !empty($finger_name)) {
            
            $field        = array('finger_id');
            $where_con    = array('finger_id' => $finger_id , 'user_id' => $user_id , 'sync_lock_id' => $sync_lock_id );
            $finger_exist = $this->Common_model->single_record_fetch($field, 'zo_lock_finger', $where_con);

            $finger_data = array(
                'sync_lock_id'  => (string)@$sync_lock_id,
                'user_id'       => (string)@$user_id,
                'setup'         => (string)@$setup ? (string)@$setup : "0",
                'finger_name'   => (string)@$finger_name,
                'last_step'     => (string)@$last_step ? (string)@$last_step : "0",
            );

            if(!empty($finger_exist) && isset($finger_exist)) {

                $finger_data['modified_on'] = date("Y-m-d H:i:s");

                $update_id = $this->Common_model->update_by_where_array('zo_lock_finger', $where_con, $finger_data);

                if(!empty($update_id) && isset($update_id)) {

                    $finger_data['finger_id'] = (string)$finger_id;
                    $result = array('status' => 'true', 'message' => 'Finger updated successfully.' ,'data' => $finger_data);
                    response($result);

                } else {

                    $result = array('status' => 'false', 'message' => 'Finger not updated please try again later.');
                    response($result);
                }

            } else {

                $finger_data['created_on'] = date("Y-m-d H:i:s");
                $insert_id = $this->Common_model->insert_data('zo_lock_finger', $finger_data);

                if(!empty($insert_id) && isset($insert_id)) {

                    $finger_data['finger_id'] = (string)$insert_id;
                    $result = array('status' => 'true', 'message' => 'Finger added successfully.' ,'data' => $finger_data);
                    response($result);

                } else {

                    $result = array('status' => 'false', 'message' => 'Finger not added please try again later.');
                    response($result);
                }
            }

        } else {    
        
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 29-04-2022 
        Description : Delete Finger
    */
    public function delete_finger_post() {

        $sync_lock_id = (string)@$this->input->post('sync_lock_id');
        $user_id      = (string)@$this->input->post('user_id');
        // $finger_id    = (string)@$this->input->post('finger_id');

        if(!empty($sync_lock_id)) {
            
            $field       = array('sync_lock_id','qr_id','user_id');
            $where_con   = array('sync_lock_id' => @$sync_lock_id);
            $lock_exist  = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);
                
            if(!empty($lock_exist) && isset($lock_exist)) {                

                if(@$lock_exist['user_id'] == $user_id) {

                    $delete_response = $this->apimodel->delete_finger($lock_exist, $user_id);

                    if(!empty($delete_response) && isset($delete_response)) {

                        $result = array('status' => 'true', 'message' => 'Finger deleted successfully.');
                        response($result);

                    } else {

                        $result = array('status' => 'false', 'message' => 'Something error found please try again later.');
                        response($result);
                    }

                } else {

                    $result = array('status' => 'false', 'message' => 'Invalid sync lock id.');
                    response($result);
                } 

            } else {

                $result = array('status' => 'false', 'message' => 'Lock not found.');
                response($result);
            }

        } else {    
        
            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }   
    }

    /*
        Author      : Naresh Lakhara
        Date        : 12-04-2022
        Description : Update Device Token
    */
    public function change_password_post()
    {
        $user_id           = (string)trim(@$this->post('user_id'));
        $current_password  = (string)trim(@$this->post('current_password'));
        $new_password      = (string)trim(@$this->input->post('new_password'));
        $confirm_password  = (string)trim(@$this->input->post('confirm_password'));

        if(!empty($user_id) && !empty($current_password) && !empty($new_password) && !empty($confirm_password))
        {

            $field      = array('user_id');
            $where_con  = array('user_id' => $user_id , 'password' => md5($current_password));
            $check_user = $this->Common_model->single_record_fetch($field, 'zo_tbl_user', $where_con);            

            if(!empty($check_user) && isset($check_user)) {

                if($new_password == $confirm_password) {

                    $up_where_con = array('user_id' => $user_id);
                    $update_data  = array('password' => md5($new_password));
                    $update_id    = $this->Common_model->update_by_where_array('zo_tbl_user', $up_where_con, $update_data );

                    if(!empty($update_id)) {

                        $result = array('status' => 'true', 'message' => 'Password changed successfully.');
                        response($result);

                    } else {

                        $result = array('status' => 'false', 'message' => 'Something error found please try again later.');
                        response($result);
                    }

                } else {

                    $result = array('status' => 'false', 'message' => 'New password and confirm password does not match.');
                    response($result);
                }

            } else {

                $result = array('status' => 'false', 'message' => 'Current password does not match.');
                response($result);    
            }

        } else {

            $result = array('status' => 'false', 'message' => 'Please enter valid parameter.');
            response($result);
        }
    }    
    public function bridge_post()
    {
        // echo 'hii'; exit;
        $lock_response     =(string)trim(@$this->input->post('lock_response'));
        $qr_id             =(string)trim(@$this->input->post("qr_id"));
        $sync_lock_id      =(string)trim(@$this->input->post("sync_lock_id"));
        $user_id           =(string)trim(@$this->input->post("user_id"));



        if(!empty($sync_lock_id) && isset($sync_lock_id)) {
                
            $lock_response_event = $this->apimodel->sync_lock_response($sync_lock_id);

            if(!empty($lock_response_event) && isset($lock_response_event)) {

                $event_call        = $this->Common_model->sendNodeRequest($lock_response_event);
                $data = array('status'  => 'true', 'message' => 'Event  Data found successfully.', 'data' => $lock_response_event);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
        
    }
    public function bridge_log_post()
    {
        // echo 'hii'; exit;
        $lock_response     =(string)trim(@$this->input->post('lock_response'));
        $qr_id             =(string)trim(@$this->input->post("qr_id"));
        $sync_lock_id      =(string)trim(@$this->input->post("sync_lock_id"));
        $user_id           =(string)trim(@$this->input->post("user_id"));


        if(!empty($sync_lock_id) && isset($sync_lock_id)) {
            $data=array(
                        'user_id'       => $user_id,
                        'qr_id'         => $qr_id,
                        'lock_response' => $lock_response,
						'sync_lock_id'  => $sync_lock_id,
            );
            $bridge_event_log = $this->Common_model('zo_bridge_log',$data);
                
            // $bridge_event_log = $this->apimodel->bridge_log($sync_lock_id, $lock_response, $qr_id, $user_id);

            if(!empty($bridge_event_log) && isset($bridge_event_log)) {

               
                $data = array('status'  => 'true', 'message' => 'Event  Data found successfully.', 'data' => $lock_response_event);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
        
    }   
}
?>