<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model("admin/user/User_model");
        $isLoggedIn = $this->session->userdata('isLoggedIn');

        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('admin/login');
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Add User
        Date        : 08-04-2022
    */
    public function add_user() {
        
        $qr_string = $this->input->post('qr_string');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /*Edit Record */
            $data = array();
            $id   = $this->uri->segment(4);
            $data['button'] = 'Add User';
            if($id) {
                $data['edit_data'] = $this->User_model->edit($id);
                $data['button'] = 'Update User';
            }
            $this->load->view('admin/user/add_user',$data);
        }
        else {

            $name          = trim($this->input->post('name'));
            $email         = trim($this->input->post('email'));
            $status        = trim($this->input->post('status'));
            $password      = trim($this->input->post('password'));
            $old_password  = trim($this->input->post('old_password'));
            $mobile_number = trim($this->input->post('mobile_number'));
            $is_verify     = trim($this->input->post('is_verify'));
            $user_id       = trim($this->input->post('user_id'));

            $response = $this->User_model->validate_email($email , $user_id);

            if(!empty($response) && isset($response)) {
                
                $data = array('result' => 'failure', 'message' => 'Email addess is already exists.');
                echo json_encode($data);
                exit;

            } else {

                $data = array(
                    'name'          => $name,
                    'email'         => $email,
                    'password'      => $password ? md5($password) : $old_password,
                    'mobile_number' => $mobile_number,
                    'status'        => $status,
                    'is_verify'     => $is_verify,                   
                );

                if(!empty(@$user_id) && isset($user_id)) {

                    $data['modified_on'] =  date("Y-m-d H:i:s");
                    $where_con = array('user_id' => $user_id);
                    $result = $this->Common_model->update_by_where_array('zo_tbl_user',$where_con, $data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'User updated succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'User not updated please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }

                } else {

                    $data['created_on']  =  date("Y-m-d H:i:s");                    
                    $result   = $this->Common_model->insert_data('zo_tbl_user',$data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'User added succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'User not added please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }
                }
            }            
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage User List
        Date        : 25-05-2022
    */
    public function manage_user() {   
        $this->load->view("admin/user/manage_user");
    }

    /*
        Author     : Naresh Lakhara
        Description: Manage user Ajax
        Date       : 25-05-2022
    */
    public function manage_user_ajax() {
        $lock_list = $this->User_model->manage_user_ajax();
        echo json_encode($lock_list);
        exit;
    }

    /*
        Author     : Naresh Lakhara
        Description: Status Changes
        Date       : 25-05-2022
    */
    public function status_changes() {

        $user_id   = $this->input->post('user_id');
        $is_status = $this->input->post('is_status');
        $is_verify = $this->input->post('is_verify');

        $where_con = array('user_id' => $user_id);
        $data      = array('status' => $is_status, 'is_verify' => $is_verify);
        $result    = $this->Common_model->update_by_where_array('zo_tbl_user', $where_con, $data);

        if(!empty($result) && isset($result)) {
            $final_array = array('result' => 'success' , 'message' => 'Updated Successfully.');
            echo json_encode($final_array);
            exit;
        } else {
            $final_array = array('result' => 'failure' , 'message' => 'Something error found please try again later.');
            echo json_encode($final_array);
            exit;
        }
    }
}