<?php
class Lock_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Ajax Through List Display
    */
    public function manage_lock_ajax() {

        $in = $_POST ? $_POST : array();        
        
        $q = "SELECT zo_l.qr_id, zo_l.qr_string, zo_u.user_id, zo_u.name , if(zo_l.status = '1', 'Active', 'suspended' ) as status 
        FROM zo_lock_qr as zo_l  LEFT JOIN zo_tbl_user as zo_u ON zo_u.user_id = zo_l.u_id WHERE zo_l.is_bridge ='0' AND 1 = 1 ";

        if (@$in['search']['value']) {
           $q .= ' AND (zo_u.name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                zo_l.qr_string LIKE "%' . trim(@$in['search']['value']) . '%")';
        }      

        $q .= " ORDER BY `{$in['order'][0]['column']}` {$in['order'][0]['dir']} ";

        $query = $this->db->query($q);
        $total = $query->num_rows();

        $qury  = $q . " LIMIT {$in['start']}, {$in['length']}";
        $exe_q = $this->db->query($qury);
        $data   = $exe_q->result_array();

        $final_array = array();

        foreach ($data as $key => $data_value) {

            if($data_value['status'] == 'Active') {
                $status = "<span style='color:green'>".@$data_value['status']."</span>";
            } else {
                $status = "<span style='color:red'>".@$data_value['status']."</span>";                
            }

            /* Generate QR Code */

            $qr_code = 'idoor-'.$data_value['qr_id'];

            $PNG_TEMP_DIR   = getcwd().'/uploads/qr_code/'.$qr_code.'_qr_code.png';
            if(!file_exists($PNG_TEMP_DIR)) {
                qr_code_generate($filename = $qr_code, $errorCorrectionLevel = 'L', $matrixPointSize = '10');
            }
            
            $qr_code_path = getcwd().'/uploads/qr_code/'.$qr_code.'_qr_code.png';
            if(file_exists($qr_code_path)) {
                $qr_code_url =  base_url('/uploads/qr_code/').$qr_code.'_qr_code.png';
            }
            // echo '<pre>'; print_r($data);exit;
            $final_array[] = array(
                "qr_id"     => @$data_value['qr_id'],
                "qr_code"   => @$qr_code_url ? @$qr_code_url : "",
                "qr_string" => @$data_value['qr_string'],
                "name"      => @$data_value['user_id'] ? @$data_value['user_id'] : "-",
                "status"    => $status,                
            );
        }

        echo json_encode(array(
           "data"            => $final_array,
           "recordsTotal"    => $total ? $total : 0,
           "recordsFiltered" => $total ? $total : 0,
       ));
       exit;
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Edit Lock
    */
    public function edit_lock($id) {
        $qr = "SELECT * FROM zo_lock_qr WHERE qr_id = '$id'";
        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Edit Lock
    */
    public function validate_qrstring($qr_string, $e_id) {

        $qr = "SELECT * FROM zo_lock_qr WHERE qr_string like '$qr_string'";

        if(!empty($e_id) && isset($e_id)) {
            $qr .= " AND qr_id != '$e_id'";
        }

        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 06-02-2022
        Description: Reset Lock
    */
    public function reset_lock($qr_id){
        
        /* FINGER DELETE */        
        $where_con      = array('qr_id' => $qr_id);
        $field          = array('GROUP_CONCAT(sync_lock_id) AS sync_lock_id');
        $sync_lock_data = $this->Common_model->single_record_fetch($field, 'zo_sync_lock', $where_con);
        $sync_lockid     = $sync_lock_data['sync_lock_id'];
        $qr = "UPDATE zo_lock_finger SET is_delete = '1' WHERE sync_lock_id in($sync_lockid)";
        $query  = $this->db->query($qr);

        /* SYNC LOCK DELETE */
        $this->Common_model->update_by_where_array('zo_sync_lock', $where_con, array('is_delete' => '1'));

        /* INVITE TABLE ENTRY REMOVE */
        $this->Common_model->update_by_where_array('zo_user_invite', $where_con, array('is_delete' => '1'));
        
        /* USER ID RESET */
        $updated = $this->Common_model->update_by_where_array('zo_lock_qr', $where_con, array('u_id' => '0'));

        return $updated;
    }
}