var app = require('express')();
var http = require('http').Server(app);
var io = require('socket.io')(http);
var port= 3000;

app.get('env', function() {
    io.set('log level', 1);
    io.set('store', store);
    io.set('close timeout', 60 * 60 * 24);
    io.set('heartbeat timeout', 60 * 60 * 24);
});


const users = {};

io.on('connection', function(socket){
    
    console.log(`Client ID= ${socket.id} said --> Hello`);
   
    socket.on('CONNECT_TO_ROOM', function(event_data)    {           
         if(event_data.branch_id)    
          {              
             console.log("employee details = ",event_data);           
          }        
           let rm_nm = event_data.room_name;
           socket.join(rm_nm);         
           var users = [];   
           var nsp = "/";    
           var res = [];        
           room = io.sockets.adapter.rooms[rm_nm];      
            if (room) {       
                for (var id in room) {    
                    res.push(io.sockets.adapter.nsp.connected[id]);   
               
                }     
            }
    }); 
        
    socket.on('PING', function() {              
        console.log("PING");          
        io.sockets.connected[ socket.id ].emit('PING_CALLBACK');         
    });              
    socket.on('LEAVE_ROOM', function(event_data) {  
        console.log("LEAVE_ROOM :: " + JSON.stringify(event_data));              
        socket.leave(event_data.room_name);          
        io.sockets.connected[ socket.id ].emit('LEAVE_ROOM_CALLBACK', event_data);    
    });   
              
    
    socket.on('DISCONNECT_TO_ROOM', function(event_data) {     
        console.log("DISCONNECT_TO_ROOM :: " + JSON.stringify(event_data));         
        socket.leave(event_data.room_name);            
        io.emit('DISCONNECT_TO_ROOM_CALLBACK', event_data);   

    });

            
    

    socket.on('event_name', (event_data) => {
        users[socket.id] = event_data.employee_name;
        
        console.log(event_data);
        if(!event_data.employee_name){
            
            io.to(event_data.room_name).emit('event_name', event_data);
        }
        

    });
    socket.on('event_action_completed', (event_data) => {
        users[socket.id] = event_data.employee_name;
       
        console.log(event_data);
        if(!event_data.employee_name){
          
            io.to(event_data.room_name).emit('event_name', event_data);
        }
        

    });
     socket.on('event_action_others', (event_data) => {
        users[socket.id] = event_data.employee_name;
       
        console.log(event_data);
        if(!event_data.employee_name){
          
            io.to(event_data.room_name).emit('event_name', event_data);
        }
        

    });
  

});



http.listen(port, function(){
    console.log(`node is running on port:${port}`);
});