<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/dashboard/Dashboard_model');        
        $isLoggedIn = $this->session->userdata('isLoggedIn');                
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('admin');
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 26-10-2021
        Description : Dashboard view page   
    */
    public function index()
    {
        $this->load->view('admin/dashboard/dashboard');
    }

    /*
        Author : Naresh Lakhara
        Date   : 26-10-2021
        Description : Update Profile Section  
    */
    public function update_profile()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('user_name', 'User Name', 'required');        
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');

        if($this->form_validation->run() !== TRUE) {

            $field = array('user_id','user_name', 'user_image', 'email', 'password');
            $where_con = array('user_id' => $_SESSION['user_id']);
            $data['edit_profile']        = $this->Common_model->single_record_fetch($field,'tbl_user',$where_con);
            $this->load->view('admin/dashboard/edit_profile', $data);

        } else {
            

            if (!empty($_FILES['user_image']['name'])) {
                
                $config['upload_path']          = './uploads/admin/profile';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('user_image')) {
                    $error = array('error' => $this->upload->display_errors());                                
                    $this->session->set_flashdata('error', $this->upload->display_errors());                        
                } else {
                    $data = array('upload_data' => $this->upload->data());
                    $image = $data['upload_data']['file_name']; 
                }                
            } else {

                $image = @$this->input->post('old_user_image');
            }

            $user_name          = $this->input->post('user_name');
            $email              = $this->input->post('email');
            $confirm_password   = $this->input->post('confirm_password');
            $old_password      = $this->input->post('old_password');

            /*Clinician Add*/
            $update_data = array(
                'user_name'     => @$user_name ? $user_name : "", 
                'user_image'    => @$image ? $image : "",
                'email'         => @$email ? $email : "", 
                'password'      => @$confirm_password ? md5($confirm_password) : $old_password, 
                'created_on'    => date("Y-m-d H:i:s"),
                'created_by'    => @$_SESSION['user_id'],
            );           

            $where_con = array('user_id' => $_SESSION['user_id']);
            $result = $this->Common_model->update_by_where_array('tbl_user', $where_con, $update_data);

            if($result) {
                $array = array('result' => 'success', 'message' => 'Profile updated successfully');
                echo json_encode($array);
            } else {
                $array = array('result' => 'failure', 'message' => 'Profile not updated please try again later.');
                echo json_encode($array);
            }                
        }     
    }
}