<?php
class Lock_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Ajax Through List Display
    */
    public function manage_lock_ajax() {

        $in = $_POST ? $_POST : array();        
        
        $q = "SELECT zo_l.qr_id, zo_l.qr_string, zo_u.name , if(zo_l.status = '1', 'Active', 'suspended' ) as status 
        FROM zo_lock_qr as zo_l  LEFT JOIN zo_tbl_user as zo_u ON zo_u.user_id = zo_l.u_id WHERE 1 = 1 ";

        if (@$in['search']['value']) {
           $q .= ' AND (zo_u.name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                zo_l.qr_string LIKE "%' . trim(@$in['search']['value']) . '%")';
        }      

        $q .= " ORDER BY `{$in['order'][0]['column']}` {$in['order'][0]['dir']} ";

        $query = $this->db->query($q);
        $total = $query->num_rows();

        $qury  = $q . " LIMIT {$in['start']}, {$in['length']}";
        $exe_q = $this->db->query($qury);
        $data   = $exe_q->result_array();

        $final_array = array();

        foreach ($data as $key => $data_value) {

            if($data_value['status'] == 'Active') {
                $status = "<span style='color:green'>".@$data_value['status']."</span>";
            } else {
                $status = "<span style='color:red'>".@$data_value['status']."</span>";                
            }

            /* Generate QR Code */

            $qr_code = 'idoor-'.$data_value['qr_id'];

            $PNG_TEMP_DIR   = getcwd().'/uploads/qr_code/'.$qr_code.'_qr_code.png';
            if(!file_exists($PNG_TEMP_DIR)) {
                qr_code_generate($filename = $qr_code, $errorCorrectionLevel = 'L', $matrixPointSize = '10');
            }
            
            $qr_code_path = getcwd().'/uploads/qr_code/'.$qr_code.'_qr_code.png';
            if(file_exists($qr_code_path)) {
                $qr_code_url =  base_url('/uploads/qr_code/').$qr_code.'_qr_code.png';
            }
            
            $final_array[] = array(
                "qr_id"     => @$data_value['qr_id'],
                "qr_code"   => @$qr_code_url ? @$qr_code_url : "",
                "qr_string" => @$data_value['qr_string'],
                "name"      => @$data_value['name'] ? @$data_value['name'] : "-",
                "status"    => $status,                
            );
        }

        echo json_encode(array(
           "data"            => $final_array,
           "recordsTotal"    => $total ? $total : 0,
           "recordsFiltered" => $total ? $total : 0,
       ));
       exit;
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Edit Lock
    */
    public function edit_lock($id) {
        $qr = "SELECT * FROM zo_lock_qr WHERE qr_id = '$id'";
        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 22-04-2022
        Description: Edit Lock
    */
    public function validate_qrstring($qr_string, $e_id) {

        $qr = "SELECT * FROM zo_lock_qr WHERE qr_string like '$qr_string'";

        if(!empty($e_id) && isset($e_id)) {
            $qr .= " AND qr_id != '$e_id'";
        }

        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }
   
























    /*
      Author : Naresh Lakhara
      Date   : 23-10-2020
      Description : State Fetch
    */
    public function fetch_state() {
        $this->db->select('state_city_pin_id,entry_type,reference');
        $this->db->from("tbl_state_city_pincode");
        $this->db->where("entry_type", '0');
        $this->db->where("status", '1');
         return $this->db->get()->result_array();
    }

    /*
      Author : Naresh Lakhara
      Date   : 23-10-2020
      Description : City Ajax
    */
    public function state_wise_city($state_id) {
        $this->db->select('state_city_pin_id,entry_type,reference');
        $this->db->from("tbl_state_city_pincode");
        $this->db->where("entry_type", '1');
        $this->db->where("parent_id", $state_id);
        $this->db->where("status", '1');
        return $this->db->get()->result_array();
    }

    /*
      Author : Naresh Lakhara
      Date   : 23-10-2020
      Description : City Ajax
    */
    public function city_wise_pincode_fetch($city_id) {
        $this->db->select('state_city_pin_id,entry_type,reference');
        $this->db->from("tbl_state_city_pincode");
        $this->db->where("entry_type", '2');
        $this->db->where("parent_id", $city_id);
        $this->db->where("status", '1');
        return $this->db->get()->result_array();
    }

    /*
        Author : Naresh Lakhara
        Date   : 23-10-2020
        Description : Employe Details Fetch 1 for rsm || 2 bsm || 3 tso
    */
    public function get_employee_details() {

        $this->db->select('employee_id,employee_name,employee_type_id');
        $this->db->from("tbl_employees");
        $employee_list = $this->db->get()->result_array();
        $final_data = array();
        foreach ($employee_list as $key => $emp_date) {

            if($emp_date['employee_type_id'] == '1') {
                $final_data['rsm_list'][] = $emp_date;
            } elseif ($emp_date['employee_type_id'] == '2') {
                $final_data['bsm_list'][] = $emp_date;
            } elseif ($emp_date['employee_type_id'] == '3') {
                $final_data['tso_list'][] = $emp_date;
            }
        }
        return $final_data;
    }

    /*
        Author : Naresh Lakhara
        Date   : 23-10-2020
        Description : Customer Type Fetch
    */
    public function get_customer_type() {

        $customer_type = $this->Common_model->select_by_where_array('tbl_channel_customer_type',array('status' => '1'),'array');
        if($customer_type) {
            return $customer_type;
        } else {
            return array();
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 23-10-2020
        Description : Food  Type Fetch
    */
    public function chef_details() {

        $food_chef     = $this->Common_model->position_type_base_fetch_chef_details('4');
        $bakery_chef   = $this->Common_model->position_type_base_fetch_chef_details('5');
        $beverage_chef = $this->Common_model->position_type_base_fetch_chef_details('6');

        $final_array = array(
            'food_chef'     => (array)$food_chef,
            'bakery_chef'   => (array)$bakery_chef,
            'beverage_chef' => (array)$beverage_chef,
        );

        if($final_array) {
            return $final_array;
        } else {
            return array();
        }
    }


    /*
        Author : Naresh Lakhara
        Date   : 23-10-2020
        Description : Chef Type Fetch
    */
    public function chef_type($food_type_id) {

        $chef_type_list = $this->Common_model->select_by_where_array('tbl_chef',array('status' => '1','food_type_id' => $food_type_id ),'array');

        if($chef_type_list) {
            return $chef_type_list;
        } else {
            return array();
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 23-10-2020
        Description : tbl_channel_group Fetch
    */
    public function chanel_group() {

        $chanel_group_list = $this->Common_model->select_by_where_array('tbl_channel_group',array('status' => '1'),'array');

        if($chanel_group_list) {
            return $chanel_group_list;
        } else {
            return array();
        }
    }

    

   

    

    /*
        Author : Naresh Lakhara
        Date   : 03-10-2020
        Description : City Fetch
    */
    public function city_get($city_id) {
        $qr = "SELECT state_city_pin_id,reference FROM `tbl_state_city_pincode` WHERE state_city_pin_id IN($city_id) and entry_type = 1";
        $query  = $this->db->query($qr);
        $result = $query->result_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 31-10-2020
        Description : State Fetch
    */
    public function state_get($state_id) {
        $qr = "SELECT state_city_pin_id,reference FROM `tbl_state_city_pincode` WHERE state_city_pin_id IN($state_id) and entry_type = 0";
        $query  = $this->db->query($qr);
        $result = $query->result_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 04-03-2021
        Description : Distributor Details API
    */
    function distributor_details_fetch($employee_id) {

        $qr = "SELECT employee_id,employee_name,pincode_ids FROM `tbl_employees` WHERE employee_id = '$employee_id'";
        $query  = $this->db->query($qr);
        $result = $query->row_array();

        $pincode_ids = @$result['pincode_ids'];

        if($pincode_ids == '' || $pincode_ids == '0') {
            return false;
        } else {

            $query  = "select dis.distributor_id, dis.distributor_name, dis.distributor_name, dis.phone, dis.phone,dis.email,dis.address1,dis.address2, dis.distributor_code, dis.distributor_image,dis.pincode_ids, pin.reference as pincode, dis.created_on from tbl_distributor as dis
                JOIN tbl_state_city_pincode as pin on pin.state_city_pin_id = dis.pincode_ids
                where dis.pincode_ids IN($pincode_ids) and dis.status='1' and dis.is_delete ='0'";

            $query_exe = $this->db->query($query);

            if($query_exe->num_rows() > 0 ) {
                $distributor_details = $query_exe->result_array();
                return $distributor_details;
            } else {
                return false;
            }
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 27-08-2021
        Description : BSM name fetch
    */
    function bsm_list_ajax($employee_id) {

        $qr = "SELECT employee_id,employee_name,assign_bsm_id FROM `tbl_employees` WHERE ";

        if(!empty($employee_id) && isset($employee_id)) {

            $qr .= " employee_id = '$employee_id'";

            $query  = $this->db->query($qr);

            $result = $query->row_array();

            $bsm_id = $result['assign_bsm_id'];

            $query2  = "SELECT employee_id,employee_name FROM `tbl_employees` WHERE employee_id = '$bsm_id'";

            $query_exe = $this->db->query($query2);

            if($query_exe->num_rows() > 0 ) {
                $bsm_details = $query_exe->result_array();
                return $bsm_details;
            } else {
                return false;
            }

        } else {

            $qr .= " employee_type_id = '2' ";

            $query  = $this->db->query($qr);

            if($query->num_rows() > 0 ) {
                $bsm_details = $query->result_array();
                return $bsm_details;
            } else {
                return false;
            }
        }

    }

    /*
        Author : Naresh Lakhara
        Date   : 27-08-2021
        Description : RSM name fetch
    */
    function rsm_list_ajax($employee_id) {

        $qr = "SELECT employee_id, employee_name, assign_rsm_id FROM `tbl_employees` WHERE ";

        if(!empty($employee_id) && isset($employee_id)) {

            $qr .= " employee_id = '$employee_id' ";

            $query  = $this->db->query($qr);

            $result = $query->row_array();

            $rsm_id = $result['assign_rsm_id'];

            $query2  = "SELECT employee_id,employee_name FROM `tbl_employees` WHERE employee_id = '$rsm_id'";

            $query_exe = $this->db->query($query2);

            if($query_exe->num_rows() > 0 ) {
                $rsm_details = $query_exe->result_array();
                return $rsm_details;
            } else {
                return false;
            }

        } else {

            $qr .= " employee_type_id = '1' ";

            $query  = $this->db->query($qr);

            if($query->num_rows() > 0 ) {
                $rsm_details = $query->result_array();
                return $rsm_details;
            } else {
                return false;
            }

        }

        echo '<pre>';print_r($qr);exit;


    }

    /*
        Author : Naresh Lakhara
        Date   : 21-06-2021
        Description : Customer Details Fetch
    */
    function cutomer_data_export($final_offset, $per_sheet_record) {

        $q = "SELECT customer_id,customer_code,customer_name,channel_group_id,customer_type_id,customer_sub_type_id,registered_person_name,registered_person_contact,
        billing_person_name,billing_person_contact,phone,address1,address2,state_id,city_id,pincode,rsm_employee_id,bsm_employee_id,tso_employee_id,
        food_chef_id,bakery_chef_id,beverage_chef_id,vat_number,gst_number,fssai_number,preferred_distributor

        FROM tbl_customer as tc

        WHERE  1 = 1 ORDER BY customer_id ASC LIMIT $final_offset, $per_sheet_record ";

       // if ($filter['search']) {
       //     $q .= ' AND (tc.customer_id LIKE "' . trim($filter['search']) . '%" OR
       //              tc.customer_name LIKE "' . trim($filter['search']) . '%" OR
       //              tc.phone LIKE "' . trim($filter['search']) . '%" OR
       //              tc.email LIKE "' . trim($filter['search']) . '%")';
       // }

       // if(isset($filter['state_id']) && !empty($filter['state_id'])) {

       //      $q .= " AND (tc.state_id = '".$filter['state_id']."') " ;
       // }

       //  if(isset($filter['city_id']) && !empty($filter['city_id'])) {

       //      $implode = implode(',', $filter['city_id']);
       //      $q .= " AND (tc.city_id IN (".$implode.")) " ;
       //  }


       //  if(isset($filter['tso_bsm_id']) && !empty($filter['tso_bsm_id'])) {

       //      $field      = array('employee_id','employee_type_id');
       //      $emp_data   = $this->Common_model->single_record_fetch($field,'tbl_employees',array('employee_id' => $filter['tso_bsm_id']));

       //      if($emp_data['employee_type_id'] == '1') {
       //          $field_name = 'rsm_employee_id';
       //      } elseif ($emp_data['employee_type_id'] == '2') {
       //          $field_name = 'bsm_employee_id';
       //      } elseif ($emp_data['employee_type_id'] == '3') {
       //          $field_name = 'tso_employee_id';
       //      } else{
       //          $field_name = 'tso_employee_id';
       //      }

       //      $q .= " AND ($field_name = '".$filter['tso_bsm_id']."')" ;
       //  }

       //  if($filter['approval_status'] == '0' || $filter['approval_status'] == '1' ) {

       //      $q .= " AND (tc.is_approved = '".$filter['approval_status']."') " ;
       //  }


       // $filter['sortdir'] = $filter['sortdir'] == "desc" ? "DESC" : "ASC";

        $query = $this->db->query($q);

        $final_array = array();

        if($query->num_rows() > 0) {


            $customers = $query->result_array();

            foreach ($customers as $key => $value) {

                /*Check Chanel Group Avaliable or not */
                $field_name    = array('group_name');
                $where_con     = array('channel_group_id' => $value['channel_group_id']);
                $chanel_group  =  $this->Common_model->single_record_fetch($field_name,'tbl_channel_group',$where_con);

                /*Check Customer Type Avaliable or not */
                $field_name        = array('type_name');
                $where_con         = array('customer_type_id' => $value['customer_type_id']);
                $customer_type     =  $this->Common_model->single_record_fetch($field_name,'tbl_channel_customer_type',$where_con);

                /*Check Customer Sub Type Avaliable or not */
                $field_name         = array('type_name');
                $where_con          = array('customer_type_id' => $value['customer_sub_type_id']);
                $customer_sub_type  =  $this->Common_model->single_record_fetch($field_name,'tbl_channel_customer_type',$where_con);

                /*Check State Avaliable or not */
                $field_name         = array('reference');
                $where_con          = array('state_city_pin_id' => $value['state_id'] , 'entry_type' => '0');
                $state_id           =  $this->Common_model->single_record_fetch($field_name,'tbl_state_city_pincode',$where_con);

                /*Check City Avaliable or not */
                $field_name         = array('reference');
                $where_con          = array('state_city_pin_id' => $value['city_id'] , 'entry_type' => '1');
                $city_id           =  $this->Common_model->single_record_fetch($field_name,'tbl_state_city_pincode',$where_con);

                /*Check pincode Avaliable or not */
                $field_name         = array('reference');
                $where_con          = array('state_city_pin_id' => $value['pincode'] , 'entry_type' => '2');
                $pincode            =  $this->Common_model->single_record_fetch($field_name,'tbl_state_city_pincode',$where_con);

                /*Check RSM Avaliable or not */
                $field_name         = array('employee_name');
                $where_con          = array('employee_id' => $value['rsm_employee_id'] , 'employee_type_id' => '1');
                $rsm_emp_id         = $this->Common_model->single_record_fetch($field_name,'tbl_employees',$where_con);

                /*Check BSM Avaliable or not */
                $field_name         = array('employee_name');
                $where_con          = array('employee_id' => $value['bsm_employee_id'] , 'employee_type_id' => '2');
                $bsm_emp_id         = $this->Common_model->single_record_fetch($field_name,'tbl_employees',$where_con);

                /*Check TSO Avaliable or not */
                $field_name         = array('employee_name');
                $where_con          = array('employee_id' => $value['tso_employee_id'] , 'employee_type_id' => '3');
                $tso_emp_id         = $this->Common_model->single_record_fetch($field_name,'tbl_employees',$where_con);

                /*Check Chef Avaliable or not */
                $field_name         = array('chef_name');
                $where_con          = array('chef_id' => $value['food_chef_id'] , 'food_type_id' => '1');
                $chef_id            = $this->Common_model->single_record_fetch($field_name,'tbl_chef',$where_con);

                /*Check BakeryChef Avaliable or not */
                $field_name         = array('chef_name');
                $where_con          = array('chef_id' => $value['bakery_chef_id'] , 'food_type_id' => '2');
                $bakery_id            = $this->Common_model->single_record_fetch($field_name,'tbl_chef',$where_con);

                /*Check Beverage Avaliable or not */
                $field_name         = array('chef_name');
                $where_con          = array('chef_id' => $value['beverage_chef_id'] , 'food_type_id' => '3');
                $beverage_id            = $this->Common_model->single_record_fetch($field_name,'tbl_chef',$where_con);

                /* Distributor Name fetch */
                $field_name         = array('distributor_name');
                $where_con          = array('distributor_id' => $value['preferred_distributor'] );
                $preferred_distributor        = $this->Common_model->single_record_fetch($field_name,'tbl_distributor',$where_con);


                $final_array[] = array(
                    'customer_id'               => @$value['customer_id'],
                    'customer_code'             => @$value['customer_code'],
                    'customer_name'             => @$value['customer_name'],
                    'channel_group_id'          => @$chanel_group['group_name'] ? @$chanel_group['group_name'] : "" ,
                    'customer_type_id'          => @$customer_type['type_name'] ? @$customer_type['type_name'] : "",
                    'customer_sub_type_id'      => @$customer_sub_type['type_name'] ? @$customer_sub_type['type_name'] : '',
                    'registered_person_name'    => @$value['registered_person_name'],
                    'registered_person_contact' => @$value['registered_person_contact'],
                    'billing_person_name'       => @$value['billing_person_name'],
                    'billing_person_contact'    => @$value['billing_person_contact'],
                    'phone'                     => @$value['phone'],
                    'address1'                  => @$value['address1'],
                    'address2'                  => @$value['address2'],
                    'state_id'                  => @$state_id['reference'] ? @$state_id['reference'] : '',
                    'city_id'                   => @$city_id['reference']  ? @$city_id['reference'] : '',
                    'pincode'                   => @$pincode['reference']  ? @$pincode['reference'] : '',
                    'rsm_employee_id'           => @$rsm_emp_id['employee_name'] ? @$rsm_emp_id['employee_name'] : '0',
                    'bsm_employee_id'           => @$bsm_emp_id['employee_name'] ? @$bsm_emp_id['employee_name'] : '0',
                    'tso_employee_id'           => @$tso_emp_id['employee_name'] ? @$tso_emp_id['employee_name'] : '0',
                    'food_chef_id'              => @$chef_id['chef_name'] ? @$chef_id['chef_name'] : '0',
                    'bakery_chef_id'            => @$bakery_id['chef_name'] ? @$bakery_id['chef_name'] : '0',
                    'beverage_chef_id'          => @$beverage_id['chef_name'] ? @$beverage_id['chef_name'] : '0',
                    'vat_number'                => @$value['vat_number'],
                    'gst_number'                => @$value['gst_number'],
                    'fssai_number'              => @$value['fssai_number'],
                    'preferred_distributor'     => @$preferred_distributor['distributor_name'] ? $preferred_distributor['distributor_name'] : "",
                );
            }

            return $final_array;

        } else {

            return $final_array;
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 16-08-2021
        Description : Ajax Through List Display
    */
    public function contact_list_of_employee() {

        $tmp = array();
        $out = array();
        $in = $_POST ? $_POST : array();

        $filter = array();
        $filter['sortfield'] = $in['order'][0]['column'];
        $filter['sortdir']   = $in['order'][0]['dir'];
        $filter['search']    = $in['search']['value'];
        $filter['start']     = $in['start'];
        $filter['length']    = $in['length'];
        $filter['customer_id']  = $in['search_data']['customer_id'];

        $tmp = $this->Customer_model->get_filtered_data2($filter);

        if (count($tmp) >= 1) {

           foreach ($tmp['data'] as $k => $v) {

                $o = array(
                    $v['contact_name'],
                    $v['designation'],
                    $v['email'],
                    $v['phone1'],
                    $v['phone2'],
                    $v['phone1_mark_as_whatsapp'],
                    $v['phone2_mark_as_whatsapp'],
                    $v['status'],
                    $v['created_on'],
               );
               $out[] = $o;
            }
        }

        echo json_encode(array(
           "data" => $out,
           "recordsTotal" => $tmp['total'] ? $tmp['total'] : 0,
           "recordsFiltered" => $tmp['total'] ? $tmp['total'] : 0,
       ));
       exit;
    }

    /*
        Author : Naresh Lakhara
        Date   : 16-08-2021
        Description : Contact Details
    */

    public function get_filtered_data2($filter, $start = 0, $length = 10) {

        $start  = $filter['start']  ? $filter['start']  : $start;
        $length = $filter['length'] ? $filter['length'] : $length;

        $customer_id = @$filter['customer_id'];

        $q  = "SELECT cust_con.contact_id,cust_con.contact_name, cust_con.customer_id, cust_con.designation_id, des_mas.designation, cust_con.email,
        cust_con.phone1, cust_con.phone2, cust_con.other_designation_name,cust_con.phone1_mark_as_whatsapp,cust_con.phone2_mark_as_whatsapp,cust_con.status,cust_con.created_on
        from tbl_customer_contact as cust_con  JOIN tbl_designation_master as des_mas ON des_mas.designation_id = cust_con.designation_id
        WHERE cust_con.customer_id = '$customer_id' and cust_con.status = '1' and cust_con.is_delete = '0'";

        if (!empty($filter['search']) && isset($filter['search'])) {
            $search = trim($filter['search']);
            $q.= " AND (des_mas.designation like '%$search%'
                OR cust_con.contact_name like '%$search%'
                OR cust_con.email like '%$search%'
                OR cust_con.phone1 like '%$search%'
                OR cust_con.phone2 like '%$search%'
            ) ";
        }

        $filter['sortdir'] = $filter['sortdir'] == "asc" ? "ASC" : "DESC";

        $q .= " ORDER BY {$filter['sortfield']} {$filter['sortdir']} ";

        $qry = $q;

        $query = $this->db->query($qry);
        $total = count($query->result_array());
        $qury = $q . " LIMIT {$start}, {$length}";

        $employee = $this->db->query($qury);
        $data = $employee->result_array();

        $final_array = array();

        foreach ($data as $key => $contact_data) {

            if($contact_data['designation_id'] == '8') {
                $designation = $contact_data['designation']. ' : '.$contact_data['other_designation_name'];
            } else {
                $designation = $contact_data['designation'];
            }

            $final_array[] = array(

                "contact_id"                => $contact_data['contact_id'],
                "contact_name"              => $contact_data['contact_name'],
                "designation"               => $designation,
                "other_designation_name"    => $contact_data['other_designation_name'] ? $contact_data['other_designation_name'] : "-",
                "email"                     => $contact_data['email'],
                "phone1"                    => $contact_data['phone1'],
                "phone2"                    => $contact_data['phone2'],
                "phone1_mark_as_whatsapp"    => $contact_data['phone1_mark_as_whatsapp'] ? 'Yes':'No',
                "phone2_mark_as_whatsapp"    => $contact_data['phone2_mark_as_whatsapp'] ? 'Yes':'No',
                "status"                    => $contact_data['status'] ? "Active" : "Suspend",
                "created_on"                => date("d-m-Y H:i",strtotime($this->Common_model->gmt_indian_timezone($contact_data['created_on']))),
            );
        }
       return array("data" => $final_array, "total" => $total);
    }

    /*
        Author : Naresh lakhara
        Date   : 06-09-2021
        Description : Employee Position
    */
    public function employee_position($employee_id = '') {

        $query = "SELECT pos.position_id, pos.position_name, pos.position_type FROM tbl_position as pos

        WHERE pos.status = '1' and pos.is_delete = '0' ";

        $exe    = $this->db->query($query);

        if($exe->num_rows() >  0) {

            $employee_list = $exe->result_array();

            $final_array = array();

            foreach ($employee_list as $key => $value) {

                //1 FOR RSM , 2 FOR BSM, 3 FOR TSO , 4 FOOD CHEF , 5 BAKERY CHEF , 6 BEVERAGE
                if($value['position_type'] == '1') {
                    $position_type = "RSM";
                } elseif ($value['position_type'] == '2') {
                    $position_type = "BSM";
                } elseif ($value['position_type'] == '3') {
                    $position_type = "TSO";
                } elseif ($value['position_type'] == '4') {
                    $position_type = "Food Chef";
                } elseif ($value['position_type'] == '5') {
                    $position_type = "Bakery Chef";
                } else {
                    $position_type = "Beverage Chef";
                }

                /*Add time display*/
                $final_array[] = array(
                    'position_id' => $value['position_id'],
                    'position_name' => $value['position_name'].' ('.$position_type.' )',
                );
            }
            return $final_array;

        } else {
            return array();
        }
    }

    /*
        Author : Naresh lakhara
        Date   : 06-09-2021
        Description : Position Id base on BSM or RSM
    */
    public function positon_base_fetch_bsm_rsm($position_id) {

        $query = "SELECT position_id, position_name, position_type, position_bsm_id, position_rsm_id FROM tbl_position WHERE position_id = '$position_id' and  status = '1' and is_delete = '0' ";

        $exe    = $this->db->query($query);

        if($exe->num_rows() >  0) {

            $employee_list = $exe->row_array();

            $final_array   = array();
            $rsm_data      = array();
            $bsm_data      = array();

            $position_bsm_id = $employee_list['position_bsm_id'];
            $position_rsm_id = $employee_list['position_rsm_id'];

            if(!empty($position_id) && isset($position_id)) {

                /*BSM Fetch*/
                $query2 = "SELECT emp.employee_id, emp.employee_name, emp.position_id FROM tbl_employees as emp

                WHERE emp.position_id IN ($position_id)";

                $exe2    = $this->db->query($query2);

                $emp_data = $exe2->row_array();
            }

            if(!empty($position_bsm_id) && isset($position_bsm_id)) {

                /*BSM Fetch*/
                $query2 = "SELECT emp.employee_id, emp.employee_name, emp.position_id FROM tbl_employees as emp

                WHERE emp.position_id IN ($position_bsm_id)";

                $exe2    = $this->db->query($query2);

                $bsm_data = $exe2->row_array();
            }

            if(!empty($position_rsm_id) && isset($position_rsm_id)) {

                /*RSM Fetch*/
                $query3 = "SELECT emp.employee_id, emp.employee_name, emp.position_id FROM tbl_employees as emp

                WHERE emp.position_id IN ($position_rsm_id)";

                $exe3    = $this->db->query($query3);

                $rsm_data = $exe3->row_array();
            }

            $final_array = array(
                'position_name'     => @$employee_list['position_name'] ? @$employee_list['position_name'] : "-",
                'position_type'     => @$employee_list['position_type'] ? @$employee_list['position_type'] : "-",
                'employee_id'       => @$emp_data['employee_id'] ? @$emp_data['employee_id'] : "-",
                'employee_name'     => @$emp_data['employee_name'] ? @$emp_data['employee_name'] : "-",
                'bsm_employee_id'   => @$bsm_data['employee_id'] ? @$bsm_data['employee_id'] : "-",
                'bsm_employee_name' => @$bsm_data['employee_name'] ? @$bsm_data['employee_name'] : "-",
                'rsm_employee_id'   => @$rsm_data['employee_id'] ? @$rsm_data['employee_id'] : "-",
                'rsm_employee_name' => @$rsm_data['employee_name'] ? @$rsm_data['employee_name'] : "-",
            );

            return $final_array;

        } else {
            return array();
        }
    }

    /*
        Author : Naresh lakhara
        Date   : 06-09-2021
        Description : TSO , BSM , RSM fetch
    */
    public function bsm_employee_name_fetch($search) {


        $query = "SELECT pos.position_id, emp.employee_id, emp.employee_name, pos.position_type FROM tbl_employees as emp join tbl_position as pos on pos.position_id = emp.position_id
        WHERE ( emp.status = '1' and emp.is_delete = '0' AND pos.status = '1' and pos.is_delete = '0' ) AND
        ( emp.employee_name like '%$search%' or emp.employee_code like '%$search%' or emp.email like '%$search%' ) ";

        $exe    = $this->db->query($query);

        if($exe->num_rows() >  0) {

            $employee_list = $exe->result_array();

            $final_array = array();

            foreach ($employee_list as $key => $value) {

                $final_array[] = array(
                    'id'   => $value['position_id'],
                    'text' => $value['employee_name'],
                );

            }
            return $final_array;

        } else {
            return array();
        }
    }

    /*
        Author : Naresh lakhara
        Date   : 06-10-2021
        Description : beat_info
    */
    public function beat_info() {

        $query = "SELECT beat_id, beat_name from tbl_beat where status = '1'";

        $exe    = $this->db->query($query);

        if($exe->num_rows() >  0) {

            $employee_list = $exe->result_array();

            $final_array = array();

            foreach ($employee_list as $key => $value) {

                $final_array[] = array(
                    'beat_id'    => $value['beat_id'],
                    'beat_name'  => $value['beat_name'],
                );
            }
            return $final_array;

        } else {
            return array();
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 21-12-2021
        Description : Email check
    */
    public function email_check($id , $email) {

        $o_qry = "select customer_id, email from tbl_customer where email = '$email' ";

        if(!empty($id) && isset($id)) {

            $o_qry .= " AND customer_id != '$id' ";
        }

        $exe   = $this->db->query($o_qry);

        if($exe->num_rows() >  0) {

            return true;

        } else {

            return false;
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 21-12-2021
        Description : Employee Code check
    */
    public function code_check($id , $code) {

        $o_qry = "select customer_id, customer_code from tbl_customer where customer_code = '$code' ";

        if(!empty($id) && isset($id)) {

            $o_qry .= " AND customer_id != '$id' ";
        }

        $exe   = $this->db->query($o_qry);

        if($exe->num_rows() >  0) {

            return true;

        } else {

            return false;
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 22-12-2021
        Description : Parent customer  code check
    */
    public function parent_code_check($id , $code) {

        $o_qry = "select customer_id, parent_customer_code from tbl_customer where parent_customer_code = '$code' ";

        if(!empty($id) && isset($id)) {

            $o_qry .= " AND customer_id != '$id' ";
        }

        $exe   = $this->db->query($o_qry);

        if($exe->num_rows() >  0) {

            return true;

        } else {

            return false;
        }
    }

    /*
        Author : Naresh Lakhara
        Date   : 22-12-2021
        Description : Parent customer  code check
    */
    public function customer_rank_class() {

        $rank_q = "SELECT customer_rank  FROM `tbl_customer` WHERE customer_rank != '0' GROUP BY customer_rank";
        $class_q = "SELECT customer_class  FROM `tbl_customer` WHERE customer_class != '' GROUP BY customer_class";

        $exe   = $this->db->query($rank_q);
        $exe2   = $this->db->query($class_q);

        $customer_rank  = $exe->result_array();
        $customer_class = $exe2->result_array();

        $final_array = array(
            'customer_rank'  => (array)$customer_rank,
            'customer_class' => (array)$customer_class,
        );

        return $final_array;
    }
}