<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|    example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|    https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|    $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|    $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|    $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:    my-controller/index    -> my_controller/index
|        my-controller/my-method    -> my_controller/my_method
 */

/* API PATH */
$route['api/verify_qr'] = 'api/verify_qr/format/json';
$route['api/login']     = 'api/login/format/json';
$route['api/event'] = 'api/event/format/json';
$route['api/sync_event'] = 'api/sync_event/format/json';
$route['api/accept_event'] = 'api/accept_event/format/json';
$route['api/current_event'] = 'api/current_event/format/json';
$route['api/employee_action_event'] = 'api/employee_action_event/format/json';
$route['api/event_record'] = 'api/event_record/format/json';
$route['api/table_list'] = 'api/table_list/format/json';
$route['api/employee_list'] = 'api/employee_list/format/json';



/* SUPER ADMIN PORTAL PATH ROUTE */
$route['admin']                 = 'admin/Login';
$route['admin/login']           = 'admin/Login/loginMe';
// $route['admin/dashboard']       = 'admin/dashboard/dashboard';

$route['admin/restaurant/add']        = 'admin/restaurant/restaurant/add_restaurant';
$route['admin/restaurant/add/(:num)'] = 'admin/restaurant/restaurant/add_restaurant';
$route['admin/restaurant/manage']     = 'admin/restaurant/restaurant/manage_restaurant';

$route['admin/branch/add']        = 'admin/branch/branch/add_branch';
$route['admin/branch/add/(:num)'] = 'admin/branch/branch/add_branch';
$route['admin/branch/manage']     = 'admin/branch/branch/manage_branch';

/* RESTAURANT AND BRANCH PORTAL ROUTE */
$route['accountadmin']             = 'accountadmin/Login';
$route['accountadmin/login']       = 'accountadmin/Login/loginMe';
// $route['accountadmin/dashboard']   = 'accountadmin/dashboard/dashboard';

$route['accountadmin/table/add']        = 'accountadmin/table/table/add_table';
$route['accountadmin/table/add/(:num)'] = 'accountadmin/table/table/add_table';
$route['accountadmin/table/bulk_add']        = 'accountadmin/table/table/bulk_table';
$route['accountadmin/table/manage']     = 'accountadmin/table/table/manage_table';
$route['accountadmin/table/downloadImage']     = 'accountadmin/table/table/downloadImage';


$route['accountadmin/employee/add']        = 'accountadmin/employee/employee/add_employee';
$route['accountadmin/employee/add/(:num)'] = 'accountadmin/employee/employee/add_employee';
$route['accountadmin/employee/manage']     = 'accountadmin/employee/employee/manage_employee';

$route['accountadmin/action/add']                  = 'accountadmin/action/action/add_action';
$route['accountadmin/action/add/(:num)']           = 'accountadmin/action/action/add_action';
$route['accountadmin/action/update']               = 'accountadmin/action/action/update_action';
$route['accountadmin/action/action_images']        = 'accountadmin/action/action/action_images';
$route['accountadmin/action/manage']               = 'accountadmin/action/action/manage_action';
$route['accountadmin/action/feedback']             = 'accountadmin/action/action/feedback';
$route['accountadmin/action/feedback/(:any)']      = 'accountadmin/action/action/feedback';
$route['accountadmin/action/preview']              = 'accountadmin/action/action/preview';
$route['accountadmin/action/branch_wise_preview']  = 'accountadmin/action/action/branch_wise_preview';

$route['accountadmin/feedback_data']  = 'accountadmin/feedbackdata/feedback';
$route['accountadmin/feedback_fetch'] = 'accountadmin/feedbackdata/feedback/feedback_fetch';

$route['menu/branch_wise_preview']  = 'menu/branch_wise_preview';
$route['menu/(:any)']               = 'menu/menu_display';
$route['menu/action/event']         = 'menu/menu_event';
$route['menu/action/master_call']   = 'menu/master_call';
$route['submit-form']               = 'menu/submit_form';
$route['master_employee']           = 'menu/master_employee';
$route['session_destroy']           = 'menu/session_destroy';
$route['page_404']    = 'menu/page_404';


$route['default_controller']   = 'welcome';
$route['404_override']         = 'menu/page_404';
$route['translate_uri_dashes'] = FALSE;
