<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Branch extends CI_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->load->model('admin/branch/Branch_model');
        $isLoggedIn = $this->session->userdata('isLoggedIn');                
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('admin');
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 27-05-2022
        Description : Branch Add
    */
    public function add_branch()
    {    
        $this->load->library('form_validation');
        $this->form_validation->set_rules('display_name', 'Display name', 'required');
        $this->form_validation->set_rules('branch_name', 'Branch name', 'required');
        $this->form_validation->set_rules('first_name', 'First name', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('last_name', 'Last name', 'required');
        $this->form_validation->set_rules('phone_number', 'Phone number', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /* Edit Record */
            $data               = array();
            $id                 = $this->uri->segment(4);
            $data['page_name']  = "Add";
            $data['restaurant'] = $this->Branch_model->restaurant_fetch();

            if($id) {
                $data['edit_data'] = $this->Branch_model->edit($id);
                $data['page_name'] = "Update";
            }
            $this->load->view('admin/branch/add_branch',$data);
        }
        else {

            if(!empty($_FILES['branch_image']['name']) && isset($_FILES['branch_image']['name'])) {
               
                /* IF DIRECTORY DOES NOT EXISTS THEN CREATE NEW DIRECTORY */
                if(!file_exists('./uploads/branch_images')) {
                    mkdir('./uploads/branch_images', 0777, true);
                    $old = umask(0);
                    chmod('./uploads/branch_images', 0777);
                    umask($old);
                }

                /* VALIDATE IMAGES */            
                $file_types = array('jpg','jpeg','png');
                $new_name    = $_FILES['branch_image']['name'];
                $new_name    = str_replace(" ","_",$new_name);
                $image_name_explode  = explode('.', $new_name);
                $extension = end($image_name_explode);

                if(!in_array($extension, $file_types)) {
                   $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only ( jpg / jpeg / png ).');
                   echo json_encode($array); 
                   exit;
                }

                /* UPLOAD IMAGES */
                $_FILES['userfile']['name']     = $_FILES['branch_image']['name'];
                $_FILES['userfile']['type']     = $_FILES['branch_image']['type'];
                $_FILES['userfile']['tmp_name'] = $_FILES['branch_image']['tmp_name'];
                $_FILES['userfile']['error']    = $_FILES['branch_image']['error'];
                $_FILES['userfile']['size']     = $_FILES['branch_image']['size'];

                $config['upload_path']      = "./uploads/branch_images";
                $config['allowed_types']    = 'gif|jpg|png|jpeg';
                $config['overwrite']        = TRUE;
                $config['max_size']         = '0';

                $new_name   = $_FILES['branch_image']['name'];
                $new_name   =  str_replace(" ","_",$new_name);
                $config['file_name'] = strtolower($new_name);

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('userfile')){

                    $fileData         = $this->upload->data();
                    $branch_image = $fileData['file_name'];

                } else {

                    $array = array('result' => 'failure', 'message' => 'Something error found while uploading image !');
                    echo json_encode($array); 
                    exit;
                }
            } else {
                @$branch_image = trim(@$this->input->post('old_branch_image'));
            }

            /*Validate Images end */  

            $restaurant_id           = trim(@$this->input->post('restaurant_id'));
            $branch_name             = trim(@$this->input->post('branch_name'));
            $display_name            = trim(@$this->input->post('display_name'));
            $first_name              = trim(@$this->input->post('first_name'));
            $email                   = trim(@$this->input->post('email'));
            $billing_contact_person  = trim(@$this->input->post('billing_contact_person'));
            $billing_phone_number    = trim(@$this->input->post('billing_phone_number'));
            $address                 = trim(@$this->input->post('address'));
            $last_name               = trim(@$this->input->post('last_name'));
            $phone_number            = trim(@$this->input->post('phone_number'));
            $billing_email           = trim(@$this->input->post('billing_email'));
            $gst_number              = trim(@$this->input->post('gst_number'));
            $status                  = trim(@$this->input->post('status'));
            $password                = trim(@$this->input->post('password'));
            $old_password            = trim(@$this->input->post('old_password'));
            $branch_background_image = trim(@$this->input->post('branch_background_image'));
            $master_wait_time        = trim(@$this->input->post('master_wait_time'));

            $data = array(
                'restaurant_id'           => @$restaurant_id,
                'branch_name'             => @$branch_name,
                'display_name'            => @$display_name,
                'branch_image'            => @$branch_image,
                'first_name'              => @$first_name,
                'last_name'               => @$last_name,
                'email'                   => @$email,
                'password'                => @$password ? md5(@$password) : @$old_password,
                'phone_number'            => @$phone_number,
                'address'                 => @$address,
                'billing_contact_person'  => @$billing_contact_person,
                'billing_email'           => @$billing_email,
                'billing_phone'           => @$billing_phone_number,
                'gst_number'              => @$gst_number,
                'branch_background_image' => @$branch_background_image,                
                'status'                  => @$status,
                'master_wait_time'        => @$master_wait_time,
            );
            
            $branch_id = @$this->input->post('branch_id');

            $email_avalilablity = $this->Common_model->check_duplicate_email('tbl_branch', 'email', $email, 'branch_id', $branch_id);
            $email_avalilablity1 = $this->Common_model->check_duplicate_email('tbl_restaurant', 'email', $email,"", "");
            if(!empty($email_avalilablity) && isset($email_avalilablity)) { 

                $array = array('result' => 'failure', 'message' => 'Sorry ! email address is already exist.');
                echo json_encode($array); 
                exit;

            }
            elseif(!empty($email_avalilablity1) && isset($email_avalilablity1)) { 

                $array = array('result' => 'failure', 'message' => 'Sorry ! email address is already exist.');
                echo json_encode($array); 
                exit;

            }
            else {

              
                if(!empty(@$branch_id) && isset($branch_id)) {

                    $data['modified_on'] = date("Y-m-d H:i:s");
                    $data['modified_by'] = @$_SESSION['admin_id'];

                    $where_con = array('branch_id' => $branch_id);
                    $result = $this->Common_model->update_by_where_array('tbl_branch', $data, $where_con);
                    
                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Branch updated successfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Branch not updated please try again later.');
                        echo json_encode($data);
                        exit;
                    }
                } else {

                    $data['created_on'] = date("Y-m-d H:i:s");
                    $data['created_by'] = @$_SESSION['admin_id'];
                    $result   = $this->Common_model->insert_data('tbl_branch',$data);

                    /* DEFAULT ACTION INSERT */                
                    $default_data_added = array(

                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Waiter', 
                            'action_png'    => 'waiter.png',
                            'action_id'     => '1',
                            'sequence'      => '1',
                            'is_default'    => '1',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Menu', 
                            'action_png'    => 'menu.png',
                            'action_id'     => '5',
                            'sequence'      => '2',
                            'is_default'    => '1',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Water', 
                            'action_png'    => 'water.png',
                            'action_id'     => '1',
                            'sequence'      => '3',
                            'is_default'    => '1',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Bill', 
                            'action_png'    => 'bill.png',
                            'action_id'     => '1',
                            'sequence'      => '4',
                            'is_default'    => '1',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Instagram', 
                            'action_png'    => 'insta.png',
                            'action_id'     => '6',
                            'sequence'      => '1',
                            'status'        => '0',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Twitter', 
                            'action_png'    => 'twitter.png',
                            'action_id'     => '6',
                            'sequence'      => '2',
                            'status'        => '0',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Youtube', 
                            'action_png'    => 'youtube.png',
                            'action_id'     => '6',
                            'sequence'      => '3',
                            'status'        => '0',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Facebook', 
                            'action_png'    => 'facebook.png',
                            'action_id'     => '6',
                            'sequence'      => '4',
                            'status'        => '0',
                        ),
                        array(
                            'restaurant_id' => @$restaurant_id,
                            'branch_id'     => @$result,
                            'action_name'   => 'Zomato',
                            'action_png'    => 'zomato.png',
                            'action_id'     => '6',
                            'sequence'      => '5',
                            'status'        => '0',
                        )
                    );                    
                    foreach ($default_data_added as $key => $value) {
                        $this->Common_model->insert_data('tbl_branch_action', $value);                        
                    }
                    /* DEFAULT ACTION INSERT END */

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Branch added successfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Branch not added please try again later.');
                        echo json_encode($data);
                        exit;
                    }
                }
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 27-05-2022
        Description : Manage Restaurant
    */
    public function manage_branch() {
        $data = array();        
        $this->load->view("admin/branch/manage_branch", $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage Branch Ajax
        Date        : 27-05-2022
    */
    public function manage_branch_ajax() {

        $list = $this->Branch_model->manage_branch_ajax();
        echo json_encode($list = array());
        exit;
    } 
}
