<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restaurant extends CI_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->load->model('admin/restaurant/Restaurant_model');
        $isLoggedIn = $this->session->userdata('isLoggedIn');                
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('admin');
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 27-05-2022
        Description : Restaurant Add
    */
    public function add_restaurant()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('restaurant_name', 'Restaurant name', 'required');
        $this->form_validation->set_rules('first_name', 'First name', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('last_name', 'Last name', 'required');
        $this->form_validation->set_rules('phone_number', 'Phone number', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /* Edit Record */
            $data              = array();
            $id                = $this->uri->segment(4);
            $data['page_name'] = "Add";

            if($id) {
                $data['edit_data'] = $this->Restaurant_model->edit($id);
                $data['page_name'] = "Update";
            }
            $this->load->view('admin/restaurant/add_restaurant',$data);
        }
        else {

            if(!empty($_FILES['restaurant_image']['name']) && isset($_FILES['restaurant_image']['name'])) {
               
                /* IF DIRECTORY DOES NOT EXISTS THEN CREATE NEW DIRECTORY */
                if(!file_exists('./uploads/restaurant_images')) {
                    mkdir('./uploads/restaurant_images', 0777, true);
                    $old = umask(0);
                    chmod('./uploads/restaurant_images', 0777);
                    umask($old);
                }

                /* VALIDATE IMAGES */            
                $file_types = array('jpg','jpeg','png');
                $new_name    = $_FILES['restaurant_image']['name'];
                $new_name    = str_replace(" ","_",$new_name);
                $image_name_explode  = explode('.', $new_name);
                $extension = end($image_name_explode);

                if(!in_array($extension, $file_types)) {
                   $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only ( jpg / jpeg / png ).');
                   echo json_encode($array); 
                   exit;
                }

                /* UPLOAD IMAGES */

                $_FILES['userfile']['name']     = $_FILES['restaurant_image']['name'];
                $_FILES['userfile']['type']     = $_FILES['restaurant_image']['type'];
                $_FILES['userfile']['tmp_name'] = $_FILES['restaurant_image']['tmp_name'];
                $_FILES['userfile']['error']    = $_FILES['restaurant_image']['error'];
                $_FILES['userfile']['size']     = $_FILES['restaurant_image']['size'];

                $config['upload_path']      = "./uploads/restaurant_images";
                $config['allowed_types']    = 'gif|jpg|png|jpeg';
                $config['overwrite']        = TRUE;
                $config['max_size']         = '0';

                $new_name   = $_FILES['restaurant_image']['name'];
                $new_name   =  str_replace(" ","_",$new_name);
                $config['file_name'] = strtolower($new_name);

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('userfile')){

                    $fileData         = $this->upload->data();
                    $restaurant_image = $fileData['file_name'];

                } else {

                    $array = array('result' => 'failure', 'message' => 'Something error found while uploading image !');
                    echo json_encode($array); 
                    exit;
                }
            } else {
                @$restaurant_image = trim(@$this->input->post('old_restaurant_image'));
            }

            /*Validate Images end */  

            $restaurant_name        = trim(@$this->input->post('restaurant_name'));
            $first_name             = trim(@$this->input->post('first_name'));
            $email                  = trim(@$this->input->post('email'));
            $billing_contact_person = trim(@$this->input->post('billing_contact_person'));
            $billing_phone_number   = trim(@$this->input->post('billing_phone_number'));
            $address                = trim(@$this->input->post('address'));
            $last_name              = trim(@$this->input->post('last_name'));
            $phone_number           = trim(@$this->input->post('phone_number'));
            $billing_email          = trim(@$this->input->post('billing_email'));
            $gst_number             = trim(@$this->input->post('gst_number'));
            $status                 = trim(@$this->input->post('status'));
            $password               = trim(@$this->input->post('password'));
            $old_password           = trim(@$this->input->post('old_password'));

            $data = array(
                'restaurant_name'        => @$restaurant_name,
                'restaurant_image'       => @$restaurant_image,
                'first_name'             => @$first_name,
                'last_name'              => @$last_name,
                'email'                  => @$email,
                'password'               => @$password ? md5(@$password) : @$old_password,
                'phone_number'           => @$phone_number,
                'address'                => @$address,
                'billing_contact_person' => @$billing_contact_person,
                'billing_email'          => @$billing_email,
                'billing_phone'          => @$billing_phone_number,
                'gst_number'             => @$gst_number,
                'status'                 => @$status,
            );
            
            $restaurant_id = @$this->input->post('restaurant_id');

            $email_avalilablity = $this->Common_model->check_duplicate_email('tbl_restaurant', 'email', $email, 'restaurant_id', $restaurant_id);

            if(!empty($email_avalilablity) && isset($email_avalilablity)) { 

                $array = array('result' => 'failure', 'message' => 'Sorry ! email address is already exist.');
                echo json_encode($array); 
                exit;

            } else {

                if(!empty(@$restaurant_id) && isset($restaurant_id)) {

                    $data['modified_on'] = date("Y-m-d H:i:s");
                    $data['modified_by'] = @$_SESSION['admin_id'];

                    $where_con = array('restaurant_id' => $restaurant_id);
                    $result = $this->Common_model->update_by_where_array('tbl_restaurant', $data, $where_con);
                    
                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Restaurant updated successfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Restaurant not updated please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }                
                } else {

                    $data['created_on'] = date("Y-m-d H:i:s");
                    $data['created_by'] = @$_SESSION['admin_id'];

                    $result   = $this->Common_model->insert_data('tbl_restaurant',$data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Restaurant added successfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Restaurant not added please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }
                }
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 27-05-2022
        Description : Manage Restaurant
    */
    public function manage_restaurant() {
        $data = array();        
        $this->load->view("admin/restaurant/manage_restaurant", $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage Restaurant Ajax
        Date        : 27-05-2022
    */
    public function manage_restaurant_ajax() {

        $list = $this->Restaurant_model->manage_restaurant_ajax();
        echo json_encode($list = array());
        exit;
    } 
}
