<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
    Author     : Naresh Lakhara
    Description: REST API Model setup
    Date       : 15-06-2022 
*/
class Api_model extends CI_Model {

	public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }      
    /*
		Author     	: Naresh Lakhara
		Date       	: 15-06-2022
		Description	: Verify QR
	*/
    public function verify_qr($qr_code) {

    	$qr = "SELECT t_b_t.table_id, t_b_t.restaurant_id, t_b_t.branch_id, t_b_t.table_name, t_b_t.qr_image
		FROM tbl_branch_table as t_b_t WHERE 1 = 1 AND t_b_t.qr_image = '$qr_code' AND t_b_t.status = '1' AND t_b_t.is_delete = '0' ";

		$query = $this->db->query($qr);

		$final_array = array();
		
		if($query->num_rows() > 0 ) {
			
			$result = $query->row_array();

			$restaurant_id = @$result['restaurant_id'] ? base64_encode(@$result['restaurant_id']) : "0";
			$branch_id     = @$result['branch_id'] ? base64_encode(@$result['branch_id']) : "0";
			$table_id      = @$result['table_id'] ? base64_encode(@$result['table_id']) : "0";

			$menu_url = base_url("menu/$table_id");

			return $menu_url;	

		} else {

			return $final_array;			
		}
    }
    public function employee_login($email, $password){

    	$emp_query = "SELECT t_b_e.employee_id, t_b_e.restaurant_id, t_b_e.branch_id, t_b_e.employee_name,t_b_e.employee_type, t_b_e.assign_table, t_b.branch_name
						FROM tbl_branch_employee as t_b_e 
						LEFT JOIN tbl_branch as t_b on t_b.branch_id =  t_b_e.branch_id
						WHERE 1 = 1 AND t_b_e.email = '$email' AND t_b_e.password = '$password' AND t_b_e.status = '1' AND t_b_e.is_delete = '0' ";

		$query = $this->db->query($emp_query);
		$query_array=$query->row_array();
		$final_array = array();

		if($query->num_rows() > 0 ) {
			$query_array['room_name'] = 'branch_'.$query_array['branch_id'];
			$query_array['node_event_name']='event_name';
			return $query_array; 

		} else {

			return $final_array;			
		}	
    }
    public function action_event($branch_action_id, $table_id){

    	$action_query = "SELECT t_br.branch_action_id, t_br.restaurant_id,t_br.branch_id, t_br.action_name, t_b_t.table_id, t_b_t.table_name FROM tbl_branch_action as t_br
			JOIN tbl_branch_table as t_b_t on t_b_t.restaurant_id = t_br.restaurant_id AND  t_b_t.branch_id = t_br.branch_id
			WHERE t_br.branch_action_id = '$branch_action_id' AND t_b_t.table_id = '$table_id' GROUP BY t_b_t.table_id,t_br.branch_action_id";
			// echo '<pre>'; print_r($action_query);exit;
		$query = $this->db->query($action_query);
		
		$final_array = array();

		if($query->num_rows() > 0 ) {
            
            $event_info 		= $query->row_array();
            $session_id 		= $this->session->session_id;
    		$data['session_id'] = $session_id;

            $data = array(
                'restaurant_id'      => $event_info['restaurant_id'],
                'branch_id'          => $event_info['branch_id'],
                'table_id'           => $event_info['table_id'],
                'event_name'         => $event_info['action_name'],   
                'session_id'         => $session_id,           
            );

            $insert_id  = $this->Common_model->insert_data('tbl_event_log',$data); 

            if(!empty($insert_id) && isset($insert_id)) {
                return $event_info;
            } else {
                return $final_array;
            }
        } else {
            return $final_array;            
        }
    }
	public function sync_action_event($status, $branch_id, $employee_id){

		
		$table_q= "SELECT t_b_e.assign_table, t_b_e.employee_type FROM tbl_branch_employee as t_b_e WHERE t_b_e.employee_id='$employee_id'";
		$table_data= $this->db->query($table_q);
		$table_data_result=$table_data->row_array();
		$string = $table_data_result['assign_table'];
		
		
		if($table_data_result['employee_type']==0){

    	$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time FROM tbl_event_log as t_e_l 
		LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
		LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id =  t_e_l.table_id
		LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
		WHERE t_e_l.status = '$status' AND t_e_l.branch_id='$branch_id' AND t_e_l.table_id in ($string)";
				
		}
		else{
			$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
		LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
		LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
		LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
		WHERE t_e_l.status = '$status' AND t_e_l.branch_id='$branch_id'";
		}
		$query = $this->db->query($action_query);
		
		
		
		$final_array = array();

		if($query->num_rows() > 0 ) {
           
			$result = $query->result_array();
			// echo '<pre>'; print_r($result);exit;
			
			foreach ($result as $key => $value) {
				$final_array[] = array(
					'event_id' 				   => (string)$value['event_id'],
					'table_id'				   => (string)$value['table_id'],
					'branch_id'				   => (string)$value['branch_id'],
					'event_name' 			   => (string)$value['event_name'],
					'table_name' 			   => (string)$value['table_name'],
					'status' 				   => (string)$value['status'],
					'employee_action'		   => (string)$value['employee_action'],
					'session_id' 			   => (string)$value['session_id'],
					'requested_on_date_time'   => (string)$value['requested_on_date_time'],
					'responded_on_date_time'   => (string)$value['responded_on_date_time'],
					'responded_by_employee_id' => (string)$value['responded_by_employee_id'],
					'employee_name' 		   => (string)$value['employee_name'],
					'master_call_time'         => (string)$value['master_wait_time'],
					
				);
			}
			return $final_array;
        } else {
            return $final_array;            
        }
    }
	public function current_event_data($event_id, $branch_id){

    	$action_query = "SELECT t_e_l.*, t_b_e.employee_name FROM tbl_event_log as t_e_l 
		LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
		WHERE t_e_l.event_id = '$event_id' AND t_e_l.branch_id = '$branch_id'";
		// echo '<pre>'; print_r($action_query);exit;
		$query = $this->db->query($action_query);
		
		$final_array = array();

		if($query->num_rows() > 0 ) {
           
			$result = $query->result_array();
			
			foreach ($result as $key => $value) {
				$final_array[] = array(
					'event_id' 				   => (string)$value['event_id'],
					'table_id'				   => (string)$value['table_id'],
					'branch_id'				   => (string)$value['branch_id'],
					'event_name' 			   => (string)$value['event_name'],
					'status' 				   => (string)$value['status'],
					'employee_action'		   => (string)$value['employee_action'],
					'session_id' 			   => (string)$value['session_id'],
					'requested_on_date_time'   => (string)$value['requested_on_date_time'],
					'responded_on_date_time'   => (string)$value['responded_on_date_time'],
					'responded_by_employee_id' => (string)$value['responded_by_employee_id'],
					'employee_name' 		   => (string)$value['employee_name'],
					
				);
			}
			return $final_array;
        } else {
            return $final_array;            
        }
    }
	public function event_info($branch_action_id, $table_id){

        $event_query= "SELECT t_br.branch_action_id, t_br.restaurant_id,t_br.branch_id, t_br.action_name, t_b_t.table_id, 
        t_b_t.table_name FROM tbl_branch_action as t_br
        JOIN tbl_branch_table as t_b_t on t_b_t.restaurant_id = t_br.restaurant_id AND  t_b_t.branch_id = t_br.branch_id
        WHERE t_br.branch_action_id = '$branch_action_id' AND t_b_t.table_id = '$table_id' 
        GROUP BY t_b_t.table_id,t_br.branch_action_id";

        $query = $this->db->query($event_query);
        $session_id  = $this->session->session_id;

        $final_array = array();
        

            if($query->num_rows() > 0 ) {
            
                $event_info = $query->row_array();
               
                $data['session_id']=$session_id;
               
                $data = array(
                    'restaurant_id'      => $event_info['restaurant_id'],
                    'branch_id'          => $event_info['branch_id'],
                    'table_id'           => $event_info['table_id'],
                    'event_name'         => $event_info['action_name'],   
                    'session_id'         => $session_id,           
                );
                
                $insert_id  = $this->Common_model->insert_data('tbl_event_log',$data); 
    
                if(!empty($insert_id) && isset($insert_id)) {
    
                    $data['node_event_name']='event_name'; 
                    $data['event_id']=$insert_id;
                    return $data;
    
                } else {
    
                    return $final_array;
                }
    
            } else {
                return $final_array;            
            }
               
    }
	public function event_record($date_from, $date_to, $per_page, $branch_id, $status, $employee_id, $page_no, $start_from, $table_id, $responded_by){

			if(!empty($responded_by)){
				$employee_id=null;
			}
			if(!empty($employee_id)){

				$table_q= "SELECT t_b_e.assign_table, t_b_e.employee_type FROM tbl_branch_employee as t_b_e WHERE t_b_e.employee_id='$employee_id'";
				$table_data= $this->db->query($table_q);
				$table_data_result=$table_data->row_array();
				$string = $table_data_result['assign_table'];
				
				
				
				if($table_data_result['employee_type']==0 && !empty($table_id)){
					// echo '<pre>'; print_r($table_id); exit;
					$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.table_id = '$table_id' AND t_e_l.branch_id='$branch_id' AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
				// echo '<pre>'; print_r($action_query); exit;
				}
				
				elseif($table_data_result['employee_type']==0 ){
					// echo '<pre>'; print_r($table_id); exit;
				$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id =  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.status = '$status' AND t_e_l.branch_id='$branch_id' AND t_e_l.table_id in ($string) AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
					
				
				}
				elseif($table_data_result['employee_type']==1 && !empty($table_id)){
					// echo '<pre>'; print_r($table_id); exit;
					$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.table_id = '$table_id' AND t_e_l.branch_id='$branch_id' AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
				// echo '<pre>'; print_r($action_query); exit;
				}
				else{

				$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.status = '$status' AND t_e_l.branch_id='$branch_id' AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
					
					
				}
					
			}
			elseif(!empty($responded_by) && !empty($table_id)){
				$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.table_id = '$table_id' AND t_e_l.responded_by_employee_id = '$responded_by' AND t_e_l.branch_id='$branch_id' AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
					
			}
			elseif(!empty($responded_by)){
				$action_query = "SELECT t_e_l.*, t_b_e.employee_name, t_b_t.table_name, t_b.master_wait_time  FROM tbl_event_log as t_e_l 
				LEFT JOIN  tbl_branch_employee as t_b_e on t_b_e.employee_id = t_e_l.responded_by_employee_id
				LEFT JOIN tbl_branch_table as t_b_t on t_b_t.table_id=  t_e_l.table_id
				LEFT JOIN tbl_branch as t_b on t_b.branch_id = '$branch_id'
				WHERE t_e_l.responded_by_employee_id = '$responded_by' AND t_e_l.branch_id='$branch_id' AND t_e_l.requested_on_date_time BETWEEN '$date_from' AND '$date_to' ";
					
			}
			

		$query = $this->db->query($action_query);
		$total_row      = $query->num_rows();
		$action_query .= " ORDER BY t_e_l.requested_on_date_time DESC LIMIT $start_from,$per_page ";
		// echo '<pre>'; print_r($action_query);exit;
		$data_query = $this->db->query($action_query);
        $total_page     = ceil($total_row/$per_page);
		
			$final_array = array();
			// $total_no_of_record  = array();
			// $total_no_of_page  = array();
			// $no_of_data_per_page = array();
			
			$total_no_of_record = (string)@$total_row;


			$total_no_of_page    = (string)@$total_page;

			$no_of_data_per_page = (string)@$per_page;


		if($query->num_rows() > 0 ) {
           
			$result = $data_query->result_array();
			
			// echo '<pre>'; print_r($result);exit;
			
			foreach ($result as $key => $value) {
				$final_array[] = array(
					'event_id' 				   => (string)$value['event_id'],
					'table_id'				   => (string)$value['table_id'],
					'branch_id'				   => (string)$value['branch_id'],
					'event_name' 			   => (string)$value['event_name'],
					'table_name' 			   => (string)$value['table_name'],
					'status' 				   => (string)$value['status'],
					'employee_action'		   => (string)$value['employee_action'],
					'session_id' 			   => (string)$value['session_id'],
					'requested_on_date_time'   => (string)$value['requested_on_date_time'],
					'responded_on_date_time'   => (string)$value['responded_on_date_time'],
					'responded_by_employee_id' => (string)$value['responded_by_employee_id'],
					'employee_name' 		   => (string)$value['employee_name'],
					'master_call_time'         => (string)$value['master_wait_time'],									
				);
			}

			// echo '<pre>'; print_r($final_array); exit;

			$new_final_array = array(
				'data' 					=> (array)@$final_array,
				'total_no_of_record' 	=> $total_row,
				'total_no_of_page'		=> $total_page,
				'no_of_data_per_page' 	=> $per_page ,
			);
			// echo '<pre>'; print_r($new_final_array);exit;
			return $new_final_array;
			
        } else {
            return $final_array;            
        }
       
	}
	
}

?>



