<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Menu extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Menu_model');
        $this->load->model('account_admin/action/Action_model');          
    }
    /*
        Author      : Naresh Lakhara
        Date        : 16-06-2022
        Description : Manage Action
    */
    public function menu_display() {

        $data          = array();
        $table_id      = @$this->uri->segment(2) ? base64_decode(@$this->uri->segment(2)) : "0";

        if(!empty($table_id) && isset($table_id)) {

            $field_name = array('restaurant_id','branch_id');
            $where_con  = array('table_id' => $table_id);
            $table_info = $this->Common_model->single_record_fetch($field_name,'tbl_branch_table',$where_con);

            if(!empty($table_info['branch_id']) && isset($table_info['branch_id'])) {                           
            
                $data['branch_id'] = $table_info['branch_id'];
                $data['table_id']  = $table_id;
                $this->load->view("menu_page", $data);
            
            } else {
            
                $this->page_404();
            }

        } else {
            $this->page_404();
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Branch wise preview data 
        Date        : 18-07-2022
    */
    public function branch_wise_preview() {

        $branch_id   = $this->input->post('branch_id');
        $branch_info = $this->Action_model->branch_info($branch_id);

        if(!empty($branch_info) && isset($branch_info)) {
            $array = array('result' => 'success', 'message' => 'Branch info fetch succussfully.', 'data' => $branch_info);
            echo json_encode($array);
            exit;

        } else {

            $this->page_404();            
        }
    }
    /*
        Author      : Pushpesh
        Description : Menu event
        Date        : 07-08-2022
    */
    public function menu_event() {
        
        $branch_action_id       = $this->input->post('event_id'); 
        $event_name             = $this->input->post('event_Name');
        $node_event_name        = $this->input->post('node_event_name');
        $tableId                = $this->input->post('tableId');

        $br_query               = "SELECT t_br.branch_id FROM tbl_branch_action as t_br
                                    WHERE t_br.branch_action_id = '$branch_action_id'";
        
        $branch_query           = $this->db->query($br_query);
        $branch_query_array     = $branch_query->row_array();
        $wait_branch_id         = $branch_query_array['branch_id'];
        $wait_time_q            = "SELECT tbl_branch.master_wait_time FROM tbl_branch WHERE tbl_branch.branch_id = '$wait_branch_id'";
        $branch_wait_query           = $this->db->query($wait_time_q);
        $branch_time_query      = $branch_wait_query->row_array();
       

        $session_id             = $this->session->session_id;       
        $where_con              = array('session_id' => $session_id, 'event_name' => $event_name);
        $field_name             = array('session_id','event_name');
        $destroy_data           = array('session_id' => $session_id, 'event_name' => $event_name, 'session_destroy' => true  );
        $true_false_data        = array('session_id' => $session_id, 'event_name' => $event_name, 'session_destroy' => false , 'master_event' => true );
        $session_id_check       = $this->Common_model->get_selected_data_where_array('tbl_event_log', $where_con, $field_name);
        $session_duration       = SESSION_TIME;
        $master_call_duration   = $branch_time_query['master_wait_time'];
        if( !empty($session_id_check[0]['session_id']) && isset($session_id_check[0]['session_id']) && !empty($session_id_check[0]['event_name']) && isset($session_id_check[0]['event_name'])) {
                
                $current_time                   = date("Y-m-d H:i:s");                
                $first_event_q                  = "SELECT tbl_event_log.requested_on_date_time FROM tbl_event_log
                                                    WHERE tbl_event_log.session_id = '$session_id'
                                                    ORDER BY tbl_event_log.requested_on_date_time ASC LIMIT 1";
                $first_event_query              = $this->db->query($first_event_q);
                $first_event_time               = $first_event_query->row_array();
                
                $last_event_q                   = "SELECT tbl_event_log.status, tbl_event_log.requested_on_date_time FROM tbl_event_log
                                                    WHERE tbl_event_log.session_id = '$session_id' AND
                                                    tbl_event_log.event_name = '$event_name'
                                                    ORDER BY tbl_event_log.requested_on_date_time DESC LIMIT 1";
                $last_event_query               = $this->db->query($last_event_q);
                $last_event_query_array         = $last_event_query->row_array();  
                $last_event_status              = $last_event_query_array['status'];                       
                $last_event_time                = date('Y-m-d H:i:s',strtotime($last_event_query_array['requested_on_date_time']));                
                $last_event_master_time         = date('Y-m-d H:i:s',strtotime($last_event_query_array['requested_on_date_time']) + $master_call_duration);
                $session_timeout                = date('Y-m-d H:i:s',strtotime($first_event_time['requested_on_date_time']) + $session_duration);
                // echo '<pre>'; print_r($session_timeout); exit;
                if(($last_event_status==2) && ($current_time<=$last_event_master_time) && ($current_time<=$session_timeout)) {
                    // echo '<pre>'; print_r($current_time);
                    // echo '<pre>'; print_r($last_event_master_time);
                    // echo '<pre>'; print_r($session_timeout);
                    $event_data        = $this->Action_model->event_info($branch_action_id, $tableId, $event_name);
                    if(!empty($event_data) && isset($event_data)) {
                        $event_call        = $this->Common_model->sendNodeRequest($event_data);
                        $array = array('result' => 'success', 'message' => $event_name.' requested', 'session_destroy' => false);
                        echo json_encode($array);
                        exit;
            
                    }
                
                }
                elseif($current_time<=$last_event_master_time && ($current_time<=$session_timeout)){
                    
                    $array = array('result' => 'failure', 'message' => $event_name.' is already called.', 'session_destroy' => false);
                    echo json_encode($array);
                    exit;
                }
                elseif(($current_time>=$last_event_master_time ) && ($current_time<=$session_timeout) && ($last_event_status==2)) {
                   
                        $event_data        = $this->Action_model->event_info($branch_action_id, $tableId, $event_name);
                        if(!empty($event_data) && isset($event_data)) {
                            $event_call        = $this->Common_model->sendNodeRequest($event_data);
                            $array = array('result' => 'success', 'message' => $event_name.' requested', 'session_destroy' => false);
                            echo json_encode($array);
                            exit;
                
                        }
                }           
                elseif(($current_time>=$last_event_master_time ) && ($current_time<=$session_timeout) && ($last_event_status=1)) {
                   
                    $array = array('result' => 'failure', 'message' => $event_name.' is already called.', 'session_destroy' => false);
                    echo json_encode($array);
                    exit;
                
                }                   
                elseif($current_time>=$session_timeout){
                    $array = array('result' => 'failure', 'message' => 'Session Timed-out', 'data' => $destroy_data );
                    echo json_encode($array);
                    exit;
                }
            }
            else {
            $event_data        = $this->Action_model->event_info($branch_action_id, $tableId, $event_name);
            if(!empty($event_data) && isset($event_data)) {

                $event_call   = $this->Common_model->sendNodeRequest($event_data);
                $data         = array('session_id' => $session_id, 'event_name' => $event_name, 'session_destroy' => false);
                $array = array('result' => 'success', 'message' => $event_name.' requested', 'data' => $data);
                echo json_encode($array);
                exit;
                
            } else {
                
                $array = array('result' => 'failure', 'message' => 'Something went wrong, please try again later.', 'session_destroy' => false);
                echo json_encode($array);
                exit;            
            }
        }
        
        
        
    }
    public function submit_form() {


        $data  = $_POST;
        // unset($_POST['branch_action_id']);
        // unset($_POST['feedback_id']);
        
        // echo '<pre>'; print_r($data);
        $data_array         = $data;
        unset($data_array['branch_action_id']);
        unset($data_array['feedback_id']);

        $branch_action_id   = $data['branch_action_id'];
        $feedback_id        = $data['feedback_id'];
        $branch_query="SELECT tbl_branch.branch_id, tbl_branch.branch_name FROM tbl_branch_action
        LEFT JOIN tbl_branch ON tbl_branch.branch_id=tbl_branch_action.branch_id
        WHERE tbl_branch_action.branch_action_id='$branch_action_id'";
        $query = $this->db->query($branch_query);
        $query_array=$query->row_array();
        $json_data = json_encode($data, true);
        unset($data['branch_action_id']);
        unset($data['feedback_id']);
        
        $feedback_data= array(
            'feedback_form_id'      => $feedback_id,
            'feedback_form_details' => $data,
        );
        $json_feedback_data = json_encode($feedback_data,true);
        
        $session_id  = $this->session->session_id;
        $created_on  = date('Y-m-d');
        $final_array = array(
            'branch_id'        => $query_array['branch_id'],
            'feedback_form_id' => $feedback_id,
            'session_id'       => $session_id,
            'feedback_json'    => $json_feedback_data,
            'created_on'       => $created_on,
        );
        
         foreach($data_array as $key => $value){
            $query                 ="SELECT tbl_feedback_form_details.is_required, tbl_feedback_form_details.title, tbl_feedback_form_details.field_type FROM tbl_feedback_form_details WHERE tbl_feedback_form_details.form_detail_id='$key'";
            $form_query            = $this->db->query($query);
            $form_check            = $form_query->row_array();
            // echo '<pre>'; print_r($form_check);
            if($form_check['is_required']==1 && empty($value)){
                $data = array('result' => 'failure', 'message' => $form_check['title'].' is mandatory.');
                echo json_encode($data);
                exit;
            }
            elseif($form_check['field_type']=='Email' && ($this->checkemail($value)==false)){
                $data = array('result' => 'failure', 'message' => 'Please enter a valid email address.');
                echo json_encode($data);
                exit;
            }
            elseif(($form_check['is_required']==1 && $form_check['field_type']=='Number') && (is_numeric($value)==0)){
                $data = array('result' => 'failure', 'message' => 'Please enter a valid Number.');
                echo json_encode($data);
                exit;
            }
            elseif(($form_check['is_required']==1 && $form_check['field_type']=='Number') && (strlen((string)$value)<10)){
                $data = array('result' => 'failure', 'message' => 'Please enter a 10 digit Number.');
                echo json_encode($data);
                exit;
            }
        }
                                
        $result =$this->Common_model->insert_data('tbl_customer_feedback', $final_array);
        
        if($result) {

            $data = array('result' => 'success', 'message' => 'Feedback added succussfully.');
            echo json_encode($data);
            exit;
        
        } else {

            $data = array('result' => 'failure', 'message' => 'Feedback not added please try again later.');
            echo json_encode($data);
            exit;
        }
        
    }
    // public function master_call() {

    //     $session_duration=30;
    //     $master_call_duration=15;
    //     $session_id  = $this->session->session_id;
    //     $q_event= "SELECT * FROM tbl_event_log WHERE tbl_event_log.session_id='$session_id'";
    //     $e_query = $this->db->query($q_event);
    //     $e_query_array=$e_query->result_array();
    //     // echo '<pre>'; print_r($e_query_array);exit;
        
    //     foreach($e_query_array as $key=>$value){
    //         $event_created_on_time = date('Y-m-d H:i:s',strtotime($value['requested_on_date_time']));
    //         $current_time          = date('Y-m-d H:i:s');
    //         $session_timeout       = date('Y-m-d H:i:s',strtotime($value['requested_on_date_time']) + $session_duration);
    //         $master_time_to_check  = date('Y-m-d H:i:s',strtotime($value['requested_on_date_time']) + $master_call_duration);
    //         $event_id              = $value['event_id'];
    //         $branch_id             = $value['branch_id'];
    //         $table_id              = $value['table_id'];
    //         $event_status          = $value['status'];
    //         $event_name            = $value['event_name'];
    //         $master_status         = $value['event_to_master_emp_status'];
    //         if(!empty($e_query_array) && isset($e_query_array) && ($current_time>=$master_time_to_check) && ($current_time<=$session_timeout) && ($event_status==1) && ($master_status==0)){
                    
    //             $event_master_data=array();
    //             $event_master_data['node_event_name'] = 'event_name'; 
    //             $event_master_data['event_id']        = $event_id;
    //             $event_master_data['event_name']      = $event_name;
    //             $event_master_data['table_id']      = $table_id;
    //             $event_master_data['room_name']       = 'master_branch_'.$branch_id;

    //             if(!empty($event_master_data) && isset($event_master_data)) {  
                    
    //             $event_call           = $this->Common_model->sendNodeRequest($event_master_data);
    //             $updated_data = array( 'event_to_master_emp_status' =>'1');
    //             $where_con    = array('event_id'        => $event_id);
    //             $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);
    //             // echo '<pre>'; print_r($updated_response);exit;
    //             $array = array('result' => 'success', 'message' => 'master employee called succussfully.', 'session_destroy' => false);
    //             echo json_encode($array);
                
            
    //             } else {
            
    //               $array = array('result' => 'failure', 'message' => 'Something went wrong, please try again later.', 'session_destroy' => false);
    //               echo json_encode($array);
    //             exit;            
    //             }
    //         }
        
    //     }

    // }
    public function session_destroy() {
        session_destroy();
       
    }


    /*
        Author      : Naresh Lakhara
        Date        : 17-06-2022
        Description : 404 Page
    */
    public function page_404() {
        $this->load->view("404_page");
    }
    function checkemail($value) {
        return (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $value)) ? FALSE : TRUE;
    }
    

}
