<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct()
    {    
        parent::__construct();
        $this->load->model('account_admin/Login_model','admin',TRUE);
    }

    public function index()
    {
        $this->load->view('account_admin/login');
    }

    /*
        Author      : Naresh Lakhara
        Date        : 30-05-2022
        Description : Login Account Admin 
    */
    public function loginMe()
    {
        $this->load->library('form_validation');        
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|max_length[128]|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');

        if($this->form_validation->run() == FALSE)
        {
            $this->index('account_admin');
        }
        else
        {
            $email    = $this->input->post('email');
            $password = $this->input->post('password');   
            $result   = $this->admin->checkAuth($email, $password);

            if(count($result) > 0)
            {   
                redirect('account_admin/dashboard');
            }
            else
            {
                $this->session->set_flashdata('error', 'Valid credentials required !');               
                redirect('account_admin');
            }
        }
    }

    /**
     * This function used to logged in user
    */
    public function logout()
    {
        $this->admin->logout();
        redirect('account_admin');
    }

    public function branch_logout() {
        $this->admin->branch_logout();
        redirect('account_admin');   
    }
}
