<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Table extends CI_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->load->model('account_admin/table/Table_model');
        $isLoggedIn = $this->session->userdata('isLoggedIn');                
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('account_admin');
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 30-05-2022
        Description : Table Add
    */
    public function add_table()
    {    
        $this->load->library('form_validation');
        $this->form_validation->set_rules('branch_id', 'Branch ID', 'required');
        $this->form_validation->set_rules('table_name', 'First name', 'required');
        // $this->form_validation->set_rules('qr_image', 'QR Code', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /* Edit Record */
            $data              = array();
            $id                = $this->uri->segment(4);
            $data['page_name'] = "Add";

            if($id) {
                $data['edit_data'] = $this->Table_model->edit($id);
                $data['page_name'] = "Update";
            }
            $data['branch_list'] = $this->Table_model->branch_list();
            $this->load->view('account_admin/table/add_table',$data);
        }
        else {

            $branch_id  = trim(@$this->input->post('branch_id'));
            $table_name = trim(@$this->input->post('table_name'));
            $qr_image   = trim(@$this->input->post('qr_image'));
            $status     = trim(@$this->input->post('status'));           

            if(!empty($_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
                $restaurant_id = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : "0";
            } else {
                $restaurant_id = @$_SESSION['branch_restaurant_id'] ? @$_SESSION['branch_restaurant_id'] : "0";
            }   
            
            $qr_code = str_replace(" ", "_", $qr_image);
            $data = array(
                'restaurant_id' => @$restaurant_id,
                'branch_id'     => @$branch_id,
                'table_name'    => @$table_name,
                'qr_image'      => @$qr_code,
                'status'        => @$status,
            );
            
            $table_id = @$this->input->post('table_id');

            if(!empty(@$table_id) && isset($table_id)) {

                $data['modified_on']     = date("Y-m-d H:i:s");
                $data['modified_by']     = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];

                $where_con = array('table_id' => $table_id);
                $result = $this->Common_model->update_by_where_array('tbl_branch_table', $data, $where_con);
                
                if($result) {

                    /* GENERATE QR CODE */
                    qr_code_generate($filename = $qr_code, $errorCorrectionLevel = 'L', $matrixPointSize = '10' , $table_id);
                    /* END QR CODE */

                    $data = array('result' => 'success', 'message' => 'Table updated succussfully.');
                    echo json_encode($data);
                    exit;
                
                } else {

                    $data = array('result' => 'failure', 'message' => 'Table not updated please try again later.');
                    echo json_encode($data);
                    exit;                
                }

            } else {

                $data['created_on']      = date("Y-m-d H:i:s");
                $data['created_by']      = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];
                $data['created_by_type'] = @$_SESSION['restaurant_id'] ? "0" : "1"; 

                $result   = $this->Common_model->insert_data('tbl_branch_table',$data);
                
                if($result) {

                    /* GENERATE QR CODE */
                    qr_code_generate($filename = $qr_code, $errorCorrectionLevel = 'L', $matrixPointSize = '10' , $result);
                    /* END QR CODE */
                    
                    $data = array('result' => 'success', 'message' => 'Table added succussfully.');
                    echo json_encode($data);
                    exit;
                
                } else {

                    $data = array('result' => 'failure', 'message' => 'Table not added please try again later.');
                    echo json_encode($data);
                    exit;                        
                }
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 30-05-2022
        Description : Manage Table
    */
    public function manage_table() {
        $data = array();
        $data['branch_list'] = $this->Table_model->branch_list();        
        $this->load->view("account_admin/table/manage_table", $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage Table Ajax
        Date        : 30-05-2022
    */
    public function manage_table_ajax() {

        $list = $this->Table_model->manage_table_ajax();
        echo json_encode($list = array());
        exit;
    } 
}
