<?php
ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct()
    {    
        parent::__construct();
        $this->load->model('admin/Login_model','admin',TRUE);
    }

    public function index()
    {
        $this->load->view('admin/login');
    }
    /*
       Author : Naresh Lakhara
       Date   : 15-04-2022
       Description : Login Admin
    */
    public function loginMe()
    {
        $this->load->library('form_validation');        
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|max_length[128]|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');

        if($this->form_validation->run() == FALSE)
        {
            $this->index('admin');
        }
        else
        {
            $email    = $this->input->post('email');
            $password = $this->input->post('password');   
            $result   = $this->admin->checkAuth($email, $password);

            if(count($result) > 0)
            {   
                redirect('admin/dashboard');
            }
            else
            {
                $this->session->set_flashdata('error', 'Valid credentials required !');               
                redirect('admin');
            }
        }
    }

    /**
     * This function used to logged in user
    */
    public function logout()
    {
        $this->admin->logout();
        redirect('admin');
    } 
}
