<?php
class Action_model extends CI_Model
{

    /*
        Author     : Naresh Lakhara
        Date       : 06-06-2022
        Description: Branch List
    */
    public function branch_list() {

        $br_q = "SELECT branch_id, branch_name FROM tbl_branch WHERE status = '1' AND is_delete = '0'";

        if(!empty($_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
            
            $br_q .= " AND restaurant_id = '".@$_SESSION['restaurant_id']."' ";

        }  else {

            $br_q .= " AND branch_id = '".@$_SESSION['branch_id']."' ";            
        }

        $query  = $this->db->query($br_q);
       
        $result = $query->result_array();

        $final_array = array();

        if($result) {
                
            foreach ($result as $key => $value) {
                
                $final_array[] = array(
                    'branch_id'   => $value['branch_id'],
                    'branch_name' => ucfirst($value['branch_name']),
                );        
            }
            return $result;        

        } else {
        
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 06-06-2022
        Description: Action List
    */
    public function action_list() {

        $br_q = "SELECT action_id, action_type FROM tbl_action WHERE status = '1' AND is_delete = '0' ORDER BY sequence ASC";

        $query  = $this->db->query($br_q);
       
        $result = $query->result_array();

        $final_array = array();

        if($result) {
            
            foreach ($result as $key => $value) {
                
                $final_array[] = array(
                    'action_id'   => $value['action_id'],
                    'action_type' => ucfirst($value['action_type']),
                );        
            }
            return $result;        

        } else {
        
            return array();
        }
        
    }

	/*
        Author     : Naresh Lakhara
        Date       : 06-06-2022
        Description: Edit Data
    */
    public function edit($id) {
        $qr = "SELECT * FROM tbl_branch_action WHERE branch_action_id = '$id'";
        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 01-06-2022
        Description: Record Display
    */
    public function manage_action_ajax() {

        $in = $_POST ? $_POST : array();        
        
        $q = "SELECT tb_br.branch_action_id,tb_br.action_id, tb_br.action_name, t_ac.action_type, t_res.restaurant_name,  t_br.branch_name, tb_br.status FROM tbl_branch_action as tb_br 
        JOIN tbl_restaurant as t_res on t_res.restaurant_id = tb_br.restaurant_id
        JOIN tbl_branch as t_br on t_br.branch_id = tb_br.branch_id
        JOIN tbl_action as t_ac on t_ac.action_id = tb_br.action_id
        WHERE tb_br.is_delete = '0' AND 1 = 1 ";

        if(!empty(@$_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
            $q .= " AND tb_br.restaurant_id = '".@$_SESSION['restaurant_id']."' ";
        } else {
            $q .= " AND tb_br.branch_id = '".@$_SESSION['branch_id']."' ";
        }

        /* FITLER BRANCH WISE  */
        if(@$in['search_data']['branch_id']) {
            $q .= " AND t_br.branch_id = '".$in['search_data']['branch_id']."' ";            
        }

        /* FITLER ACTION WISE  */        
        if(@$in['search_data']['action_id']) {            
            $q .= " AND tb_br.action_id = '".$in['search_data']['action_id']."' ";            
        }

        if (@$in['search']['value']) {
           $q .= ' AND (tb_br.branch_action_id LIKE "%' . trim(@$in['search']['value']) . '%" OR
                t_res.restaurant_name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                t_ac.action_type LIKE "%' . trim(@$in['search']['value']) . '%" OR
                tb_br.action_name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                t_br.branch_name LIKE "%' . trim(@$in['search']['value']) . '%")';
        }

        $q .= " ORDER BY {$in['order'][0]['column']} {$in['order'][0]['dir']} ";

        $query = $this->db->query($q);
        $total = $query->num_rows();

        $qury  = $q . " LIMIT {$in['start']}, {$in['length']}";
        $exe_q = $this->db->query($qury);
        $data   = $exe_q->result_array();

        $final_array = array();

        foreach ($data as $key => $data_value) {
                
            $final_array[] = array(
                "branch_action_id" =>  @$data_value['branch_action_id'],
                "restaurant_name"  =>  @$data_value['restaurant_name'] ? @$data_value['restaurant_name'] : "-",
                "branch_name"      =>  @$data_value['branch_name'] ? @$data_value['branch_name'] : "-",
                "action_type"      =>  @$data_value['action_type'] ? @$data_value['action_type'] : "-",
                "action_name"      =>  @$data_value['action_name'] ? @$data_value['action_name'] : "-",
                "status"           =>  @$data_value['status'],
                "action_id"        =>  @$data_value['action_id'],
                "manage_page"      =>  base_url('account_admin/action/feedback/').base64_encode($data_value['branch_action_id']),
            );
        }

        echo json_encode(array(
           "data"            => $final_array,
           "recordsTotal"    => $total ? $total : 0,
           "recordsFiltered" => $total ? $total : 0,
       ));
       exit;
    }   

     /*
        Author     : Naresh Lakhara
        Date       : 06-06-2022
        Description: Get all images
    */
    public function images_fetch($restaurant_id, $branch_id, $action_id, $branch_action_id) {

        $br_q = "SELECT image_id, images FROM tbl_branch_action_image 
        WHERE restaurant_id = '$restaurant_id'  AND branch_id = '$branch_id' AND action_id = '$action_id' and branch_action_id = '$branch_action_id' ";
        
        $query  = $this->db->query($br_q);
       
        $result = $query->result_array();

        $final_array = array();

        if($result) {
                
            foreach ($result as $key => $value) {
                
                $final_array[] = array(
                    'image_id'   => $value['image_id'],
                    'images' => ucfirst($value['images']),
                );        
            }
            return $result;        

        } else {
        
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 14-06-2022
        Description: Edit Form Details
    */
    public function edit_form_details($branch_action_id) {

        $br_q = "SELECT feedback_id, feedback_form_name, status FROM tbl_feedback 
        WHERE branch_action_id = '$branch_action_id'";
        $query  = $this->db->query($br_q);       
        $result = $query->row_array();

        $br_q2 = "SELECT form_detail_id, title, placeholder,master_field_type,field_type,is_required,sequence,
        options_json FROM tbl_feedback_form_details 
        WHERE feedback_id = '".@$result['feedback_id']."' AND is_delete='0'";
        $query2  = $this->db->query($br_q2);       
        $result2 = $query2->result_array();

        $form_fields = array();

        if($result2) {
                
            foreach ($result2 as $key => $value) {
                
                $form_fields[] = array(
                    'form_detail_id'    => (string)@$value['form_detail_id'],
                    'title'             => (string)@$value['title'],
                    'placeholder'       => (string)@$value['placeholder'],
                    'master_field_type' => (string)@$value['master_field_type'],
                    'field_type'        => (string)@$value['field_type'],
                    'sequence'          => (string)@$value['sequence'],
                    'is_required'       => (string)@$value['is_required'] ? true : false,
                    'options_json'      => (string)@$value['options_json'],
                );        
            }

            $final_array = array(
                'feedback_form' => array(
                    'feedback_id'        => (string)@$result['feedback_id'],
                    'feedback_form_name' => (string)@$result['feedback_form_name'],
                    'status'             => (string)@$result['status'],
                ),
                'feedback_form_details' => $form_fields,
            );
            
            return json_encode($final_array);        

        } else {
        
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 18-07-2022
        Description: Branch info fetch  
        Note : Master field type : 1=TextBox, 2=TextArea, 3=DropDown, 4=Radio Button, 5=Rating, 6=Date, 7=Email, 8=Number  
    */
    public function branch_info($branch_id) {

        /* BRANCH INFO */
        $query = "SELECT branch_id,branch_name,display_name,branch_image  
        FROM `tbl_branch` 
        WHERE branch_id = '$branch_id' AND status = '1' AND is_delete = '0'";
        $query_exe     = $this->db->query($query);
        $branch_info = $query_exe->row_array();

        /* DEFAULT ACTION  */        
        $query1 = "SELECT t_b_a.branch_action_id,t_b_a.branch_id,t_b_a.action_id,t_b_a.action_name,t_b_a.action_png, t_b_a.is_default,t_b_a.sequence ,t_b_i.images
        FROM tbl_branch_action as t_b_a 
        LEFT JOIN tbl_branch_action_image as t_b_i on t_b_i.branch_action_id = t_b_a.branch_action_id
        WHERE t_b_a.branch_id = '$branch_id' AND t_b_a.status = '1' AND t_b_a.is_default = '1' AND t_b_a.is_delete = '0' AND t_b_a.action_id IN(1,5) ORDER BY t_b_a.sequence ASC;";
        $query1_exe     = $this->db->query($query1);
        $default_action = $query1_exe->result_array();
            
        /* SOCIAL MENU */        
        $query2 = "SELECT branch_action_id,branch_id,action_id,action_name,action_png, is_default,sequence  
        FROM `tbl_branch_action` 
        WHERE branch_id = '$branch_id' AND status = '1' AND is_delete = '0' AND action_id IN(6) ORDER BY sequence ASC";
        $query2_exe     = $this->db->query($query2);
        $social_menu    = $query2_exe->result_array();

        /* Feedback Form */
        $contact_form = array();
        $query6 = "SELECT tbl_branch_action.branch_action_id, tbl_branch_action.action_name, tbl_branch_action.action_id, tbl_feedback.feedback_id FROM tbl_branch_action 
                    LEFT JOIN tbl_feedback ON tbl_feedback.branch_action_id =  tbl_branch_action.branch_action_id
                    WHERE branch_id = '$branch_id' AND tbl_feedback.status = '1' 
                    AND tbl_branch_action.status = '1' AND tbl_branch_action.is_delete = '0' 
                    AND tbl_feedback.is_delete = '0' AND action_id IN(3) ORDER BY tbl_branch_action.branch_action_id DESC LIMIT 1";
        $query6_exe     = $this->db->query($query6);
        $feedback_data  = $query6_exe->row_array();        
        $feedback_id    = @$feedback_data['feedback_id'] ? @$feedback_data['feedback_id'] : "0";
        $query7 = "SELECT t_feed_d.form_detail_id,t_feed_d.feedback_id,
                t_feed_d.title,t_feed_d.placeholder,t_feed_d.master_field_type, 
                t_feed_d.is_required,t_feed_d.options_json FROM tbl_feedback_form_details as t_feed_d 
                WHERE t_feed_d.status = '1' AND t_feed_d.is_delete = '0' AND feedback_id 
                IN ($feedback_id) ORDER BY t_feed_d.sequence ASC ";
        $query7_exe     = $this->db->query($query7);
        $contact_form_data    = $query7_exe->result_array();

        foreach ($contact_form_data as $key => $value) {

            $contact_form[] = array(
                'branch_action_id'  => $feedback_data['branch_action_id'],
                'action_id'         => $feedback_data['action_id'], 
                'action_name'       => $feedback_data['action_name'],                                
                'form_detail_id'    => $value['form_detail_id'],
                'feedback_id'       => $value['feedback_id'],
                'title'             => $value['title'],
                'placeholder'       => $value['placeholder'],
                'master_field_type' => $value['master_field_type'],
                'is_required'       => $value['is_required'],
                'options_json'      => $value['options_json'],
            );            
        }

        /* Gallery Images  */        
        $query4 = "SELECT branch_action_id,branch_id,action_id,action_name,action_png, is_default,sequence  
        FROM `tbl_branch_action` 
        WHERE branch_id = '$branch_id' AND status = '1' AND is_delete = '0' AND action_id IN(2) ORDER BY sequence ASC";
        $query4_exe     = $this->db->query($query4);
        $branch_gallery = $query4_exe->result_array();

        $branch_gallery_final = array();

        foreach ($branch_gallery as $key => $value) {
            
            $query5 = "SELECT image_id, branch_action_id,branch_id,action_id, images  
            FROM `tbl_branch_action_image` 
            WHERE branch_id = '$branch_id' AND branch_action_id = ".$value['branch_action_id']." AND status = '1' AND is_delete = '0' AND action_id IN(2) ORDER BY image_id ASC";
            $query5_exe     = $this->db->query($query5);
            $get_data = $query5_exe->result_array();

            $branch_gallery_final[] = array(
                'branch_action'         => (array)$value,
                'branch_action_details' => (array)$get_data,
            );
        }

        /* ACTION ACTION LIST */
        $query8 = "SELECT branch_action_id, branch_id, action_id, action_name  FROM `tbl_branch_action` WHERE branch_id = '$branch_id' AND status = '1' AND is_delete = '0'";
        $query8_exe     = $this->db->query($query8);
        $active_action  = $query8_exe->result_array();

        $final_array = array(
            'branch_info'    => (array)@$branch_info,
            'default_action' => (array)@$default_action,
            'social_menu'    => (array)@$social_menu,
            'contact_form'   => (array)@$contact_form,
            'branch_gallery' => (array)@$branch_gallery_final,
            'active_action'  => (array)@$active_action,
        );

        return $final_array;
    }

    /*
        Author      : pushpesh kumar
        Date        : 18-07-2022
        Description : Add Data in Event Log Table 
    */
    public function event_info($branch_action_id, $table_id, $event_name){

        $br_query               = "SELECT t_br.branch_id FROM tbl_branch_action as t_br
                                    WHERE t_br.branch_action_id = '$branch_action_id'";
        
        $branch_query           = $this->db->query($br_query);
        $branch_query_array     = $branch_query->row_array();
        $wait_branch_id         = $branch_query_array['branch_id'];
        $wait_time_q            = "SELECT tbl_branch.master_wait_time FROM tbl_branch WHERE tbl_branch.branch_id = '$wait_branch_id'";
        $branch_wait_query      = $this->db->query($wait_time_q);
        $branch_time_query      = $branch_wait_query->row_array();
        $event_query= "SELECT t_br.branch_action_id, t_br.restaurant_id,t_br.branch_id, t_br.action_name, t_b_t.table_id, 
        t_b_t.table_name FROM tbl_branch_action as t_br
        JOIN tbl_branch_table as t_b_t on t_b_t.restaurant_id = t_br.restaurant_id AND  t_b_t.branch_id = t_br.branch_id
        WHERE t_br.branch_action_id = '$branch_action_id' AND t_b_t.table_id = '$table_id' 
        GROUP BY t_b_t.table_id,t_br.branch_action_id";

        $query             = $this->db->query($event_query);
        $query_array       = $query->row_array();
        $session_id        = $this->session->session_id;
        $current_time      = date("Y-m-d H:i:s"); 
        $master_call_time  = $branch_time_query['master_wait_time'];

        $final_array = array();
        

            if($query->num_rows() > 0 ) {
            
                $event_info = $query->row_array();
               
                // $data['session_id']=$session_id;
                
               
                $data = array(
                    'restaurant_id'          => $event_info['restaurant_id'],
                    'branch_id'              => $event_info['branch_id'],
                    'table_id'               => $event_info['table_id'],
                    'event_name'             => $event_info['action_name'],   
                    'session_id'             => $session_id,                    
                    'requested_on_date_time' => $current_time,           
                );
                
                $insert_id  = $this->Common_model->insert_data('tbl_event_log',$data); 
    
                if(!empty($insert_id) && isset($insert_id)) {
    
                    $data['node_event_name']  = 'event_name'; 
                    $data['event_id']         = $insert_id;
                    $data['event_priority']   = 'normal';
                    $data['table_name']       = $query_array['table_name'];
                    $data['master_call_time'] = $master_call_time;
                    $data['room_name']        = 'branch_'.$query_array['branch_id'];
                    return $data;
    
                } else {
    
                    return $final_array;
                }
    
            } else {
                return $final_array;            
            }
               
    }
}
