<?php
class Table_model extends CI_Model
{

    /*
        Author     : Naresh Lakhara
        Date       : 30-05-2022
        Description: Branch List
    */
    public function branch_list() {

        $br_q = "SELECT branch_id, branch_name FROM tbl_branch WHERE status = '1' AND is_delete = '0'";

        if(!empty($_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
            
            $br_q .= " AND restaurant_id = '".@$_SESSION['restaurant_id']."' ";

        }  else {

            $br_q .= " AND branch_id = '".@$_SESSION['branch_id']."' ";            
        }

        $query  = $this->db->query($br_q);
       
        $result = $query->result_array();

        $final_array = array();

        if($result) {
                
            foreach ($result as $key => $value) {
                
                $final_array[] = array(
                    'branch_id'   => $value['branch_id'],
                    'branch_name' => ucfirst($value['branch_name']),
                );        
            }
            return $result;        

        } else {
        
          return array();
        }
    }

	/*
        Author     : Naresh Lakhara
        Date       : 30-05-2022
        Description: Edit Data
    */
    public function edit($id) {
        $qr = "SELECT * FROM tbl_branch_table WHERE table_id = '$id'";
        $query  = $this->db->query($qr);
        $result = $query->row_array();
        if($result) {
            return $result;
        } else {
          return array();
        }
    }

    /*
        Author     : Naresh Lakhara
        Date       : 30-05-2022
        Description: Record Display
    */
    public function manage_table_ajax() {

        $in = $_POST ? $_POST : array();        
        
        $q = "SELECT tb_br.table_id,t_res.restaurant_name,  t_br.branch_name, tb_br.table_name, tb_br.qr_image,tb_br.status FROM tbl_branch_table as tb_br 
        JOIN tbl_restaurant as t_res on t_res.restaurant_id = tb_br.restaurant_id
        JOIN tbl_branch as t_br on t_br.branch_id = tb_br.branch_id
        WHERE tb_br.is_delete = '0' AND 1 = 1 ";

        if(!empty(@$_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
            $q .= " AND tb_br.restaurant_id = '".@$_SESSION['restaurant_id']."' ";
        } else {
            $q .= " AND tb_br.branch_id = '".@$_SESSION['branch_id']."' ";
        }
        if(@$in['search_data']['branch_id']) {
            $q .= " AND t_br.branch_id = '".$in['search_data']['branch_id']."' ";            
        }
        
        if (@$in['search']['value']) {
           $q .= ' AND (tb_br.table_id LIKE "%' . trim(@$in['search']['value']) . '%" OR
                t_res.restaurant_name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                tb_br.table_name LIKE "%' . trim(@$in['search']['value']) . '%" OR
                t_br.branch_name LIKE "%' . trim(@$in['search']['value']) . '%")';
        }

        $q .= " ORDER BY {$in['order'][0]['column']} {$in['order'][0]['dir']} ";

        $query = $this->db->query($q);
        $total = $query->num_rows();

        $qury  = $q . " LIMIT {$in['start']}, {$in['length']}";
        $exe_q = $this->db->query($qury);
        $data   = $exe_q->result_array();

        $final_array = array();

        foreach ($data as $key => $data_value) {
            
            $qr_code_url  = "";
            $qr_code_path = getcwd().'/uploads/qr_code/'.@$data_value['table_id'].'_qr_code.png';

            if(file_exists($qr_code_path)) {
                $qr_code_url = base_url('/uploads/qr_code/').@$data_value['table_id'].'_qr_code.png';
            }

            $final_array[] = array(
                "table_id"        =>  @$data_value['table_id'],
                "restaurant_name" =>  @$data_value['restaurant_name'] ? @$data_value['restaurant_name'] : "-",
                "branch_name"     =>  @$data_value['branch_name'] ? @$data_value['branch_name'] : "-",
                "table_name"      =>  @$data_value['table_name'] ? @$data_value['table_name'] : "-",
                "qr_image"        =>  @$qr_code_url ? @$qr_code_url : "-",             
                "status"          =>  @$data_value['status'],
            );
        }

        echo json_encode(array(
           "data"            => $final_array,
           "recordsTotal"    => $total ? $total : 0,
           "recordsFiltered" => $total ? $total : 0,
       ));
       exit;
    }   
}
