<?php
$this->load->view('account_admin/header');
?>
<?php
$this->load->view('account_admin/sidebar');
?>
<style type="text/css">
    .ChangeColor{
        color: green;
    }
    .ChangeColor:hover{
        color: black;
    }
    .ChangeColor:focus{
        color: black;
    }
    .ChangeColor:active{
        color: black;
    }    
</style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Manage Action</h1>
            <ol class="breadcrumb">
              <li><a href="javascript:void(0);"><i class="fa fa-dashboard"></i>Action Management</a></li>
              <li class="active">Manage Action</li>
            </ol>
        </section>        
        <section class="content">
            <div class="row">
            <div class="col-xs-12">
              <div class="box">
                <div class="box-body">

                    <div class="row">                            
                        <div class="col-xl-3 col-lg-3">
                            <select class="form-control" name="branch_id" id="branch_id" onchange="dataFilter();">
                                <option value="">Select Branch</option>
                                <?php 
                                foreach ($branch_list as $key => $value) {
                                    ?>
                                        <option value="<?php echo @$value['branch_id']; ?>"><?php echo @$value['branch_name']; ?></option>
                                    <?php 
                                }
                                ?>
                            </select>
                        </div>

                        <div class="col-xl-3 col-lg-3">
                            <select class="form-control" name="action_id" id="action_id" onchange="dataFilter();">
                                <option value="">Select Action Type</option>
                                <?php 
                                foreach ($action_list as $key => $value) {

                                    if(@$edit_data['action_id'] == @$value['action_id']) {
                                        ?>
                                            <option selected value="<?php echo @$value['action_id']; ?>"><?php echo @$value['action_type']; ?></option>
                                        <?php 
                                    } else {
                                        ?>
                                            <option value="<?php echo @$value['action_id']; ?>"><?php echo @$value['action_type']; ?></option>
                                        <?php 
                                    }

                                    ?>
                                    <?php 
                                }
                                ?>
                            </select>
                        </div>                        
                    </div>
                    <hr>

                    <table id="dataTable" class="table table-bordered" width="100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Restaurant Name</th>
                                <th>Branch Name</th>
                                <th>Action Type</th>
                                <th>Action Name</th>
                                <th>Status</th>
                                <th>Action</th>
								<th>Manage Page</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
              </div>
            </div>
          </div>
        </section>
    </div>    
<?php
$this->load->view('account_admin/footer');
?>

<script type="text/javascript">

var table_ajax;
table_ajax = jQuery('#dataTable').dataTable({
    "processing": true,
    "searching": true,
    "serverSide": true,
    // "scrollX": true,
    "oLanguage": {
        "sEmptyTable": "No data found",
    },
    "ajax":{
        url: "<?php echo base_url('account_admin/action/action/manage_action_ajax'); ?>",
        type: "post",
        data: function(d) {
            d.search_data = returnData();
            var order_by  = d.order[0]['dir'];
            var order_for = d.order[0]['column'];
        },
        dataFilter: function(response){
            var data = JSON.parse(response);
            var length = data.recordsTotal;                
            return response;
        },
        complete : function() {
            // jQuery('.page-loader-wrapper').hide();
        },
        error: function(){  
            // jQuery('.page-loader-wrapper').hide();
        }
    },
    "order": [[0, "desc"]],
    "columns": [  
        {"data": "branch_action_id" ,orderable: true, name: "branch_action_id" },              
        {"data": "restaurant_name" ,orderable: false, name: "restaurant_name" },              
        {"data": "branch_name" ,orderable: false, name: "branch_name" },          
        {"data": "action_type" ,orderable: false, name: "action_type" },          
        {

            "data": "action_name" ,
            "orderable": true, 
            "name": "action_name",
            render: function(data, type, row, meta) {                
                var link = "<span><a class='ChangeColor' href='add/"+row['branch_action_id']+"'>"+row['action_name']+"<a><span>";
                return link;
            }
        },          
        {
            data: 'status',
            orderable: false,
            name:'status',
            render: function(data, type, row, meta) {   

                if(row['status'] == '1') {
                    var status = "<span style='color:green'>Active</span>";
                } else {
                    var status = "<span style='color:red'>Suspend</span>";
                }
                return status;
            }
        },
        {
            data: 'action',
            orderable: false,
            render: function(data, type, row, meta) {                
                var link = "<a href='add/"+row['branch_action_id']+"'><img width='25px' height='25px' src='<?php echo base_url('/assets/img/edit.png'); ?>'></img><a>";
                return link;
            }
        },
        {
            data: 'manage_page',
            orderable: false,
            render: function(data, type, row, meta) {
                if(row['action_id'] == '3') {
                    var managePage = "<a href='"+row['manage_page']+"'><button class='btn btn-primary'>Manage Page</button><a>";
                } else {
                    var managePage = "";
                }
                return managePage;
            }
        }
    ],
    fnServerParams: function (data) {
        data["order"].forEach(function (items, index) {
            data["order"][index]["column"] = data["columns"][items.column]["name"];
        });
    },
});

function returnData()
{
    var searchAry            = {};
    searchAry['branch_id']   = $("#branch_id").val();
    searchAry['action_id']   = $("#action_id").val();
    return searchAry;
}

function dataFilter() {
    table_ajax.api().ajax.reload();
}
</script>
