<?php
$this->load->view('account_admin/header');
?>
<?php
$this->load->view('account_admin/sidebar');
?>
<style type="text/css">
    .ChangeColor{
        color: green;
    }
    .ChangeColor:hover{
        color: black;
    }
    .ChangeColor:focus{
        color: black;
    }
    .ChangeColor:active{
        color: black;
    }
</style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Manage Table</h1>
            <ol class="breadcrumb">
              <li><a href="javascript:void(0);"><i class="fa fa-dashboard"></i>Table Management</a></li>
              <li class="active">Manage Table</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
            <div class="col-xs-12">
              <div class="box">
                <div class="box-body">
                <div class="row">                            
                        <div class="col-xl-3 col-lg-3">
                            <select class="form-control" name="branch_id" id="branch_id" onchange="dataFilter();">
                                <option value="">Select Branch</option>
                                <?php 
                                foreach ($branch_list as $key => $value) {
                                    ?>
                                        <option value="<?php echo @$value['branch_id']; ?>"><?php echo @$value['branch_name']; ?></option>
                                    <?php 
                                }
                                ?>
                            </select>
                        </div> 
                    </div>
                    <hr>                    
                  <table id="dataTable" class="table table-bordered" width="100%">
                        <thead>
                            <tr>
                                <!-- <th>ID</th> -->
                                <!-- <th>Restaurant Name</th> -->
                                <th>Branch Name</th>
                                <th>Table Name</th>
                                <th>QR Code</th>                                
                                <th>Status</th>
								<th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                  </table>
                 
                </div>
              </div>
            </div>
          </div>
        </section>
         <!-- Modal -->
                                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                      <div class="modal-content">
                                        
                                        <div class="modal-body text-center">
                                          <img src="" id="qr_code_append">
                                        </div>
                                        <div class="modal-footer">
                                          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                      </div>
                                    </div>
                                </div>
    </div>    
<?php
$this->load->view('account_admin/footer');
?>

<script type="text/javascript">

var table_ajax;
table_ajax = jQuery('#dataTable').dataTable({
    "processing": true,
    "searching": true,
    "serverSide": true,
    // "scrollX": true,
    "oLanguage": {
        "sEmptyTable": "No data found",
    },
    "ajax":{
        url: "<?php echo base_url('account_admin/table/table/manage_table_ajax'); ?>",
        type: "post",
        data: function(d) {
            d.search_data = returnData();
            var order_by  = d.order[0]['dir'];
            var order_for = d.order[0]['column'];
        },
        dataFilter: function(response){
            var data = JSON.parse(response);
            var length = data.recordsTotal;                
            return response;
        },
        complete : function() {
            // jQuery('.page-loader-wrapper').hide();
        },
        error: function(){  
            // jQuery('.page-loader-wrapper').hide();
        }
    },
    "order": [[0, "desc"]],
    "columns": [  
        // {"data": "table_id" ,orderable: true, name: "tb_br.table_id" },              
        // {"data": "restaurant_name" ,orderable: true, name: "t_res.restaurant_name" },                     
        {"data": "branch_name" ,orderable: true, name: "t_br.branch_name" },          
        {

            "data": "tb_br.table_name" ,
            "orderable": true, 
            "name": "tb_br.table_name",
            render: function(data, type, row, meta) {                
                var link = "<span><a class='ChangeColor' href='add/"+row['table_id']+"'>"+row['table_name']+"<a><span>";
                return link;
            }
        }, 
        {
            "data": "qr_image",
            orderable: false, 
            name: "qr_image",
            render: function(data, type, row, meta) {   
               

                if(row['qr_image'] != '-') {
                    var status = "<img id='qr"+row['table_id']+"' width='50px' height='50px'  data-toggle='modal' data-target='#exampleModal' onclick='modal_called("+row['table_id']+")' src='"+row['qr_image']+"'></img>";
                } else {
                    var status = "<span style='color:red'>N/A</span>";
                }
                return status;
            } 
        },
        {
            data: 'status',
            orderable: false,
            name:'status',
            render: function(data, type, row, meta) {   

                if(row['status'] == '1') {
                    var status = "<span style='color:green'>Active</span>";
                } else {
                    var status = "<span style='color:red'>Suspend</span>";
                }
                return status;
            }
        },
        {
            data: 'action',
            orderable: false,
            render: function(data, type, row, meta) {                
                var link = "<a href='add/"+row['table_id']+"'><img width='25px' height='25px' src='<?php echo base_url('/assets/img/edit.png'); ?>'></img><a>";
                return link;
            }
        }
    ],
    fnServerParams: function (data) {
        data["order"].forEach(function (items, index) {
            data["order"][index]["column"] = data["columns"][items.column]["name"];
        });
    },
});

function returnData()
{
    var searchAry            = {};
    searchAry['branch_id']   = $("#branch_id").val();
    return searchAry;
}
function dataFilter() {
    table_ajax.api().ajax.reload();
}
function modal_called(qr_id) {

    var image_url = $('#qr'+qr_id+'').attr('src');
    $("#qr_code_append").attr("src",image_url);
}
</script>
