<?php defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH.'libraries/REST_Controller.php';
/*
    Author      : Naresh Lakhara
    Description : Rest API Controller setup
    Date        : 15-06-2022 
*/
class Api extends REST_Controller {

    public function __construct()
    {        
        parent::__construct();
        $this->load->model('Api_model','apimodel', True);        
    }

    /*
       Author       : Pushpesh
       Date         : 08-08-2022
       Description  : Login 
    */

    public function login_post() {
    
       $email_address = $this->input->post("email");   
       $password      = $this->input->post("password") ? md5(trim($this->input->post("password"))) : ""; 
        

        if(!empty($email_address) && isset($email_address) && !empty($password)) {
                
            $event_data      = $this->apimodel->employee_login($email_address, $password);
            // echo '<pre>';
            // print_r($event_data);
            // exit;
            
            if(!empty($event_data) && isset($event_data)) {
                $logged_In        = $this->Common_model->sendNodeRequest($event_data);
                $data = array('status'  => 'true', 'message' => 'User  Data found successfully.', 'data' => $event_data);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Employee  not found.');
                response($data);
            }                

        }elseif (empty($password)) {
            $data = array('status'  => 'false', 'message' => 'Password field should not be blank');
            response($data);
        }elseif(empty($email_address)) {

            $data = array('status'  => 'false', 'message' => 'Email field should not be blank');
            response($data);
        }
    }
    public function event_post(){

        $branch_action_id =$this->input->post("action_id");
        $table_id =$this->input->post("table_id");

        if(!empty($branch_action_id) && isset($branch_action_id)) {
                
            $branch_action_event = $this->apimodel->event_info($branch_action_id,$table_id);

            if(!empty($branch_action_event) && isset($branch_action_event)) {

                $event_call        = $this->Common_model->sendNodeRequest($branch_action_event);
                $data = array('status'  => 'true', 'message' => 'Event  Data found successfully.', 'data' => $branch_action_event);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
    }
    public function sync_event_get(){

        $status      = $this->input->get("status");
        $branch_id   = $this->input->get("branch_id");
        $employee_id = $this->input->get("employee_id");

        if(!empty($status) && isset($status) && !empty($branch_id) && isset($branch_id) && !empty($employee_id) && isset($employee_id)) {
                
            $sync_action_event = $this->apimodel->sync_action_event($status, $branch_id,$employee_id);

            if(!empty($sync_action_event) && isset($sync_action_event)) {

                $data = array('status'  => 'true', 'message' => 'Event  Data found successfully.', 'data' => $sync_action_event);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
    }
    public function current_event_get(){

        $event_id    = $this->input->get("event_id");
        $branch_id   = $this->input->get("branch_id");
        $employee_id = $this->input->get("employee_id");
        

        if(!empty($event_id) && isset($event_id) && !empty($branch_id) && isset($branch_id) && !empty($employee_id) && isset($employee_id)) {
                
            $sync_current_event = $this->apimodel->current_event_data($event_id, $branch_id, $employee_id);
            // echo '<pre>'; print_r($sync_current_event);exit;

            if(!empty($sync_current_event) && isset($sync_current_event)) {

                $data = array('status'  => 'true', 'message' => 'Event  Data found successfully.', 'data' => $sync_current_event);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
    }
    public function accept_event_post(){

        $event_id       = $this->input->post("event_id");
        $accept_action  = $this->input->post("accept_action");
        $employee_id    = $this->post("employee_id");

        if(!empty($event_id) && isset($event_id) && !empty($employee_id) && isset($employee_id) && !empty($accept_action) ) {
            
            $updated_data = array('employee_action' => $accept_action,'responded_by_employee_id' =>$employee_id, 'status' =>'2');
            $where_con    = array('event_id'        => $event_id);
            $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);

            if(!empty($updated_response) && isset($updated_response)) {

                $data = array('status'  => 'true', 'message' => 'Call accepted successfully.');
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Something went wrong please try again later');
                response($data);
            }

        }else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
    }
    public function employee_action_event_post(){

        $event_id       = $this->input->post("event_id");
        $action         = $this->input->post("action");
        $employee_id    = $this->input->post("employee_id");
        $branch_id      = $this->input->post("branch_id");
        
        if(!empty($event_id) && isset($event_id) && !empty($employee_id) && isset($employee_id) && !empty($branch_id) && isset($branch_id) && $action==1 ) {
            $updated_data = array('employee_action' => $action,'responded_by_employee_id' =>$employee_id, 'status' =>'2');
            $where_con    = array('event_id'        => $event_id);
            $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);

            if(!empty($updated_response) && isset($updated_response)) {

                $event_accepted_data=array();
                $event_accepted_data['node_event_name']            = 'event_action_completed'; 
                $event_accepted_data['event_status']               = 'accepted'; 
                $event_accepted_data['event_id']                   = $event_id;
                $event_accepted_data['room_name']                  = 'branch_'.$branch_id;
                $event_call        = $this->Common_model->sendNodeRequest($event_accepted_data);
                
                $data = array('status'  => 'true', 'message' => 'Call accepted successfully.');
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Something went wrong please try again later');
                response($data);
            }

        }elseif(!empty($event_id) && isset($event_id) && !empty($employee_id) && isset($employee_id) && $action==2) {
            
            $updated_data = array('employee_action' => $action,'responded_by_employee_id' =>$employee_id,'status' =>'1');
            $where_con    = array('event_id'        => $event_id);
            $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);

            if(!empty($updated_response) && isset($updated_response)) {
                $event_accepted_data=array();
                $event_accepted_data['node_event_name']            = 'event_action_others'; 
                $event_accepted_data['event_status']               = 'rejected'; 
                $event_accepted_data['event_id']                   = $event_id;
                $event_accepted_data['room_name']                  = 'branch_'.$branch_id;
                $event_call        = $this->Common_model->sendNodeRequest($event_accepted_data);

                $data = array('status'  => 'true', 'message' => 'waiting for employee response');
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Something went wrong please try again later');
                response($data);
            }
        }
        elseif(!empty($event_id) && isset($event_id) && !empty($employee_id) && isset($employee_id) && $action==3) {
            
            $updated_data = array('employee_action' => $action,'responded_by_employee_id' =>$employee_id, 'status' =>'2');
            $where_con    = array('event_id'        => $event_id);
            $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);

            if(!empty($updated_response) && isset($updated_response)) {
                $event_accepted_data=array();
                $event_accepted_data['node_event_name']            = 'event_action_completed'; 
                $event_accepted_data['event_status']               = 'spam'; 
                $event_accepted_data['event_id']                   = $event_id;
                $event_accepted_data['room_name']                  = 'branch_'.$branch_id;
                $event_call        = $this->Common_model->sendNodeRequest($event_accepted_data);
                $data = array('status'  => 'true', 'message' => 'This is a spam call');
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Something went wrong please try again later');
                response($data);
            }
        }
        elseif(!empty($event_id) && isset($event_id) && !empty($employee_id) && isset($employee_id) && $action==4) {
            
            $updated_data = array('employee_action' => $action,'responded_by_employee_id' =>$employee_id, 'status' =>'1');
            // echo '<pre>'; print_r($updated_data);exit;
            $where_con    = array('event_id'        => $event_id);
            $updated_response = $this->Common_model->update_by_where_array('tbl_event_log', $where_con, $updated_data);
            

            if(!empty($updated_response) && isset($updated_response)) {
                $event_accepted_data=array();
                $event_accepted_data['node_event_name']            = 'event_action_others'; 
                $event_accepted_data['event_status']               = 'snoozed'; 
                $event_accepted_data['event_id']                   = $event_id;
                $event_accepted_data['room_name']                  = 'branch_'.$branch_id;
                $event_call        = $this->Common_model->sendNodeRequest($event_accepted_data);
                $data = array('status'  => 'true', 'message' => 'Event is Snoozed');
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'Something went wrong please try again later');
                response($data);
            }
        }
        else{

            $data = array('status'  => 'false', 'message' => 'something went wrong');
            response($data);
        }
    }
    /*
       Author       : Naresh Lakhara
       Date         : 15-06-2022
       Description  : Verify QR
    */
    public function verify_qr_post() {

        $qr_code       = (string)trim(@$this->input->post('qr_code'));

        if(!empty($qr_code) && isset($qr_code)) {
                
            $menu_info = $this->apimodel->verify_qr($qr_code);

            if(!empty($menu_info) && isset($menu_info)) {

                $data = array('status'  => 'true', 'message' => 'Menu found successfully.', 'data' => $menu_info);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'QR code not found.');
                response($data);
            }                

        }  else {

            $data = array('status'  => 'false', 'message' => 'Please enter qr code');
            response($data);
        }
    }
    public function event_record_get(){
        $branch_id   = $this->input->get('branch_id');
        $status      = $this->input->get('status');
        $employee_id = $this->input->get('employee_id');
        $responded_by= $this->input->get('responded_by');
        $table_id    = $this->input->get('table_id');
        $per_page    = PER_PAGE_RECORD;
        $page_no     = $this->input->get('page_no') ? $this->input->get('page_no') : "1";
        $start_from  = ($page_no-1)*$per_page;

        $current_time= date("Y-m-d");
        $from        = $this->input->get('date_from') ? $this->input->get('date_from') : $current_time;
        $from_at     = new DateTime($from);
        $date_from   = date_format($from_at,"Y-m-d H:i:s");
        $to          = $this->input->get('date_to') ? $this->input->get('date_to') : $current_time;
        $to_at       = new DateTime($to);
        $date_to_24     = date_format($to_at,"Y-m-d H:i:s");
                     
        $date_to = date('Y-m-d H:i:s',strtotime($date_to_24) + 86399);
        

        if(!empty($branch_id) && isset($branch_id)) {
                
            $total_record = $this->apimodel->event_record($date_from, $date_to, $per_page, $branch_id, $status, $employee_id, $page_no, $start_from, $table_id, $responded_by);
         


            if(!empty($total_record) && isset($total_record)) {

                $data = array('status'  => 'true', 'message' => 'Record found successfully.','total_no_of_record' => $total_record['total_no_of_record'],'total_no_of_page' => $total_record['total_no_of_page'],'no_of_data_per_page' => $total_record['no_of_data_per_page'], 'data' => $total_record['data']);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'event not found.');
                response($data);
            }                

        }  else {

            $data = array('status'  => 'false', 'message' => 'data not found');
            response($data);
        }
        
    }
    public function employee_list_get(){
        $branch_id = $this->input->get('branch_id');
        $q = "SELECT tbl_branch_employee.employee_id as id, tbl_branch_employee.employee_name as name FROM tbl_branch_employee
              WHERE tbl_branch_employee.branch_id='$branch_id'";
        $query = $this->db->query($q);
        $result = $query->result_array();
        if(!empty($result)) {

            $data = array('status'  => 'true', 'message' => 'Record found successfully.', 'data' => $result);
            response($data);

        } else {

            $data = array('status'  => 'false', 'message' => 'Record not found.');
            response($data);
        }   


    }
    public function table_list_get(){
        $branch_id = $this->input->get('branch_id');
        $q = "SELECT tbl_branch_table.table_id as id, tbl_branch_table.table_name as name FROM tbl_branch_table
              WHERE tbl_branch_table.branch_id='$branch_id'";
        $query = $this->db->query($q);
        $result = $query->result_array();
        if(!empty($result)) {

            $data = array('status'  => 'true', 'message' => 'Record found successfully.', 'data' => $result);
            response($data);

        } else {

            $data = array('status'  => 'false', 'message' => 'Record not found.');
            response($data);
        }   


    }

}
?>