<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('account_admin/employee/Employee_model');
        $isLoggedIn = $this->session->userdata('isLoggedIn');            
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('account_admin');
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 01-06-2022
        Description : Employee Add
    */
    public function add_employee()
    {    
        $this->load->library('form_validation');
        $this->form_validation->set_rules('branch_id', 'Branch ID', 'required');
        $this->form_validation->set_rules('employee_name', 'Employee Name', 'required');
        $this->form_validation->set_rules('email', 'email', 'required|valid_email');

        
        if ($this->form_validation->run() == FALSE)
        {
            /* Edit Record */
            $data              = array();
            $id                = $this->uri->segment(4);
            $data['page_name'] = "Add";

            if($id) {
                $data['edit_data'] = $this->Employee_model->edit($id);
                $data['page_name'] = "Update";
            }

            $data['branch_list'] = $this->Employee_model->branch_list();
            $data['table_list'] = $this->Employee_model->table_list();
            $this->load->view('account_admin/employee/add_employee',$data);
        }
        else {
            $branch_id          = trim(@$this->input->post('branch_id'));
            $email              = trim(@$this->input->post('email'));
            $employee_name      = trim(@$this->input->post('employee_name'));
            $employee_user_name = trim(@$this->input->post('employee_user_name'));
            $phone_number       = trim(@$this->input->post('phone_number'));
            $allow_web_access   = trim(@$this->input->post('allow_web_access'));
            $employee_type      = trim(@$this->input->post('employee_type')); 
            $status             = trim(@$this->input->post('status')); 
            $password           = trim(@$this->input->post('password'));
            $old_password       = trim(@$this->input->post('old_password'));
            $address            = trim(@$this->input->post('address'));       

            if(!empty($_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
                $restaurant_id = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : "0";
            } else {
                $restaurant_id = @$_SESSION['branch_restaurant_id'] ? @$_SESSION['branch_restaurant_id'] : "0";
            }


            /* EMPLOYEE IMAGE UPLOAD */
            if(!empty($_FILES['employee_image']['name']) && isset($_FILES['employee_image']['name'])) {
               
                /* IF DIRECTORY DOES NOT EXISTS THEN CREATE NEW DIRECTORY */
                if(!file_exists('./uploads/employee_images')) {
                    mkdir('./uploads/employee_images', 0777, true);
                    $old = umask(0);
                    chmod('./uploads/employee_images', 0777);
                    umask($old);
                }

                /* VALIDATE IMAGES */            
                $file_types = array('jpg','jpeg','png');
                $new_name    = $_FILES['employee_image']['name'];
                $new_name    = str_replace(" ","_",$new_name);
                $image_name_explode  = explode('.', $new_name);
                $extension = end($image_name_explode);

                if(!in_array($extension, $file_types)) {
                   $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only ( jpg / jpeg / png ).');
                   echo json_encode($array); 
                   exit;
                }

                /* UPLOAD IMAGES */

                $_FILES['userfile']['name']     = $_FILES['employee_image']['name'];
                $_FILES['userfile']['type']     = $_FILES['employee_image']['type'];
                $_FILES['userfile']['tmp_name'] = $_FILES['employee_image']['tmp_name'];
                $_FILES['userfile']['error']    = $_FILES['employee_image']['error'];
                $_FILES['userfile']['size']     = $_FILES['employee_image']['size'];

                $config['upload_path']      = "./uploads/employee_images";
                $config['allowed_types']    = 'gif|jpg|png|jpeg';
                $config['overwrite']        = TRUE;
                $config['max_size']         = '0';

                $new_name   = $_FILES['employee_image']['name'];
                $new_name   =  str_replace(" ","_",$new_name);
                $config['file_name'] = strtolower($new_name);

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('userfile')){

                    $fileData         = $this->upload->data();
                    $employee_image = $fileData['file_name'];

                } else {

                    $array = array('result' => 'failure', 'message' => 'Something error found while uploading image !');
                    echo json_encode($array); 
                    exit;
                }
            } else {
                @$employee_image = trim(@$this->input->post('old_restaurant_image'));
            }
            
            /* Author : Pushpesh , Date : 04-08-2022*/
            $selected_table        = @$this->input->post('assign_table'); 
            
            /* End Code  Date : 04-08-2022*/

            

            $data = array(
                'restaurant_id'      => @$restaurant_id,
                'branch_id'          => @$branch_id,
                'employee_name'      => @$employee_name,
                'employee_user_name' => @$employee_user_name,
                'employee_image'     => @$employee_image,
                'email'              => @$email,
                'password'           => @$password ? md5(@$password) : $old_password,
                'phone_number'       => @$phone_number,
                'address'            => @$address,
                'allow_web_access'   => @$allow_web_access,
                'employee_type'      => @$employee_type,
                'status'             => @$status,
            );

            if($employee_type == '0') {
                $assign_table=implode(",",$selected_table);
                $data['assign_table'] = $assign_table;
            }
            if($employee_type == '1') {
                $data['assign_table'] ="";
            }
            
            $employee_id = @$this->input->post('employee_id');

            $validate_data = $this->Common_model->check_duplicate_email('tbl_branch_employee', 'email ', $email, 'employee_id ', $employee_id);

            if(!empty($validate_data) && isset($validate_data)) { 

                $array = array('result' => 'failure', 'message' => 'Sorry ! Email address is already exist.');
                echo json_encode($array); 
                exit;

            } else {
        
                if(!empty(@$employee_id) && isset($employee_id)) {

                    $data['modified_on']     = date("Y-m-d H:i:s");
                    $data['modified_by']     = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];

                    $where_con = array('employee_id' => $employee_id);
                    $result = $this->Common_model->update_by_where_array('tbl_branch_employee',$where_con, $data);
                    
                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Employee updated succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Employee not updated please try again later.');
                        echo json_encode($data);
                        exit;                
                    }

                } else {

                    $data['created_on']      = date("Y-m-d H:i:s");
                    $data['created_by']      = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];
                    $data['created_by_type'] = @$_SESSION['restaurant_id'] ? "0" : "1"; 

                    $result   = $this->Common_model->insert_data('tbl_branch_employee',$data);

                    if($result) {

                        $data = array('result' => 'success', 'message' => 'Employee added succussfully.');
                        echo json_encode($data);
                        exit;
                    
                    } else {

                        $data = array('result' => 'failure', 'message' => 'Employee not added please try again later.');
                        echo json_encode($data);
                        exit;                        
                    }
                }
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 31-05-2022
        Description : Manage Employee
    */
    public function manage_employee() {
        $data = array();
          $data['branch_list'] = $this->Employee_model->branch_list();        
        $this->load->view("account_admin/employee/manage_employee", $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage Employee Ajax
        Date        : 31-05-2022
    */
    public function manage_employee_ajax() {

        $list = $this->Employee_model->manage_employee_ajax();
        echo json_encode($list = array());
        exit;
    } 
}
