<?php defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH.'libraries/REST_Controller.php';
/*
    Author      : Naresh Lakhara
    Description : Rest API Controller setup
    Date        : 15-06-2022 
*/
class Api extends REST_Controller {

    public function __construct()
    {        
        parent::__construct();
        $this->load->model('Api_model','apimodel', True);        
    }

    /*
       Author       : Naresh Lakhara
       Date         : 15-06-2022
       Description  : Verify QR
    */
    public function verify_qr_post() {

        $qr_code       = (string)trim(@$this->input->post('qr_code'));

        if(!empty($qr_code) && isset($qr_code)) {
                
            $menu_info = $this->apimodel->verify_qr($qr_code);

            if(!empty($menu_info) && isset($menu_info)) {

                $data = array('status'  => 'true', 'message' => 'Menu found successfully.', 'data' => $menu_info);
                response($data);

            } else {

                $data = array('status'  => 'false', 'message' => 'QR code not found.');
                response($data);
            }                

        }  else {

            $data = array('status'  => 'false', 'message' => 'Please enter qr code');
            response($data);
        }
    }
}
?>