<?php
$this->load->view('admin/header');
?>
<?php
$this->load->view('admin/sidebar');
?>
<style type="text/css">
    .ChangeColor{
        color: green;
    }
    .ChangeColor:hover{
        color: black;
    }
    .ChangeColor:focus{
        color: black;
    }
    .ChangeColor:active{
        color: black;
    }
</style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Manage Branch</h1>
            <ol class="breadcrumb">
              <li><a href="javascript:void(0);"><i class="fa fa-dashboard"></i>Branch</a></li>
              <li class="active">Manage Branch</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
            <div class="col-xs-12">
              <div class="box">
                <div class="box-body">                    

                  <table id="dataTable" class="table table-bordered display nowrap" width="100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Restaurant Name</th>
                                <th>Branch Name</th>
                                <th>Display Name</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Phone Number</th>
                                <th>Billing Contact Person</th>
                                <th>Billing Email</th>
								<th>Billing Phone</th>
								<th>GST No.</th>
                                <th>Status</th>
								<th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </section>
    </div>    
<?php
$this->load->view('admin/footer');
?>

<script type="text/javascript">

var table_ajax;
table_ajax = jQuery('#dataTable').dataTable({
    "processing": true,
    "searching": true,
    "serverSide": true,
    "scrollX": true,
    "oLanguage": {
        "sEmptyTable": "No data found",
    },
    "ajax":{
        url: "<?php echo base_url('admin/branch/branch/manage_branch_ajax'); ?>",
        type: "post",
        data: function(d) {
            d.search_data = returnData();
            var order_by  = d.order[0]['dir'];
            var order_for = d.order[0]['column'];
        },
        dataFilter: function(response){
            var data = JSON.parse(response);
            var length = data.recordsTotal;                
            return response;
        },
        complete : function() {
            // jQuery('.page-loader-wrapper').hide();
        },
        error: function(){  
            // jQuery('.page-loader-wrapper').hide();
        }
    },
    "order": [[0, "desc"]],
    "columns": [  
        {"data": "branch_id" ,orderable: true, name: "t_br.branch_id" },              
        {"data": "restaurant_name" ,orderable: true, name: "t_res.restaurant_name" },              
        {

            "data": "t_br.branch_name" ,
            "orderable": true,
            "name": "t_br.branch_name",
            render: function(data, type, row, meta) {                
                var link = "<span><a class='ChangeColor' href='add/"+row['branch_id']+"'>"+row['branch_name']+"<a><span>";
                return link;
            }
        },       
        {"data": "display_name" ,orderable: true, name: "t_br.display_name" },              
        {"data": "first_name" ,orderable: true, name: "t_br.first_name" },          
        {"data": "last_name" ,orderable: true, name: "t_br.last_name" },          
        {"data": "email" ,orderable: false, name: "t_br.email" },                        
        {"data": "phone_number" ,orderable: false, name: "t_br.phone_number" },                        
        {"data": "billing_contact_person" ,orderable: false, name: "t_br.billing_contact_person" },                        
        {"data": "billing_email" ,orderable: false, name: "t_br.billing_email" },                        
        {"data": "billing_phone" ,orderable: false, name: "t_br.billing_phone" },                        
        {"data": "gst_number" ,orderable: false, name: "t_br.gst_number" },
        {
            data: 'status',
            orderable: false,
            name:'t_br.status',
            render: function(data, type, row, meta) {   

                if(row['status'] == '1') {
                    var status = "<span style='color:green'>Active</span>";
                } else {
                    var status = "<span style='color:red'>Suspend</span>";
                }
                return status;
            }
        },
        {
            data: 'action',
            orderable: false,
            render: function(data, type, row, meta) {                
                var link = "<a href='add/"+row['branch_id']+"'><img width='25px' height='25px' src='<?php echo base_url('/assets/img/edit.png'); ?>'></img><a>";
                return link;
            }
        }
    ],
    fnServerParams: function (data) {
        data["order"].forEach(function (items, index) {
            data["order"][index]["column"] = data["columns"][items.column]["name"];
        });
    },
});

function returnData()
{
    var searchAry             = {};
    // searchAry['booking_status']   = $("#booking_status").val();
    return searchAry;
}
</script>
