<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Action extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('accountadmin/action/Action_model');
        $isLoggedIn = $this->session->userdata('isLoggedIn');            
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            redirect('accountadmin');
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 06-06-2022
        Description : Add Action
    */
    public function add_action()
    {    
        $this->load->library('form_validation');
        $this->form_validation->set_rules('branch_id', 'Branch ID', 'required');
        $this->form_validation->set_rules('action_id', 'Action ID', 'required');
        $this->form_validation->set_rules('action_name', 'Action Name', 'required');
        
        if ($this->form_validation->run() == FALSE)
        {
            /* Edit Record */
            $data              = array();
            $id                = $this->uri->segment(4);
            $data['page_name'] = "Add";

            if($id) {

                $data['edit_data']   = $this->Action_model->edit($id);
                $data['images_list'] = $this->Action_model->images_fetch($data['edit_data']['restaurant_id'], $data['edit_data']['branch_id'], $data['edit_data']['action_id'],$data['edit_data']['branch_action_id'] );
                $data['page_name'] = "Update";
            }
            $data['branch_list'] = $this->Action_model->branch_list();
            $data['action_list'] = $this->Action_model->action_list();
            $this->load->view('accountadmin/action/add_action',$data);
        }
        else {

            $branch_id    = trim(@$this->input->post('branch_id'));
            $action_id    = trim(@$this->input->post('action_id'));
            $action_name  = trim(@$this->input->post('action_name'));
            $action_url   = trim(@$this->input->post('action_url'));
            $button_color = trim(@$this->input->post('button_color'));
            $font_color   = trim(@$this->input->post('font_color')); 
            $status       = trim(@$this->input->post('status'));       

            if(!empty($_SESSION['restaurant_id']) && isset($_SESSION['restaurant_id'])) {
                $restaurant_id = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : "0";
            } else {
                $restaurant_id = @$_SESSION['branch_restaurant_id'] ? @$_SESSION['branch_restaurant_id'] : "0";
            }

            /* IMAGE UPLOAD */
            $upload_image_array = array();
            if(!empty($_FILES['userfile']['name'][0]) && isset($_FILES['userfile']['name'][0])) {

                /*Create Directory*/
                if(!file_exists('./uploads/branch_action_image')) {
                    mkdir('./uploads/branch_action_image', 0777, true);
                    $old = umask(0);
                    chmod('./uploads/branch_action_image', 0777);
                    umask($old);
                }

                $count = count($_FILES['userfile']['size']);

                /*Pdf or Image*/
                if($action_id == '5') {
                    $file_types = array('pdf');
                } else {
                    $file_types = array('jpg','jpeg','png');    
                }

                /*Validate Images */        
                foreach($_FILES as $key => $value)  {
                    
                    for($s = 0; $s <= $count-1; $s++) {
                        $new_name    = $value['name'][$s];
                        $new_name    = str_replace(" ","_",$new_name);
                        $image_name_explode  = explode('.', $new_name);
                        $extension = end($image_name_explode);

                        if(!in_array($extension, $file_types)) {

                            if($action_id == '5') {

                                $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only PDF.');
                                echo json_encode($array);
                                exit;

                            } else {

                                $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only(jpg/jpeg/png).');
                                echo json_encode($array); 
                                exit;
                            }
                        }
                    }
                }
                /*Validate Images end */        


                /*Image uploaded*/
                foreach($_FILES as $key => $value)  {

                    for($s = 0; $s <= $count-1; $s++) {

                        $_FILES['userfile']['name']     = $value['name'][$s];
                        $_FILES['userfile']['type']     = $value['type'][$s];
                        $_FILES['userfile']['tmp_name'] = $value['tmp_name'][$s];
                        $_FILES['userfile']['error']    = $value['error'][$s];
                        $_FILES['userfile']['size']     = $value['size'][$s];

                        $config['upload_path']      = "./uploads/branch_action_image";
                        $config['allowed_types']    = 'gif|jpg|png|jpeg|pdf';
                        $config['overwrite']        = TRUE;
                        $config['max_size']         = '0';

                        $new_name   = date("Y-m-d_H:i:s")."_".$value['name'][$s];                    
                        $new_name   =  str_replace(" ","_",$new_name);
                        $config['file_name'] = strtolower($new_name);

                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);

                        if($this->upload->do_upload('userfile')){ 
                                            
                            $fileData = $this->upload->data(); 

                            $upload_image_array[] = array(
                                'restaurant_id' => @$restaurant_id,
                                'branch_id'     => @$branch_id,
                                'action_id'     => @$action_id,
                                'images'        => @$fileData['file_name'],
                                'created_on'    => date("Y-m-d H:i:s"),
                                'created_by'    => @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'],
                            );
                        } 
                    }
                }    
            }
            
            $data = array(
                'restaurant_id'      => @$restaurant_id,
                'branch_id'          => @$branch_id,
                'action_name'        => @$action_name,
                'action_id'          => @$action_id,
                'action_url'         => @$action_url,
                'button_color'       => @$button_color,
                'font_color'         => @$font_color,              
                'status'             => @$status,
            );
            
            $branch_action_id = @$this->input->post('branch_action_id');
            $finalArray       = array();

            if(!empty(@$branch_action_id) && isset($branch_action_id)) {

                $data['modified_on']     = date("Y-m-d H:i:s");
                $data['modified_by']     = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];

                $where_con = array('branch_action_id' => $branch_action_id);
                $result = $this->Common_model->update_by_where_array('tbl_branch_action', $data, $where_con);
                
                if($action_id == '5') {

                    /* FOR PDF  */
                    $image_where_con = array('restaurant_id' => $restaurant_id, 'branch_id' => $branch_id, 'branch_action_id' => $branch_action_id);
                    $pdf_check = $this->Common_model->single_record_fetch('image_id','tbl_branch_action_image',$image_where_con);
                    if(!empty($pdf_check)){
                        $pdf_where_con = array('image_id' => $pdf_check['image_id']);
                    $result = $this->Common_model->update_by_where_array('tbl_branch_action_image', $upload_image_array[0], $pdf_where_con);
                    }
                    else{
                        $upload_image_array[0]['branch_action_id']=$branch_action_id;
                        $result = $this->Common_model->insert_data('tbl_branch_action_image', $upload_image_array[0]);
                    }
                    

                } else {

                    /* Update Image */
                    if(!empty($upload_image_array) && isset($upload_image_array) && !empty($branch_action_id)) {

                        foreach ($upload_image_array as $key => $value) {
                            
                            $finalArray[] = array(
                                'branch_action_id' => $branch_action_id,
                                'restaurant_id'    => $value['restaurant_id'],
                                'branch_id'        => $value['branch_id'],
                                'action_id'        => $value['action_id'],
                                'images'           => $value['images'],
                                'created_on'       => $value['created_on'],
                                'created_by'       => $value['created_by'],
                            );
                        }

                        $this->Common_model->insert_batch_data('tbl_branch_action_image',$finalArray);
                    }      
                } 

                if($result) {

                    $data = array('result' => 'success', 'message' => 'Branch action updated succussfully.');
                    echo json_encode($data);
                    exit;
                
                } else {

                    $data = array('result' => 'failure', 'message' => 'Branch action not updated please try again later.');
                    echo json_encode($data);
                    exit;
                }

            } else {

                $data['created_on']      = date("Y-m-d H:i:s");
                $data['created_by']      = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];
                $data['created_by_type'] = @$_SESSION['restaurant_id'] ? "0" : "1"; 

                $result   = $this->Common_model->insert_data('tbl_branch_action',$data);

                /* Update Image */                
                if(!empty($upload_image_array) && isset($upload_image_array) && !empty($result)) {
                        
                    foreach ($upload_image_array as $key => $value) {
                        
                        $finalArray[] = array(
                            'branch_action_id' => $result,
                            'restaurant_id'    => $value['restaurant_id'],
                            'branch_id'        => $value['branch_id'],
                            'action_id'        => $value['action_id'],
                            'images'           => $value['images'],
                            'created_on'       => $value['created_on'],
                            'created_by'       => $value['created_by'],
                        );
                    }

                    $this->Common_model->insert_batch_data('tbl_branch_action_image', $finalArray);
                }

                if($result) {

                    $data = array('result' => 'success', 'message' => 'Branch action added succussfully.');
                    echo json_encode($data);
                    exit;
                
                } else {

                    $data = array('result' => 'failure', 'message' => 'Branch action not added please try again later.');
                    echo json_encode($data);
                    exit;                        
                }
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 20-07-2022
        Description : Update Action
    */
    public function update_action() {

        $branch_action_id = $this->input->post('f_branch_action_id');
        $action_id        = $this->input->post('f_action_id');
        $action_name      = $this->input->post('action_name');
        $action_url       = $this->input->post('action_url');
        $status           = $this->input->post('status');

        if(!empty($branch_action_id) && isset($branch_action_id)) {

            $field_name   = array('restaurant_id','branch_id','action_id', 'is_default', 'action_name');
            
            $where_con    = array('branch_action_id' => $branch_action_id);
            $branch_action_check = $this->Common_model->single_record_fetch($field_name,'tbl_branch_action',$where_con);
           
            if(!empty($branch_action_check['is_default']) && isset($branch_action_check['is_default']) && $status == '0') {

                $array = array('result' => 'failure', 'message' => $branch_action_check['action_name'].' is a default action you can not suspended.');
                echo json_encode($array);
                exit;

            } else {

                if(!empty($branch_action_check) && isset($branch_action_check)) {
                     
                    /* DATA GET */
                    if(!empty($action_name) && isset($action_name)) {
                        $update_data['action_name'] = $action_name;
                    }
                    if(!empty($action_url) && isset($action_url)) {
                        $update_data['action_url'] = $action_url;                
                    }

                    /* IMAGE UPLOAD */
                    $upload_image_array = array();
                    if(!empty($_FILES['userfile']['name'][0]) && isset($_FILES['userfile']['name'][0])) {

                        /*Create Directory*/
                        if(!file_exists('./uploads/branch_action_image')) {
                            mkdir('./uploads/branch_action_image', 0777, true);
                            $old = umask(0);
                            chmod('./uploads/branch_action_image', 0777);
                            umask($old);
                        }

                        $count = count($_FILES['userfile']['size']);

                        /*Pdf or Image*/
                        if($action_id == '5') {
                            $file_types = array('pdf');
                        } else {
                            $file_types = array('jpg','jpeg','png');    
                        }

                        /*Validate Images */        
                        foreach($_FILES as $key => $value)  {
                            
                            for($s = 0; $s <= $count-1; $s++) {
                                $new_name    = $value['name'][$s];
                                $new_name    = str_replace(" ","_",$new_name);
                                $image_name_explode  = explode('.', $new_name);
                                $extension = end($image_name_explode);

                                if(!in_array($extension, $file_types)) {

                                    if($action_id == '5') {

                                        $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only PDF.');
                                        echo json_encode($array);
                                        exit;

                                    } else {

                                        $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only(jpg/jpeg/png).');
                                        echo json_encode($array); 
                                        exit;
                                    }
                                }
                            }
                        }
                        /*Validate Images end */        


                        /*Image uploaded*/
                        foreach($_FILES as $key => $value)  {

                            for($s = 0; $s <= $count-1; $s++) {

                                $_FILES['userfile']['name']     = $value['name'][$s];
                                $_FILES['userfile']['type']     = $value['type'][$s];
                                $_FILES['userfile']['tmp_name'] = $value['tmp_name'][$s];
                                $_FILES['userfile']['error']    = $value['error'][$s];
                                $_FILES['userfile']['size']     = $value['size'][$s];

                                $config['upload_path']      = "./uploads/branch_action_image";
                                $config['allowed_types']    = 'gif|jpg|png|jpeg|pdf';
                                $config['overwrite']        = TRUE;
                                $config['max_size']         = '0';

                                $new_name   = date("Y-m-d_H:i:s")."_".$value['name'][$s];                    
                                $new_name   =  str_replace(" ","_",$new_name);
                                $config['file_name'] = strtolower($new_name);

                                $this->load->library('upload', $config);
                                $this->upload->initialize($config);

                                if($this->upload->do_upload('userfile')){ 
                                                    
                                    $fileData = $this->upload->data();

                                    $upload_image_array[] = array(
                                        'branch_action_id'  => @$branch_action_id,
                                        'restaurant_id'     => @$branch_action_check['restaurant_id'],
                                        'branch_id'         => @$branch_action_check['branch_id'],
                                        'action_id'         => @$branch_action_check['action_id'],
                                        'images'            => @$fileData['file_name'],
                                        'created_on'        => date("Y-m-d H:i:s"),
                                        'created_by'        => @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'],
                                    );
                                } 
                            }
                        }    
                    }
                   
                    if($action_id == '5') {

                        /* FOR PDF  */
                        $image_where_con = array('branch_action_id' => $branch_action_id);
                        $pdf_check = $this->Common_model->single_record_fetch('image_id','tbl_branch_action_image',$image_where_con);
                        if(!empty($pdf_check)){
                            $pdf_where_con = array('image_id' => $pdf_check['image_id']);
                        $result = $this->Common_model->update_by_where_array('tbl_branch_action_image', $upload_image_array[0], $pdf_where_con);
                        }
                        else{
                            $upload_image_array[0]['branch_action_id']=$branch_action_id;
                            $result = $this->Common_model->insert_data('tbl_branch_action_image', $upload_image_array[0]);
                        }
                    }
                    else{
                    $this->Common_model->insert_batch_data('tbl_branch_action_image', $upload_image_array);

                    }    
                    
                    $update_data['status'] = $status;
                    $response   = $this->Common_model->update_by_where_array('tbl_branch_action', $update_data, $where_con);

                    $array = array('result' => 'success', 'message' => 'Updated succussfully.');
                    echo json_encode($array);
                    exit;

                } else {

                    $array = array('result' => 'failure', 'message' => 'Something error found please try again later.');
                    echo json_encode($array);
                    exit;
                }
            }

        } else {            
            $array = array('result' => 'failure', 'message' => 'Sorry! you can upload only PDF.');
            echo json_encode($array);
            exit;
        }
    }


    /*
        Author      : Naresh Lakhara
        Date        : 21-07-2022
        Description : Action Images Delete
    */
    public function action_images() {

        $branch_action_id = $this->input->post('f_branch_action_id');      

        if(!empty($branch_action_id) && isset($branch_action_id)) {

            $field_name = array('image_id','images');
            $where_con  = array('branch_action_id' => $branch_action_id);
            $images     = $this->Common_model->get_selected_data_where_array($field_name, 'tbl_branch_action_image', $where_con); 
            
            if(!empty($images) && isset($images)) {

                $array = array('result' => 'success', 'message' => 'Images found succussfully', 'data' => $images);
                echo json_encode($array);
                exit;

            } else {

                $array = array('result' => 'failure', 'message' => 'Images not found');
                echo json_encode($array);
                exit;
            }            

        } else {
            
            $array = array('result' => 'failure', 'message' => 'Something error found please try again later');
            echo json_encode($array);
            exit;
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 06-06-2022
        Description : Manage Action
    */
    public function manage_action() {
        $data = array();        
        $data['branch_list'] = $this->Action_model->branch_list();     
        $data['action_list'] = $this->Action_model->action_list();           
        $this->load->view("accountadmin/action/manage_action", $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Manage Action Ajax
        Date        : 06-06-2022
    */
    public function manage_action_ajax() {

        $list = $this->Action_model->manage_action_ajax();
        echo json_encode($list = array());
        exit;
    }

    /*
        Author      : Naresh Lakhara
        Description : Delete Image
        Date        : 06-06-2022
    */
    public function delete_image() {

        $image_id   =  $this->input->post('id');
        $image_name  = $this->input->post('name');
        $this->Common_model->delete_by_where_array('tbl_branch_action_image', array('image_id' => $image_id));
        $path  = FCPATH.'uploads/branch_action_image/'.$image_name;
        unlink($path);        
        $data = array('result' => 'success', 'message' => 'Image deleted succussfully.');
        echo json_encode($data);
        exit;        
    }

    /*
        Author      : Naresh Lakhara
        Description : Feedback Page
        Date        : 13-06-2022
    */
    public function feedback() {
       
        $this->load->library('form_validation');
        $this->form_validation->set_rules('form_name', 'Form Name', 'required');

        if ($this->form_validation->run() == FALSE)
        {   
            $data = array();
            $data['branch_action_id'] = $this->uri->segment(4);
            $data['edit_form_details'] = $this->Action_model->edit_form_details(base64_decode($data['branch_action_id']));
            $this->load->view('accountadmin/action/feedback',$data);

        } else {

            $total_num_rows = @$_POST['total_num_rows'] ? @$_POST['total_num_rows'] : "0";
            $total_options  = @$_POST['total_options'] ? @$_POST['total_options'] : "0";
            $form_details   = array();

            $form_name  = @$_POST['form_name'];
            $status     = @$_POST['status'];

        
            /*Form Details*/
            for ($i = 1; $i <= $total_num_rows ; $i++) { 
                
                /* VALIDATE DATA */
                if(empty($_POST['title_'.$i]) && isset($_POST['title_'.$i])) {
                    $data = array('result' => 'failure', 'message' => 'Title is required !');
                    echo json_encode($data);
                    exit;
                }

                if(empty($_POST['placeholder_'.$i]) && isset($_POST['placeholder_'.$i])) {
                    $data = array('result' => 'failure', 'message' => 'Placeholder is required !');
                    echo json_encode($data);
                    exit;
                }

                if(empty($_POST['field_type_'.$i]) && isset($_POST['field_type_'.$i])) {
                    $data = array('result' => 'failure', 'message' => 'Type is required !');
                    echo json_encode($data);
                    exit;
                }

                if(empty($_POST['sequence_'.$i]) && isset($_POST['sequence_'.$i])) {
                    $data = array('result' => 'failure', 'message' => 'Sequence is required !');
                    echo json_encode($data);
                    exit;
                }
                

                $options_get    = array();

                if(!empty($_POST['title_'.$i]) && isset($_POST['title_'.$i])) {

                    for ($j = 1; $j <= $total_options ; $j++) {

                        if(empty($_POST['option_val_'.$i.'_'.$j]) && isset($_POST['option_val_'.$i.'_'.$j])) {
                            $data = array('result' => 'failure', 'message' => 'Options is required !');
                            echo json_encode($data);
                            exit;
                        }

                        if(isset($_POST['option_val_'.$i.'_'.$j])){
                            $options_get[] = array(
                                'options' => $_POST['option_val_'.$i.'_'.$j], 
                            );
                        }
                    }

                    $form_details[] = array(
                        'title'             => (string)@$_POST['title_'.$i],
                        'placeholder'       => (string)@$_POST['placeholder_'.$i],
                        'master_field_type' => (string)@$_POST['master_field_type_'.$i],
                        'field_type'        => (string)@$_POST['field_type_'.$i],
                        'form_detail_id'    => (string)@$_POST['form_detail_id_'.$i],
                        'is_required'       => (string)@$_POST['is_required_'.$i] == 'on' ? '1' : "0",
                        'sequence'          => (string)@$_POST['sequence_'.$i],
                        'options_json'      => @$options_get ? json_encode($options_get) : "",
                    );
                } 
            }

            if(!empty($form_details) && isset($form_details)) {

                $branch_action_id = base64_decode($_POST['branch_action_id']);

                $field_name   = array('feedback_id');
                $where_con    = array('branch_action_id' => $branch_action_id);
                $feedback_available = $this->Common_model->single_record_fetch($field_name,'tbl_feedback',$where_con);

                $form_data = array(
                    'branch_action_id'   => @$branch_action_id,
                    'feedback_form_name' => @$form_name,
                    'status'             => @$status,
                );

                /* FEEDBACK DATA */
                if(!empty($feedback_available) && isset($feedback_available)) {

                    $feedback_id = @$feedback_available['feedback_id'];

                    $form_data['modified_on']     = date("Y-m-d H:i:s");
                    $form_data['modified_by']     = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];

                    $where_con  = array('feedback_id' => $feedback_id);
                    $response   = $this->Common_model->update_by_where_array('tbl_feedback', $form_data, $where_con);

                } else {

                    $form_data['created_on']      = date("Y-m-d H:i:s");
                    $form_data['created_by']      = @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'];
                    $form_data['created_by_type'] = @$_SESSION['restaurant_id'] ? "0" : "1"; 

                    $feedback_id = $this->Common_model->insert_data('tbl_feedback', $form_data);
                }

                // /* REMOVE FORM DETAILS */
                // $where_con = array("feedback_id" => @$feedback_id);
                // $this->Common_model->delete_by_where_array('tbl_feedback_form_details', $where_con);

                /* FEEDBACK FORM DETAILS DATA */
                foreach ($form_details as $key => $value) {
                        
                    $where_con  = array('feedback_id' => $feedback_id, 'form_detail_id' => @$value['form_detail_id']);
                    $field      = array('form_detail_id');
                    $details_get = $this->Common_model->single_record_fetch($field, 'tbl_feedback_form_details', $where_con);
                    
                    $insert_form_details = array(
                        'feedback_id'       => @$feedback_id,
                        'form_detail_id'    => @$value['form_detail_id'],
                        'title'             => @$value['title'],
                        'placeholder'       => @$value['placeholder'],
                        'master_field_type' => @$value['master_field_type'],
                        'field_type'        => @$value['field_type'],
                        'is_required'       => @$value['is_required'],
                        'sequence'          => @$value['sequence'],
                        'options_json'      => @$value['options_json'],
                        'created_on'        => date("Y-m-d H:i:s"),
                        'created_by'        => @$_SESSION['restaurant_id'] ? @$_SESSION['restaurant_id'] : @$_SESSION['branch_id'],
                        'created_by_type'   => @$_SESSION['restaurant_id'] ? "0" : "1",
                    );

                    if(!empty($details_get) && isset($details_get)) {

                        $this->Common_model->update_by_where_array('tbl_feedback_form_details', $insert_form_details, $where_con);

                    } else {

                        $this->Common_model->insert_data('tbl_feedback_form_details', $insert_form_details);
                    }                
                }

                if(!empty($feedback_id) && isset($feedback_id)) {

                    $data = array('result' => 'success', 'message' => 'Updated succussfully.');
                    echo json_encode($data);
                    exit;

                } else {

                    $data = array('result' => 'failure', 'message' => 'Something went wrong please try again later !');
                    echo json_encode($data);
                    exit; 
                }

            } else {

                $data = array('result' => 'failure', 'message' => 'At least add one field !');
                echo json_encode($data);
                exit;
            }
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Menu Preview For Branch
        Date        : 18-07-2022
    */
    public function preview() {
        $data['page_name'] = "Preview";
        $data['branch_list'] = $this->Action_model->branch_list();
        $this->load->view('accountadmin/action/preview', $data);
    }

    /*
        Author      : Naresh Lakhara
        Description : Branch wise preview data 
        Date        : 18-07-2022
    */
    public function branch_wise_preview() {

        $branch_id   = $this->input->post('branch_id');
        $branch_info = $this->Action_model->branch_info($branch_id);

        if(!empty($branch_info) && isset($branch_info)) {
            $array = array('result' => 'success', 'message' => 'Branch info fetch succussfully.', 'data' => $branch_info);
            echo json_encode($array);
            exit;
        } else {
            $array = array('result' => 'failure', 'message' => 'Branch info not found.');
            echo json_encode($array);
            exit;
        }
    }

    public function delete_form_field() {

        $form_detail_id = $this->input->post('form_detail_id');
        $where_con = array('form_detail_id' => $form_detail_id);
        $update_data = array('is_delete' => '1');
        $result = $this->Common_model->update_by_where_array('tbl_feedback_form_details', $update_data, $where_con);   

        if(!empty($result) && isset($result)) {

            $data_response = array('result' => 'success', 'message' => 'deleted successfully.');
            echo json_encode($data_response);

        } else {

            $data_response = array('result' => 'failure', 'message' => 'something went wrong.');
            echo json_encode($data_response);
        }
    }
}
