<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Menu_model');
        $this->load->model('accountadmin/action/Action_model');          
    }
    /*
        Author      : Naresh Lakhara
        Date        : 16-06-2022
        Description : Manage Action
    */
    public function menu_display() {

        $data          = array();
        $table_id      = @$this->uri->segment(2) ? base64_decode(@$this->uri->segment(2)) : "0";

        if(!empty($table_id) && isset($table_id)) {

            $field_name = array('restaurant_id','branch_id');
            $where_con  = array('table_id' => $table_id);
            $table_info = $this->Common_model->single_record_fetch($field_name,'tbl_branch_table',$where_con);

            if(!empty($table_info['branch_id']) && isset($table_info['branch_id'])) {                           
            
                $data['branch_id'] = $table_info['branch_id'];
                $this->load->view("menu_page", $data);
            
            } else {
            
                $this->page_404();
            }

        } else {
            $this->page_404();
        }
    }

    /*
        Author      : Naresh Lakhara
        Description : Branch wise preview data 
        Date        : 18-07-2022
    */
    public function branch_wise_preview() {

        $branch_id   = $this->input->post('branch_id');
        $branch_info = $this->Action_model->branch_info($branch_id);

        if(!empty($branch_info) && isset($branch_info)) {
            $array = array('result' => 'success', 'message' => 'Branch info fetch succussfully.', 'data' => $branch_info);
            echo json_encode($array);
            exit;

        } else {

            $this->page_404();            
        }
    }

    /*
        Author      : Naresh Lakhara
        Date        : 17-06-2022
        Description : 404 Page
    */
    public function page_404() {
        $this->load->view("404_page");
    }
}
