<?php
$this->load->view('admin/header');
?>
<?php
$this->load->view('admin/sidebar');
?>
<style type="text/css">
    .ChangeColor{
        color: green;
    }
    .ChangeColor:hover{
        color: black;
    }
    .ChangeColor:focus{
        color: black;
    }
    .ChangeColor:active{
        color: black;
    }
</style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Manage Restaurant</h1>
            <ol class="breadcrumb">
              <li><a href="javascript:void(0);"><i class="fa fa-dashboard"></i>Restaurant</a></li>
              <li class="active">Manage Restaurant</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
            <div class="col-xs-12">
              <div class="box">
                <div class="box-body">                    

                  <table id="dataTable" class="table table-bordered display nowrap" width="100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Restaurant Name</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Phone Number</th>
                                <th>Billing Contact Person</th>
                                <th>Billing Email</th>
								<th>Billing Phone</th>
								<th>GST No.</th>
                                <th>Status</th>
								<th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </section>
    </div>    
<?php
$this->load->view('admin/footer');
?>

<script type="text/javascript">

var table_ajax;
table_ajax = jQuery('#dataTable').dataTable({
    "processing": true,
    "searching": true,
    "serverSide": true,
    "scrollX": true,
    "oLanguage": {
        "sEmptyTable": "No data found",
    },
    "ajax":{
        url: "<?php echo base_url('admin/restaurant/restaurant/manage_restaurant_ajax'); ?>",
        type: "post",
        data: function(d) {
            d.search_data = returnData();
            var order_by  = d.order[0]['dir'];
            var order_for = d.order[0]['column'];
        },
        dataFilter: function(response){
            var data = JSON.parse(response);
            var length = data.recordsTotal;                
            return response;
        },
        complete : function() {
            // jQuery('.page-loader-wrapper').hide();
        },
        error: function(){  
            // jQuery('.page-loader-wrapper').hide();
        }
    },
    "order": [[0, "desc"]],
    "columns": [  
        {"data": "restaurant_id" ,orderable: true, name: "restaurant_id" },              
        {

            "data": "restaurant_name" ,
            "orderable": true, 
            "name": "restaurant_name",
            render: function(data, type, row, meta) {                
                var link = "<span><a class='ChangeColor' href='add/"+row['restaurant_id']+"'>"+row['restaurant_name']+"<a><span>";
                return link;
            }
        },              
        {"data": "first_name" ,orderable: true, name: "first_name" },          
        {"data": "last_name" ,orderable: true, name: "last_name" },          
        {"data": "email" ,orderable: false, name: "email" },                        
        {"data": "phone_number" ,orderable: false, name: "phone_number" },                        
        {"data": "billing_contact_person" ,orderable: false, name: "billing_contact_person" },                        
        {"data": "billing_email" ,orderable: false, name: "billing_email" },                        
        {"data": "billing_phone" ,orderable: false, name: "billing_phone" },                        
        {"data": "gst_number" ,orderable: false, name: "gst_number" },
        {
            data: 'status',
            orderable: false,
            name:'status',
            render: function(data, type, row, meta) {   

                if(row['status'] == '1') {
                    var status = "<span style='color:green'>Active</span>";
                } else {
                    var status = "<span style='color:red'>Suspend</span>";
                }
                return status;
            }
        },
        {
            data: 'action',
            orderable: false,
            render: function(data, type, row, meta) {                
                var link = "<a href='add/"+row['restaurant_id']+"'><img width='25px' height='25px' src='<?php echo base_url('/assets/img/edit.png'); ?>'></img><a>";
                return link;
            }
        }
    ],
    fnServerParams: function (data) {
        data["order"].forEach(function (items, index) {
            data["order"][index]["column"] = data["columns"][items.column]["name"];
        });
    },
});

function returnData()
{
    var searchAry             = {};
    // searchAry['booking_status']   = $("#booking_status").val();
    return searchAry;
}
</script>
