"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var TreeRegexp_1 = __importDefault(require("../src/TreeRegexp"));
var ParameterTypeRegistry_1 = __importDefault(require("../src/ParameterTypeRegistry"));
var Argument_1 = __importDefault(require("../src/Argument"));
var assert = __importStar(require("assert"));
describe('Argument', function () {
    it('exposes getParameterTypeName()', function () {
        var treeRegexp = new TreeRegexp_1.default('three (.*) mice');
        var parameterTypeRegistry = new ParameterTypeRegistry_1.default();
        var args = Argument_1.default.build(treeRegexp, 'three blind mice', [
            parameterTypeRegistry.lookupByTypeName('string'),
        ]);
        var argument = args[0];
        assert.strictEqual(argument.getParameterType().name, 'string');
    });
});
//# sourceMappingURL=ArgumentTest.js.map