'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var DefaultsList;
var DefaultsPage;
var DefaultsInstance;
var DefaultsContext;

/* jshint ignore:start */
/**
 * Initialize the DefaultsList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.DefaultsList
 *
 * @param {Twilio.Autopilot.V1} version - Version of the resource
 * @param {string} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 */
/* jshint ignore:end */
DefaultsList = function DefaultsList(version, assistantSid) {
  /* jshint ignore:start */
  /**
   * @function defaults
   * @memberof Twilio.Autopilot.V1.AssistantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Autopilot.V1.AssistantContext.DefaultsContext}
   */
  /* jshint ignore:end */
  function DefaultsListInstance(sid) {
    return DefaultsListInstance.get(sid);
  }

  DefaultsListInstance._version = version;
  // Path Solution
  DefaultsListInstance._solution = {assistantSid: assistantSid};
  /* jshint ignore:start */
  /**
   * Constructs a defaults
   *
   * @function get
   * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsList#
   *
   * @returns {Twilio.Autopilot.V1.AssistantContext.DefaultsContext}
   */
  /* jshint ignore:end */
  DefaultsListInstance.get = function get() {
    return new DefaultsContext(this._version, this._solution.assistantSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  DefaultsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  DefaultsListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return DefaultsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the DefaultsPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.DefaultsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {DefaultsSolution} solution - Path solution
 *
 * @returns DefaultsPage
 */
/* jshint ignore:end */
DefaultsPage = function DefaultsPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(DefaultsPage.prototype, Page.prototype);
DefaultsPage.prototype.constructor = DefaultsPage;

/* jshint ignore:start */
/**
 * Build an instance of DefaultsInstance
 *
 * @function getInstance
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsPage#
 *
 * @param {DefaultsPayload} payload - Payload response from the API
 *
 * @returns DefaultsInstance
 */
/* jshint ignore:end */
DefaultsPage.prototype.getInstance = function getInstance(payload) {
  return new DefaultsInstance(this._version, payload, this._solution.assistantSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
DefaultsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

DefaultsPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the DefaultsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.DefaultsInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 * @property {string} url - The absolute URL of the Defaults resource
 * @property {object} data - The JSON string that describes the default task links
 *
 * @param {V1} version - Version of the resource
 * @param {DefaultsPayload} payload - The instance payload
 * @param {sid} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 */
/* jshint ignore:end */
DefaultsInstance = function DefaultsInstance(version, payload, assistantSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.assistantSid = payload.assistant_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {assistantSid: assistantSid, };
};

Object.defineProperty(DefaultsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new DefaultsContext(this._version, this._solution.assistantSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a DefaultsInstance
 *
 * @function fetch
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed DefaultsInstance
 */
/* jshint ignore:end */
DefaultsInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a DefaultsInstance
 *
 * @function update
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.defaults] -
 *          A JSON string that describes the default task links.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed DefaultsInstance
 */
/* jshint ignore:end */
DefaultsInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
DefaultsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

DefaultsInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the DefaultsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.DefaultsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} assistantSid -
 *          The SID of the Assistant that is the parent of the resource to fetch
 */
/* jshint ignore:end */
DefaultsContext = function DefaultsContext(version, assistantSid) {
  this._version = version;

  // Path Solution
  this._solution = {assistantSid: assistantSid, };
  this._uri = `/Assistants/${assistantSid}/Defaults`;
};

/* jshint ignore:start */
/**
 * fetch a DefaultsInstance
 *
 * @function fetch
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed DefaultsInstance
 */
/* jshint ignore:end */
DefaultsContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new DefaultsInstance(this._version, payload, this._solution.assistantSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a DefaultsInstance
 *
 * @function update
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.defaults] -
 *          A JSON string that describes the default task links.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed DefaultsInstance
 */
/* jshint ignore:end */
DefaultsContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'Defaults': serialize.object(_.get(opts, 'defaults'))});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new DefaultsInstance(this._version, payload, this._solution.assistantSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.DefaultsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
DefaultsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

DefaultsContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  DefaultsList: DefaultsList,
  DefaultsPage: DefaultsPage,
  DefaultsInstance: DefaultsInstance,
  DefaultsContext: DefaultsContext
};
