/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the RestoreAssistantList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function RestoreAssistantList(version: V1): RestoreAssistantListInstance;

interface RestoreAssistantListInstance {
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a RestoreAssistantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: RestoreAssistantListInstanceUpdateOptions, callback?: (error: Error | null, items: RestoreAssistantListInstance) => any): Promise<RestoreAssistantInstance>;
}

/**
 * Options to pass to update
 *
 * @property assistant - The unique string that identifies the resource
 */
interface RestoreAssistantListInstanceUpdateOptions {
  assistant: string;
}

interface RestoreAssistantPayload extends RestoreAssistantResource, Page.TwilioResponsePayload {
}

interface RestoreAssistantResource {
  account_sid: string;
  callback_events: string;
  callback_url: string;
  date_created: Date;
  date_updated: Date;
  development_stage: string;
  friendly_name: string;
  latest_model_build_sid: string;
  log_queries: boolean;
  needs_model_build: boolean;
  sid: string;
  unique_name: string;
}

interface RestoreAssistantSolution {
}


declare class RestoreAssistantInstance extends SerializableClass {
  /**
   * Initialize the RestoreAssistantContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: RestoreAssistantPayload);

  accountSid: string;
  callbackEvents: string;
  callbackUrl: string;
  dateCreated: Date;
  dateUpdated: Date;
  developmentStage: string;
  friendlyName: string;
  latestModelBuildSid: string;
  logQueries: boolean;
  needsModelBuild: boolean;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
}


declare class RestoreAssistantPage extends Page<V1, RestoreAssistantPayload, RestoreAssistantResource, RestoreAssistantInstance> {
  /**
   * Initialize the RestoreAssistantPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: RestoreAssistantSolution);

  /**
   * Build an instance of RestoreAssistantInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: RestoreAssistantPayload): RestoreAssistantInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { RestoreAssistantInstance, RestoreAssistantList, RestoreAssistantListInstance, RestoreAssistantListInstanceUpdateOptions, RestoreAssistantPage, RestoreAssistantPayload, RestoreAssistantResource, RestoreAssistantSolution }
