/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type MediaRecordingFormat = 'mp4'|'webm';

type MediaRecordingOrder = 'asc'|'desc';

type MediaRecordingStatus = 'processing'|'completed'|'deleted'|'failed';

/**
 * Initialize the MediaRecordingList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function MediaRecordingList(version: V1): MediaRecordingListInstance;

interface MediaRecordingListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): MediaRecordingContext;
  /**
   * Streams MediaRecordingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: MediaRecordingInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams MediaRecordingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: MediaRecordingListInstanceEachOptions, callback?: (item: MediaRecordingInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a media_recording
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): MediaRecordingContext;
  /**
   * Retrieve a single target page of MediaRecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: MediaRecordingPage) => any): Promise<MediaRecordingPage>;
  /**
   * Retrieve a single target page of MediaRecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: MediaRecordingPage) => any): Promise<MediaRecordingPage>;
  /**
   * Lists MediaRecordingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: MediaRecordingInstance[]) => any): Promise<MediaRecordingInstance[]>;
  /**
   * Lists MediaRecordingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: MediaRecordingListInstanceOptions, callback?: (error: Error | null, items: MediaRecordingInstance[]) => any): Promise<MediaRecordingInstance[]>;
  /**
   * Retrieve a single page of MediaRecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: MediaRecordingPage) => any): Promise<MediaRecordingPage>;
  /**
   * Retrieve a single page of MediaRecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: MediaRecordingListInstancePageOptions, callback?: (error: Error | null, items: MediaRecordingPage) => any): Promise<MediaRecordingPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property order - The sort order of the list
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property processorSid - MediaProcessor to filter by
 * @property sourceSid - Source SID to filter by
 * @property status - Status to filter by
 */
interface MediaRecordingListInstanceEachOptions {
  callback?: (item: MediaRecordingInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  order?: MediaRecordingOrder;
  pageSize?: number;
  processorSid?: string;
  sourceSid?: string;
  status?: MediaRecordingStatus;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property order - The sort order of the list
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property processorSid - MediaProcessor to filter by
 * @property sourceSid - Source SID to filter by
 * @property status - Status to filter by
 */
interface MediaRecordingListInstanceOptions {
  limit?: number;
  order?: MediaRecordingOrder;
  pageSize?: number;
  processorSid?: string;
  sourceSid?: string;
  status?: MediaRecordingStatus;
}

/**
 * Options to pass to page
 *
 * @property order - The sort order of the list
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property processorSid - MediaProcessor to filter by
 * @property sourceSid - Source SID to filter by
 * @property status - Status to filter by
 */
interface MediaRecordingListInstancePageOptions {
  order?: MediaRecordingOrder;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  processorSid?: string;
  sourceSid?: string;
  status?: MediaRecordingStatus;
}

interface MediaRecordingPayload extends MediaRecordingResource, Page.TwilioResponsePayload {
}

interface MediaRecordingResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  duration: number;
  format: MediaRecordingFormat;
  links: string;
  media_size: number;
  processor_sid: string;
  resolution: string;
  sid: string;
  source_sid: string;
  status: MediaRecordingStatus;
  status_callback: string;
  status_callback_method: string;
  url: string;
}

interface MediaRecordingSolution {
}


declare class MediaRecordingContext {
  /**
   * Initialize the MediaRecordingContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a MediaRecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: MediaRecordingInstance) => any): Promise<MediaRecordingInstance>;
  /**
   * remove a MediaRecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: MediaRecordingInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class MediaRecordingInstance extends SerializableClass {
  /**
   * Initialize the MediaRecordingContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: MediaRecordingPayload, sid: string);

  private _proxy: MediaRecordingContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  duration: number;
  /**
   * fetch a MediaRecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: MediaRecordingInstance) => any): Promise<MediaRecordingInstance>;
  format: MediaRecordingFormat;
  links: string;
  mediaSize: number;
  processorSid: string;
  /**
   * remove a MediaRecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: MediaRecordingInstance) => any): Promise<boolean>;
  resolution: string;
  sid: string;
  sourceSid: string;
  status: MediaRecordingStatus;
  statusCallback: string;
  statusCallbackMethod: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class MediaRecordingPage extends Page<V1, MediaRecordingPayload, MediaRecordingResource, MediaRecordingInstance> {
  /**
   * Initialize the MediaRecordingPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: MediaRecordingSolution);

  /**
   * Build an instance of MediaRecordingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: MediaRecordingPayload): MediaRecordingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { MediaRecordingContext, MediaRecordingFormat, MediaRecordingInstance, MediaRecordingList, MediaRecordingListInstance, MediaRecordingListInstanceEachOptions, MediaRecordingListInstanceOptions, MediaRecordingListInstancePageOptions, MediaRecordingOrder, MediaRecordingPage, MediaRecordingPayload, MediaRecordingResource, MediaRecordingSolution, MediaRecordingStatus }
