/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the BrandsInformationList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function BrandsInformationList(version: TrustedComms): BrandsInformationListInstance;

/**
 * Options to pass to fetch
 *
 * @property ifNoneMatch - Standard `If-None-Match` HTTP header
 */
interface BrandsInformationInstanceFetchOptions {
  ifNoneMatch?: string;
}

interface BrandsInformationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BrandsInformationContext;
  /**
   * Constructs a brands_information
   */
  get(): BrandsInformationContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface BrandsInformationPayload extends BrandsInformationResource, Page.TwilioResponsePayload {
}

interface BrandsInformationResource {
  file_link: string;
  file_link_ttl_in_seconds: string;
  update_time: Date;
  url: string;
}

interface BrandsInformationSolution {
}


declare class BrandsInformationContext {
  /**
   * Initialize the BrandsInformationContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   */
  constructor(version: TrustedComms);

  /**
   * fetch a BrandsInformationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandsInformationInstance) => any): Promise<BrandsInformationInstance>;
  /**
   * fetch a BrandsInformationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: BrandsInformationInstanceFetchOptions, callback?: (error: Error | null, items: BrandsInformationInstance) => any): Promise<BrandsInformationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BrandsInformationInstance extends SerializableClass {
  /**
   * Initialize the BrandsInformationContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: TrustedComms, payload: BrandsInformationPayload);

  private _proxy: BrandsInformationContext;
  /**
   * fetch a BrandsInformationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandsInformationInstance) => any): Promise<BrandsInformationInstance>;
  /**
   * fetch a BrandsInformationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: BrandsInformationInstanceFetchOptions, callback?: (error: Error | null, items: BrandsInformationInstance) => any): Promise<BrandsInformationInstance>;
  fileLink: string;
  fileLinkTtlInSeconds: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  updateTime: Date;
  url: string;
}


declare class BrandsInformationPage extends Page<TrustedComms, BrandsInformationPayload, BrandsInformationResource, BrandsInformationInstance> {
  /**
   * Initialize the BrandsInformationPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: BrandsInformationSolution);

  /**
   * Build an instance of BrandsInformationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BrandsInformationPayload): BrandsInformationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BrandsInformationContext, BrandsInformationInstance, BrandsInformationInstanceFetchOptions, BrandsInformationList, BrandsInformationListInstance, BrandsInformationPage, BrandsInformationPayload, BrandsInformationResource, BrandsInformationSolution }
