'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var BucketList = require('./rateLimit/bucket').BucketList;
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var RateLimitList;
var RateLimitPage;
var RateLimitInstance;
var RateLimitContext;

/* jshint ignore:start */
/**
 * Initialize the RateLimitList
 *
 * @constructor Twilio.Verify.V2.ServiceContext.RateLimitList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
RateLimitList = function RateLimitList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function rateLimits
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.RateLimitContext}
   */
  /* jshint ignore:end */
  function RateLimitListInstance(sid) {
    return RateLimitListInstance.get(sid);
  }

  RateLimitListInstance._version = version;
  // Path Solution
  RateLimitListInstance._solution = {serviceSid: serviceSid};
  RateLimitListInstance._uri = `/Services/${serviceSid}/RateLimits`;
  /* jshint ignore:start */
  /**
   * create a RateLimitInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.uniqueName -
   *          A unique, developer assigned name of this Rate Limit.
   * @param {string} [opts.description] - Description of this Rate Limit
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed RateLimitInstance
   */
  /* jshint ignore:end */
  RateLimitListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['uniqueName'])) {
      throw new Error('Required parameter "opts[\'uniqueName\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'UniqueName': _.get(opts, 'uniqueName'),
      'Description': _.get(opts, 'description')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RateLimitInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams RateLimitInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  RateLimitListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists RateLimitInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RateLimitListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of RateLimitInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RateLimitListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RateLimitPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of RateLimitInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RateLimitListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new RateLimitPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a rate_limit
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Verify.V2.ServiceContext.RateLimitContext}
   */
  /* jshint ignore:end */
  RateLimitListInstance.get = function get(sid) {
    return new RateLimitContext(this._version, this._solution.serviceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.RateLimitList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RateLimitListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RateLimitListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RateLimitListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RateLimitPage
 *
 * @constructor Twilio.Verify.V2.ServiceContext.RateLimitPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RateLimitSolution} solution - Path solution
 *
 * @returns RateLimitPage
 */
/* jshint ignore:end */
RateLimitPage = function RateLimitPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RateLimitPage.prototype, Page.prototype);
RateLimitPage.prototype.constructor = RateLimitPage;

/* jshint ignore:start */
/**
 * Build an instance of RateLimitInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitPage#
 *
 * @param {RateLimitPayload} payload - Payload response from the API
 *
 * @returns RateLimitInstance
 */
/* jshint ignore:end */
RateLimitPage.prototype.getInstance = function getInstance(payload) {
  return new RateLimitInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RateLimitPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RateLimitPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RateLimitContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.RateLimitInstance
 *
 * @property {string} sid - A string that uniquely identifies this Rate Limit.
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} uniqueName -
 *          A unique, developer assigned name of this Rate Limit.
 * @property {string} description - Description of this Rate Limit
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} url - The URL of this resource.
 * @property {string} links - The URLs of related resources
 *
 * @param {V2} version - Version of the resource
 * @param {RateLimitPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RateLimitInstance = function RateLimitInstance(version, payload, serviceSid,
                                                sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, sid: sid || this.sid, };
};

Object.defineProperty(RateLimitInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RateLimitContext(this._version, this._solution.serviceSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a RateLimitInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.description] - Description of this Rate Limit
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a RateLimitInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a RateLimitInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the buckets
 *
 * @function buckets
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitInstance#
 *
 * @returns {Twilio.Verify.V2.ServiceContext.RateLimitContext.BucketList}
 */
/* jshint ignore:end */
RateLimitInstance.prototype.buckets = function buckets() {
  return this._proxy.buckets;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RateLimitInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RateLimitInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RateLimitContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.RateLimitContext
 *
 * @property {Twilio.Verify.V2.ServiceContext.RateLimitContext.BucketList} buckets -
 *          buckets resource
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RateLimitContext = function RateLimitContext(version, serviceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, sid: sid, };
  this._uri = `/Services/${serviceSid}/RateLimits/${sid}`;

  // Dependents
  this._buckets = undefined;
};

/* jshint ignore:start */
/**
 * update a RateLimitInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.description] - Description of this Rate Limit
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'Description': _.get(opts, 'description')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new RateLimitInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a RateLimitInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RateLimitInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a RateLimitInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RateLimitInstance
 */
/* jshint ignore:end */
RateLimitContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(RateLimitContext.prototype,
  'buckets', {
    get: function() {
      if (!this._buckets) {
        this._buckets = new BucketList(this._version, this._solution.serviceSid, this._solution.sid);
      }
      return this._buckets;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.RateLimitContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RateLimitContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RateLimitContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RateLimitList: RateLimitList,
  RateLimitPage: RateLimitPage,
  RateLimitInstance: RateLimitInstance,
  RateLimitContext: RateLimitContext
};
