/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the CompositionSettingsList
 *
 * @param version - Version of the resource
 */
declare function CompositionSettingsList(version: V1): CompositionSettingsListInstance;

/**
 * Options to pass to create
 *
 * @property awsCredentialsSid - The SID of the stored Credential resource
 * @property awsS3Url - The URL of the AWS S3 bucket where the compositions should be stored
 * @property awsStorageEnabled - Whether all compositions should be written to the aws_s3_url
 * @property encryptionEnabled - Whether all compositions should be stored in an encrypted form
 * @property encryptionKeySid - The SID of the Public Key resource to use for encryption
 * @property friendlyName - A descriptive string that you create to describe the resource
 */
interface CompositionSettingsInstanceCreateOptions {
  awsCredentialsSid?: string;
  awsS3Url?: string;
  awsStorageEnabled?: boolean;
  encryptionEnabled?: boolean;
  encryptionKeySid?: string;
  friendlyName: string;
}

interface CompositionSettingsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CompositionSettingsContext;
  /**
   * Constructs a composition_settings
   */
  get(): CompositionSettingsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface CompositionSettingsPayload extends CompositionSettingsResource, Page.TwilioResponsePayload {
}

interface CompositionSettingsResource {
  account_sid: string;
  aws_credentials_sid: string;
  aws_s3_url: string;
  aws_storage_enabled: boolean;
  encryption_enabled: boolean;
  encryption_key_sid: string;
  friendly_name: string;
  url: string;
}

interface CompositionSettingsSolution {
}


declare class CompositionSettingsContext {
  /**
   * Initialize the CompositionSettingsContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * create a CompositionSettingsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CompositionSettingsInstanceCreateOptions, callback?: (error: Error | null, item: CompositionSettingsInstance) => any): Promise<CompositionSettingsInstance>;
  /**
   * fetch a CompositionSettingsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CompositionSettingsInstance) => any): Promise<CompositionSettingsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CompositionSettingsInstance extends SerializableClass {
  /**
   * Initialize the CompositionSettingsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: CompositionSettingsPayload);

  private _proxy: CompositionSettingsContext;
  accountSid: string;
  awsCredentialsSid: string;
  awsS3Url: string;
  awsStorageEnabled: boolean;
  /**
   * create a CompositionSettingsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CompositionSettingsInstanceCreateOptions, callback?: (error: Error | null, items: CompositionSettingsInstance) => any): Promise<CompositionSettingsInstance>;
  encryptionEnabled: boolean;
  encryptionKeySid: string;
  /**
   * fetch a CompositionSettingsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CompositionSettingsInstance) => any): Promise<CompositionSettingsInstance>;
  friendlyName: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class CompositionSettingsPage extends Page<V1, CompositionSettingsPayload, CompositionSettingsResource, CompositionSettingsInstance> {
  /**
   * Initialize the CompositionSettingsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CompositionSettingsSolution);

  /**
   * Build an instance of CompositionSettingsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CompositionSettingsPayload): CompositionSettingsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CompositionSettingsContext, CompositionSettingsInstance, CompositionSettingsInstanceCreateOptions, CompositionSettingsList, CompositionSettingsListInstance, CompositionSettingsPage, CompositionSettingsPayload, CompositionSettingsResource, CompositionSettingsSolution }
