/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { ConnectionPolicyTargetList } from './connectionPolicy/connectionPolicyTarget';
import { ConnectionPolicyTargetListInstance } from './connectionPolicy/connectionPolicyTarget';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ConnectionPolicyList
 *
 * @param version - Version of the resource
 */
declare function ConnectionPolicyList(version: V1): ConnectionPolicyListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - A string to describe the resource
 */
interface ConnectionPolicyInstanceUpdateOptions {
  friendlyName?: string;
}

interface ConnectionPolicyListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ConnectionPolicyContext;
  /**
   * create a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  /**
   * create a ConnectionPolicyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ConnectionPolicyListInstanceCreateOptions, callback?: (error: Error | null, item: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  /**
   * Streams ConnectionPolicyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ConnectionPolicyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ConnectionPolicyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ConnectionPolicyListInstanceEachOptions, callback?: (item: ConnectionPolicyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a connection_policy
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): ConnectionPolicyContext;
  /**
   * Retrieve a single target page of ConnectionPolicyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ConnectionPolicyPage) => any): Promise<ConnectionPolicyPage>;
  /**
   * Retrieve a single target page of ConnectionPolicyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ConnectionPolicyPage) => any): Promise<ConnectionPolicyPage>;
  /**
   * Lists ConnectionPolicyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ConnectionPolicyInstance[]) => any): Promise<ConnectionPolicyInstance[]>;
  /**
   * Lists ConnectionPolicyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ConnectionPolicyListInstanceOptions, callback?: (error: Error | null, items: ConnectionPolicyInstance[]) => any): Promise<ConnectionPolicyInstance[]>;
  /**
   * Retrieve a single page of ConnectionPolicyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ConnectionPolicyPage) => any): Promise<ConnectionPolicyPage>;
  /**
   * Retrieve a single page of ConnectionPolicyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ConnectionPolicyListInstancePageOptions, callback?: (error: Error | null, items: ConnectionPolicyPage) => any): Promise<ConnectionPolicyPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - A string to describe the resource
 */
interface ConnectionPolicyListInstanceCreateOptions {
  friendlyName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ConnectionPolicyListInstanceEachOptions {
  callback?: (item: ConnectionPolicyInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ConnectionPolicyListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ConnectionPolicyListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ConnectionPolicyPayload extends ConnectionPolicyResource, Page.TwilioResponsePayload {
}

interface ConnectionPolicyResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  links: string;
  sid: string;
  url: string;
}

interface ConnectionPolicySolution {
}


declare class ConnectionPolicyContext {
  /**
   * Initialize the ConnectionPolicyContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  /**
   * remove a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<boolean>;
  targets: ConnectionPolicyTargetListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  /**
   * update a ConnectionPolicyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConnectionPolicyInstanceUpdateOptions, callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
}


declare class ConnectionPolicyInstance extends SerializableClass {
  /**
   * Initialize the ConnectionPolicyContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: ConnectionPolicyPayload, sid: string);

  private _proxy: ConnectionPolicyContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  friendlyName: string;
  links: string;
  /**
   * remove a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Access the targets
   */
  targets(): ConnectionPolicyTargetListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConnectionPolicyInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  /**
   * update a ConnectionPolicyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConnectionPolicyInstanceUpdateOptions, callback?: (error: Error | null, items: ConnectionPolicyInstance) => any): Promise<ConnectionPolicyInstance>;
  url: string;
}


declare class ConnectionPolicyPage extends Page<V1, ConnectionPolicyPayload, ConnectionPolicyResource, ConnectionPolicyInstance> {
  /**
   * Initialize the ConnectionPolicyPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ConnectionPolicySolution);

  /**
   * Build an instance of ConnectionPolicyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ConnectionPolicyPayload): ConnectionPolicyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ConnectionPolicyContext, ConnectionPolicyInstance, ConnectionPolicyInstanceUpdateOptions, ConnectionPolicyList, ConnectionPolicyListInstance, ConnectionPolicyListInstanceCreateOptions, ConnectionPolicyListInstanceEachOptions, ConnectionPolicyListInstanceOptions, ConnectionPolicyListInstancePageOptions, ConnectionPolicyPage, ConnectionPolicyPayload, ConnectionPolicyResource, ConnectionPolicySolution }
