const { app, BrowserWindow } = require('electron');

function createWindow () {

  const window = new BrowserWindow({

    width: 1600,

    height: 900,

    webPreferences: {

      nodeIntegration: true

    }

  });

  window.loadFile('index.html');

}

app.whenReady().then(createWindow);

const {ipcMain} = require('electron')

// receive message from index.html 
ipcMain.on('asynchronous-message', (event, arg) => {
  console.log( arg );
  
  // send message to index.html
  event.sender.send('asynchronous-reply', 'hello' );
  });


// const { app, BrowserWindow } = require("electron");
// const url = require("url");

// function newApp() {
//   win = new BrowserWindow();
//   win.loadURL(
//     url.format({
//       pathname: "index.html",
//       slashes: true
//     })
//   );
// }

// app.on("ready", newApp);