"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@js-joda/core");

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = _core.LocalDate.ofYearDay(1, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DateTimeOffset = {
  id: 0x2B,
  type: 'DATETIMEOFFSETN',
  name: 'DateTimeOffset',
  declaration: function (parameter) {
    return 'datetimeoffset(' + this.resolveScale(parameter) + ')';
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else if (parameter.value === null) {
      return 0;
    } else {
      return 7;
    }
  },

  generateTypeInfo(parameter) {
    return Buffer.from([this.id, parameter.scale]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        return Buffer.from([0x08]);

      case 3:
      case 4:
        return Buffer.from([0x09]);

      case 5:
      case 6:
      case 7:
        return Buffer.from([0x0A]);

      default:
        throw new Error('invalid scale');
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value;
    let scale = parameter.scale;
    const buffer = new _writableTrackingBuffer.default(16);
    scale = scale;
    let timestamp;
    timestamp = ((value.getUTCHours() * 60 + value.getUTCMinutes()) * 60 + value.getUTCSeconds()) * 1000 + value.getMilliseconds();
    timestamp = timestamp * Math.pow(10, scale - 3);
    timestamp += (value.nanosecondDelta != null ? value.nanosecondDelta : 0) * Math.pow(10, scale);
    timestamp = Math.round(timestamp);

    switch (scale) {
      case 0:
      case 1:
      case 2:
        buffer.writeUInt24LE(timestamp);
        break;

      case 3:
      case 4:
        buffer.writeUInt32LE(timestamp);
        break;

      case 5:
      case 6:
      case 7:
        buffer.writeUInt40LE(timestamp);
    }

    const date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());

    const days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    buffer.writeUInt24LE(days);
    const offset = -value.getTimezoneOffset();
    buffer.writeInt16LE(offset);
    yield buffer.data;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = DateTimeOffset;
exports.default = _default;
module.exports = DateTimeOffset;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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