"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x04]);
const Int = {
  id: 0x38,
  type: 'INT4',
  name: 'Int',
  declaration: function () {
    return 'int';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(Number(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < -2147483648 || value > 2147483647) {
      throw new TypeError('Value must be between -2147483648 and 2147483647, inclusive.');
    }

    return value | 0;
  }
};
var _default = Int;
exports.default = _default;
module.exports = Int;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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