"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _metadataParser = _interopRequireDefault(require("../metadata-parser"));

var _token = require("./token");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function readTableName(parser, options, metadata, callback) {
  if (metadata.type.hasTableName) {
    if (options.tdsVersion >= '7_2') {
      parser.readUInt8(numberOfTableNameParts => {
        const tableName = [];
        let i = 0;

        function next(done) {
          if (numberOfTableNameParts === i) {
            return done();
          }

          parser.readUsVarChar(part => {
            tableName.push(part);
            i++;
            next(done);
          });
        }

        next(() => {
          callback(tableName);
        });
      });
    } else {
      parser.readUsVarChar(callback);
    }
  } else {
    callback(undefined);
  }
}

function readColumnName(parser, options, index, metadata, callback) {
  parser.readBVarChar(colName => {
    if (options.columnNameReplacer) {
      callback(options.columnNameReplacer(colName, index, metadata));
    } else if (options.camelCaseColumns) {
      callback(colName.replace(/^[A-Z]/, function (s) {
        return s.toLowerCase();
      }));
    } else {
      callback(colName);
    }
  });
}

function readColumn(parser, options, index, callback) {
  (0, _metadataParser.default)(parser, options, metadata => {
    readTableName(parser, options, metadata, tableName => {
      readColumnName(parser, options, index, metadata, colName => {
        callback({
          userType: metadata.userType,
          flags: metadata.flags,
          type: metadata.type,
          collation: metadata.collation,
          precision: metadata.precision,
          scale: metadata.scale,
          udtInfo: metadata.udtInfo,
          dataLength: metadata.dataLength,
          schema: metadata.schema,
          colName: colName,
          tableName: tableName
        });
      });
    });
  });
}

async function colMetadataParser(parser) {
  while (parser.buffer.length - parser.position < 2) {
    await parser.streamBuffer.waitForChunk();
  }

  const columnCount = parser.buffer.readUInt16LE(parser.position);
  parser.position += 2;
  const columns = [];

  for (let i = 0; i < columnCount; i++) {
    let column;
    readColumn(parser, parser.options, i, c => {
      column = c;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push(column);
  }

  return new _token.ColMetadataToken(columns);
}

var _default = colMetadataParser;
exports.default = _default;
module.exports = colMetadataParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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