/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ValidationRequestList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 */
declare function ValidationRequestList(version: V2010, accountSid: string): ValidationRequestListInstance;

interface ValidationRequestListInstance {
  /**
   * create a ValidationRequestInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ValidationRequestListInstanceCreateOptions, callback?: (error: Error | null, item: ValidationRequestInstance) => any): Promise<ValidationRequestInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property callDelay - The number of seconds to delay before initiating the verification call
 * @property extension - The digits to dial after connecting the verification call
 * @property friendlyName - A string to describe the resource
 * @property phoneNumber - The phone number to verify in E.164 format
 * @property statusCallback - The URL we should call to send status information to your application
 * @property statusCallbackMethod - The HTTP method we should use to call status_callback
 */
interface ValidationRequestListInstanceCreateOptions {
  callDelay?: number;
  extension?: string;
  friendlyName?: string;
  phoneNumber: string;
  statusCallback?: string;
  statusCallbackMethod?: string;
}

interface ValidationRequestPayload extends ValidationRequestResource, Page.TwilioResponsePayload {
}

interface ValidationRequestResource {
  account_sid: string;
  call_sid: string;
  friendly_name: string;
  phone_number: string;
  validation_code: string;
}

interface ValidationRequestSolution {
  accountSid?: string;
}


declare class ValidationRequestInstance extends SerializableClass {
  /**
   * Initialize the ValidationRequestContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   */
  constructor(version: V2010, payload: ValidationRequestPayload, accountSid: string);

  accountSid: string;
  callSid: string;
  friendlyName: string;
  phoneNumber: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  validationCode: string;
}


declare class ValidationRequestPage extends Page<V2010, ValidationRequestPayload, ValidationRequestResource, ValidationRequestInstance> {
  /**
   * Initialize the ValidationRequestPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: ValidationRequestSolution);

  /**
   * Build an instance of ValidationRequestInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ValidationRequestPayload): ValidationRequestInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ValidationRequestInstance, ValidationRequestList, ValidationRequestListInstance, ValidationRequestListInstanceCreateOptions, ValidationRequestPage, ValidationRequestPayload, ValidationRequestResource, ValidationRequestSolution }
