/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V3 = require('../V3');
import { SerializableClass } from '../../../interfaces';

type ChannelChannelType = 'public'|'private';

type ChannelWebhookEnabledType = 'true'|'false';

/**
 * Initialize the ChannelList
 *
 * @param version - Version of the resource
 */
declare function ChannelList(version: V3): ChannelListInstance;

/**
 * Options to pass to update
 *
 * @property messagingServiceSid - The unique ID of the Messaging Service this channel belongs to.
 * @property type - The Type for this Channel to migrate to.
 * @property xTwilioWebhookEnabled - The X-Twilio-Webhook-Enabled HTTP request header
 */
interface ChannelInstanceUpdateOptions {
  messagingServiceSid?: string;
  type?: ChannelChannelType;
  xTwilioWebhookEnabled?: ChannelWebhookEnabledType;
}

interface ChannelListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ChannelContext;
  /**
   * Constructs a channel
   *
   * @param serviceSid - Service Sid.
   * @param sid - A string that uniquely identifies this Channel.
   */
  get(serviceSid: string, sid: string): ChannelContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ChannelPayload extends ChannelResource, Page.TwilioResponsePayload {
}

interface ChannelResource {
  account_sid: string;
  attributes: string;
  created_by: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  members_count: number;
  messages_count: number;
  messaging_service_sid: string;
  service_sid: string;
  sid: string;
  type: ChannelChannelType;
  unique_name: string;
  url: string;
}

interface ChannelSolution {
}


declare class ChannelContext {
  /**
   * Initialize the ChannelContext
   *
   * @param version - Version of the resource
   * @param serviceSid - Service Sid.
   * @param sid - A string that uniquely identifies this Channel.
   */
  constructor(version: V3, serviceSid: string, sid: string);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ChannelInstance) => any): Promise<ChannelInstance>;
  /**
   * update a ChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ChannelInstanceUpdateOptions, callback?: (error: Error | null, items: ChannelInstance) => any): Promise<ChannelInstance>;
}


declare class ChannelInstance extends SerializableClass {
  /**
   * Initialize the ChannelContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - Service Sid.
   * @param sid - A string that uniquely identifies this Channel.
   */
  constructor(version: V3, payload: ChannelPayload, serviceSid: string, sid: string);

  private _proxy: ChannelContext;
  accountSid: string;
  attributes: string;
  createdBy: string;
  dateCreated: Date;
  dateUpdated: Date;
  friendlyName: string;
  membersCount: number;
  messagesCount: number;
  messagingServiceSid: string;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  type: ChannelChannelType;
  uniqueName: string;
  /**
   * update a ChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ChannelInstance) => any): Promise<ChannelInstance>;
  /**
   * update a ChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ChannelInstanceUpdateOptions, callback?: (error: Error | null, items: ChannelInstance) => any): Promise<ChannelInstance>;
  url: string;
}


declare class ChannelPage extends Page<V3, ChannelPayload, ChannelResource, ChannelInstance> {
  /**
   * Initialize the ChannelPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V3, response: Response<string>, solution: ChannelSolution);

  /**
   * Build an instance of ChannelInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ChannelPayload): ChannelInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ChannelChannelType, ChannelContext, ChannelInstance, ChannelInstanceUpdateOptions, ChannelList, ChannelListInstance, ChannelPage, ChannelPayload, ChannelResource, ChannelSolution, ChannelWebhookEnabledType }
