/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the DeactivationsList
 *
 * @param version - Version of the resource
 */
declare function DeactivationsList(version: V1): DeactivationsListInstance;

/**
 * Options to pass to fetch
 *
 * @property date - The date to retrieve deactivated numbers for.
 */
interface DeactivationsInstanceFetchOptions {
  date?: Date;
}

interface DeactivationsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): DeactivationsContext;
  /**
   * Constructs a deactivations
   */
  get(): DeactivationsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface DeactivationsPayload extends DeactivationsResource, Page.TwilioResponsePayload {
}

interface DeactivationsResource {
  redirect_to: string;
}

interface DeactivationsSolution {
}


declare class DeactivationsContext {
  /**
   * Initialize the DeactivationsContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * fetch a DeactivationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DeactivationsInstance) => any): Promise<DeactivationsInstance>;
  /**
   * fetch a DeactivationsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: DeactivationsInstanceFetchOptions, callback?: (error: Error | null, items: DeactivationsInstance) => any): Promise<DeactivationsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class DeactivationsInstance extends SerializableClass {
  /**
   * Initialize the DeactivationsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: DeactivationsPayload);

  private _proxy: DeactivationsContext;
  /**
   * fetch a DeactivationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DeactivationsInstance) => any): Promise<DeactivationsInstance>;
  /**
   * fetch a DeactivationsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: DeactivationsInstanceFetchOptions, callback?: (error: Error | null, items: DeactivationsInstance) => any): Promise<DeactivationsInstance>;
  redirectTo: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class DeactivationsPage extends Page<V1, DeactivationsPayload, DeactivationsResource, DeactivationsInstance> {
  /**
   * Initialize the DeactivationsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: DeactivationsSolution);

  /**
   * Build an instance of DeactivationsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: DeactivationsPayload): DeactivationsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { DeactivationsContext, DeactivationsInstance, DeactivationsInstanceFetchOptions, DeactivationsList, DeactivationsListInstance, DeactivationsPage, DeactivationsPayload, DeactivationsResource, DeactivationsSolution }
