/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the UsAppToPersonUsecaseList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param messagingServiceSid - The unique string that identifies the resource
 */
declare function UsAppToPersonUsecaseList(version: V1, messagingServiceSid: string): UsAppToPersonUsecaseListInstance;

interface UsAppToPersonUsecaseListInstance {
  /**
   * fetch a UsAppToPersonUsecaseInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UsAppToPersonUsecaseListInstance) => any): Promise<UsAppToPersonUsecaseInstance>;
  /**
   * fetch a UsAppToPersonUsecaseInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: UsAppToPersonUsecaseListInstanceFetchOptions, callback?: (error: Error | null, items: UsAppToPersonUsecaseListInstance) => any): Promise<UsAppToPersonUsecaseInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to fetch
 *
 * @property brandRegistrationSid - A2P Brand Registration SID
 */
interface UsAppToPersonUsecaseListInstanceFetchOptions {
  brandRegistrationSid?: string;
}

interface UsAppToPersonUsecasePayload extends UsAppToPersonUsecaseResource, Page.TwilioResponsePayload {
}

interface UsAppToPersonUsecaseResource {
  us_app_to_person_usecases: object[];
}

interface UsAppToPersonUsecaseSolution {
  messagingServiceSid?: string;
}


declare class UsAppToPersonUsecaseInstance extends SerializableClass {
  /**
   * Initialize the UsAppToPersonUsecaseContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param messagingServiceSid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: UsAppToPersonUsecasePayload, messagingServiceSid: string);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  usAppToPersonUsecases: object[];
}


declare class UsAppToPersonUsecasePage extends Page<V1, UsAppToPersonUsecasePayload, UsAppToPersonUsecaseResource, UsAppToPersonUsecaseInstance> {
  /**
   * Initialize the UsAppToPersonUsecasePage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UsAppToPersonUsecaseSolution);

  /**
   * Build an instance of UsAppToPersonUsecaseInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UsAppToPersonUsecasePayload): UsAppToPersonUsecaseInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UsAppToPersonUsecaseInstance, UsAppToPersonUsecaseList, UsAppToPersonUsecaseListInstance, UsAppToPersonUsecaseListInstanceFetchOptions, UsAppToPersonUsecasePage, UsAppToPersonUsecasePayload, UsAppToPersonUsecaseResource, UsAppToPersonUsecaseSolution }
