/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import DeployedDevices = require('../../DeployedDevices');
import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the CertificateList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param fleetSid - The unique identifier of the Fleet.
 */
declare function CertificateList(version: DeployedDevices, fleetSid: string): CertificateListInstance;

/**
 * Options to pass to update
 *
 * @property deviceSid - The unique identifier of a Device to be authenticated.
 * @property friendlyName - The human readable description for this Certificate.
 */
interface CertificateInstanceUpdateOptions {
  deviceSid?: string;
  friendlyName?: string;
}

interface CertificateListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CertificateContext;
  /**
   * create a CertificateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CertificateListInstanceCreateOptions, callback?: (error: Error | null, item: CertificateInstance) => any): Promise<CertificateInstance>;
  /**
   * Streams CertificateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: CertificateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams CertificateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: CertificateListInstanceEachOptions, callback?: (item: CertificateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a certificate
   *
   * @param sid - A string that uniquely identifies the Certificate.
   */
  get(sid: string): CertificateContext;
  /**
   * Retrieve a single target page of CertificateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: CertificatePage) => any): Promise<CertificatePage>;
  /**
   * Retrieve a single target page of CertificateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: CertificatePage) => any): Promise<CertificatePage>;
  /**
   * Lists CertificateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: CertificateInstance[]) => any): Promise<CertificateInstance[]>;
  /**
   * Lists CertificateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: CertificateListInstanceOptions, callback?: (error: Error | null, items: CertificateInstance[]) => any): Promise<CertificateInstance[]>;
  /**
   * Retrieve a single page of CertificateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: CertificatePage) => any): Promise<CertificatePage>;
  /**
   * Retrieve a single page of CertificateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: CertificateListInstancePageOptions, callback?: (error: Error | null, items: CertificatePage) => any): Promise<CertificatePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property certificateData - The public certificate data.
 * @property deviceSid - The unique identifier of a Device to be authenticated.
 * @property friendlyName - The human readable description for this Certificate.
 */
interface CertificateListInstanceCreateOptions {
  certificateData: string;
  deviceSid?: string;
  friendlyName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property deviceSid - Find all Certificates authenticating specified Device.
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface CertificateListInstanceEachOptions {
  callback?: (item: CertificateInstance, done: (err?: Error) => void) => void;
  deviceSid?: string;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property deviceSid - Find all Certificates authenticating specified Device.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface CertificateListInstanceOptions {
  deviceSid?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property deviceSid - Find all Certificates authenticating specified Device.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface CertificateListInstancePageOptions {
  deviceSid?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface CertificatePayload extends CertificateResource, Page.TwilioResponsePayload {
}

interface CertificateResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  device_sid: string;
  fleet_sid: string;
  friendly_name: string;
  sid: string;
  thumbprint: string;
  url: string;
}

interface CertificateSolution {
  fleetSid?: string;
}


declare class CertificateContext {
  /**
   * Initialize the CertificateContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param fleetSid - The fleet_sid
   * @param sid - A string that uniquely identifies the Certificate.
   */
  constructor(version: DeployedDevices, fleetSid: string, sid: string);

  /**
   * fetch a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
  /**
   * remove a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
  /**
   * update a CertificateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: CertificateInstanceUpdateOptions, callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
}


declare class CertificateInstance extends SerializableClass {
  /**
   * Initialize the CertificateContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param fleetSid - The unique identifier of the Fleet.
   * @param sid - A string that uniquely identifies the Certificate.
   */
  constructor(version: DeployedDevices, payload: CertificatePayload, fleetSid: string, sid: string);

  private _proxy: CertificateContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  deviceSid: string;
  /**
   * fetch a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
  fleetSid: string;
  friendlyName: string;
  /**
   * remove a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<boolean>;
  sid: string;
  thumbprint: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a CertificateInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
  /**
   * update a CertificateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: CertificateInstanceUpdateOptions, callback?: (error: Error | null, items: CertificateInstance) => any): Promise<CertificateInstance>;
  url: string;
}


declare class CertificatePage extends Page<DeployedDevices, CertificatePayload, CertificateResource, CertificateInstance> {
  /**
   * Initialize the CertificatePage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: DeployedDevices, response: Response<string>, solution: CertificateSolution);

  /**
   * Build an instance of CertificateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CertificatePayload): CertificateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CertificateContext, CertificateInstance, CertificateInstanceUpdateOptions, CertificateList, CertificateListInstance, CertificateListInstanceCreateOptions, CertificateListInstanceEachOptions, CertificateListInstanceOptions, CertificateListInstancePageOptions, CertificatePage, CertificatePayload, CertificateResource, CertificateSolution }
