/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { CountryListInstance } from './voice/country';
import { NumberListInstance } from './voice/number';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the VoiceList
 *
 * @param version - Version of the resource
 */
declare function VoiceList(version: V1): VoiceListInstance;

interface VoiceListInstance {
  countries?: CountryListInstance;
  numbers?: NumberListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface VoicePayload extends VoiceResource, Page.TwilioResponsePayload {
}

interface VoiceResource {
  links: string;
  name: string;
  url: string;
}

interface VoiceSolution {
}


declare class VoiceInstance extends SerializableClass {
  /**
   * Initialize the VoiceContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: VoicePayload);

  links: string;
  name: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class VoicePage extends Page<V1, VoicePayload, VoiceResource, VoiceInstance> {
  /**
   * Initialize the VoicePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: VoiceSolution);

  /**
   * Build an instance of VoiceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: VoicePayload): VoiceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { VoiceInstance, VoiceList, VoiceListInstance, VoicePage, VoicePayload, VoiceResource, VoiceSolution }
