/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

type LogLevel = 'info'|'warn'|'error';

/**
 * Initialize the LogList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the Log resource is associated with
 * @param environmentSid - The SID of the environment in which the log occurred
 */
declare function LogList(version: V1, serviceSid: string, environmentSid: string): LogListInstance;

interface LogListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): LogContext;
  /**
   * Streams LogInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: LogInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams LogInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: LogListInstanceEachOptions, callback?: (item: LogInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a log
   *
   * @param sid - The SID that identifies the Log resource to fetch
   */
  get(sid: string): LogContext;
  /**
   * Retrieve a single target page of LogInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: LogPage) => any): Promise<LogPage>;
  /**
   * Retrieve a single target page of LogInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: LogPage) => any): Promise<LogPage>;
  /**
   * Lists LogInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: LogInstance[]) => any): Promise<LogInstance[]>;
  /**
   * Lists LogInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: LogListInstanceOptions, callback?: (error: Error | null, items: LogInstance[]) => any): Promise<LogInstance[]>;
  /**
   * Retrieve a single page of LogInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: LogPage) => any): Promise<LogPage>;
  /**
   * Retrieve a single page of LogInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: LogListInstancePageOptions, callback?: (error: Error | null, items: LogPage) => any): Promise<LogPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property endDate - The date and time before which the Log resource must have been created.
 * @property functionSid - The SID of the function whose invocation produced the Log resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property startDate - The date and time after which the Log resources must have been created.
 */
interface LogListInstanceEachOptions {
  callback?: (item: LogInstance, done: (err?: Error) => void) => void;
  done?: Function;
  endDate?: Date;
  functionSid?: string;
  limit?: number;
  pageSize?: number;
  startDate?: Date;
}

/**
 * Options to pass to list
 *
 * @property endDate - The date and time before which the Log resource must have been created.
 * @property functionSid - The SID of the function whose invocation produced the Log resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property startDate - The date and time after which the Log resources must have been created.
 */
interface LogListInstanceOptions {
  endDate?: Date;
  functionSid?: string;
  limit?: number;
  pageSize?: number;
  startDate?: Date;
}

/**
 * Options to pass to page
 *
 * @property endDate - The date and time before which the Log resource must have been created.
 * @property functionSid - The SID of the function whose invocation produced the Log resources to read
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property startDate - The date and time after which the Log resources must have been created.
 */
interface LogListInstancePageOptions {
  endDate?: Date;
  functionSid?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  startDate?: Date;
}

interface LogPayload extends LogResource, Page.TwilioResponsePayload {
}

interface LogResource {
  account_sid: string;
  build_sid: string;
  date_created: Date;
  deployment_sid: string;
  environment_sid: string;
  function_sid: string;
  level: LogLevel;
  message: string;
  request_sid: string;
  service_sid: string;
  sid: string;
  url: string;
}

interface LogSolution {
  environmentSid?: string;
  serviceSid?: string;
}


declare class LogContext {
  /**
   * Initialize the LogContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service to fetch the Log resource from
   * @param environmentSid - The SID of the environment with the Log resource to fetch
   * @param sid - The SID that identifies the Log resource to fetch
   */
  constructor(version: V1, serviceSid: string, environmentSid: string, sid: string);

  /**
   * fetch a LogInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: LogInstance) => any): Promise<LogInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class LogInstance extends SerializableClass {
  /**
   * Initialize the LogContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the Log resource is associated with
   * @param environmentSid - The SID of the environment in which the log occurred
   * @param sid - The SID that identifies the Log resource to fetch
   */
  constructor(version: V1, payload: LogPayload, serviceSid: string, environmentSid: string, sid: string);

  private _proxy: LogContext;
  accountSid: string;
  buildSid: string;
  dateCreated: Date;
  deploymentSid: string;
  environmentSid: string;
  /**
   * fetch a LogInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: LogInstance) => any): Promise<LogInstance>;
  functionSid: string;
  level: LogLevel;
  message: string;
  requestSid: string;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class LogPage extends Page<V1, LogPayload, LogResource, LogInstance> {
  /**
   * Initialize the LogPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: LogSolution);

  /**
   * Build an instance of LogInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: LogPayload): LogInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { LogContext, LogInstance, LogLevel, LogList, LogListInstance, LogListInstanceEachOptions, LogListInstanceOptions, LogListInstancePageOptions, LogPage, LogPayload, LogResource, LogSolution }
