'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../../../base/values');  /* jshint ignore:line */

var StepContextList;
var StepContextPage;
var StepContextInstance;
var StepContextContext;

/* jshint ignore:start */
/**
 * Initialize the StepContextList
 *
 * @constructor Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextList
 *
 * @param {Twilio.Studio.V1} version - Version of the resource
 * @param {string} flowSid - The SID of the Flow
 * @param {string} engagementSid - The SID of the Engagement
 * @param {string} stepSid - Step SID
 */
/* jshint ignore:end */
StepContextList = function StepContextList(version, flowSid, engagementSid,
                                            stepSid) {
  /* jshint ignore:start */
  /**
   * @function stepContext
   * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextContext}
   */
  /* jshint ignore:end */
  function StepContextListInstance(sid) {
    return StepContextListInstance.get(sid);
  }

  StepContextListInstance._version = version;
  // Path Solution
  StepContextListInstance._solution = {
    flowSid: flowSid,
    engagementSid: engagementSid,
    stepSid: stepSid
  };
  /* jshint ignore:start */
  /**
   * Constructs a step_context
   *
   * @function get
   * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextList#
   *
   * @returns {Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextContext}
   */
  /* jshint ignore:end */
  StepContextListInstance.get = function get() {
    return new StepContextContext(
      this._version,
      this._solution.flowSid,
      this._solution.engagementSid,
      this._solution.stepSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  StepContextListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  StepContextListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return StepContextListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the StepContextPage
 *
 * @constructor Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {StepContextSolution} solution - Path solution
 *
 * @returns StepContextPage
 */
/* jshint ignore:end */
StepContextPage = function StepContextPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(StepContextPage.prototype, Page.prototype);
StepContextPage.prototype.constructor = StepContextPage;

/* jshint ignore:start */
/**
 * Build an instance of StepContextInstance
 *
 * @function getInstance
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextPage#
 *
 * @param {StepContextPayload} payload - Payload response from the API
 *
 * @returns StepContextInstance
 */
/* jshint ignore:end */
StepContextPage.prototype.getInstance = function getInstance(payload) {
  return new StepContextInstance(
    this._version,
    payload,
    this._solution.flowSid,
    this._solution.engagementSid,
    this._solution.stepSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
StepContextPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

StepContextPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the StepContextContext
 *
 * @constructor Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {object} context - The current state of the flow
 * @property {string} engagementSid - The SID of the Engagement
 * @property {string} flowSid - The SID of the Flow
 * @property {string} stepSid - Step SID
 * @property {string} url - The absolute URL of the resource
 *
 * @param {V1} version - Version of the resource
 * @param {StepContextPayload} payload - The instance payload
 * @param {sid} flowSid - The SID of the Flow
 * @param {sid} engagementSid - The SID of the Engagement
 * @param {sid} stepSid - Step SID
 */
/* jshint ignore:end */
StepContextInstance = function StepContextInstance(version, payload, flowSid,
                                                    engagementSid, stepSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.context = payload.context; // jshint ignore:line
  this.engagementSid = payload.engagement_sid; // jshint ignore:line
  this.flowSid = payload.flow_sid; // jshint ignore:line
  this.stepSid = payload.step_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {flowSid: flowSid, engagementSid: engagementSid, stepSid: stepSid, };
};

Object.defineProperty(StepContextInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new StepContextContext(
          this._version,
          this._solution.flowSid,
          this._solution.engagementSid,
          this._solution.stepSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a StepContextInstance
 *
 * @function fetch
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed StepContextInstance
 */
/* jshint ignore:end */
StepContextInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
StepContextInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

StepContextInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the StepContextContext
 *
 * @constructor Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} flowSid - The SID of the Flow
 * @param {sid} engagementSid - The SID of the Engagement
 * @param {sid} stepSid - Step SID
 */
/* jshint ignore:end */
StepContextContext = function StepContextContext(version, flowSid,
                                                  engagementSid, stepSid) {
  this._version = version;

  // Path Solution
  this._solution = {flowSid: flowSid, engagementSid: engagementSid, stepSid: stepSid, };
  this._uri = `/Flows/${flowSid}/Engagements/${engagementSid}/Steps/${stepSid}/Context`;
};

/* jshint ignore:start */
/**
 * fetch a StepContextInstance
 *
 * @function fetch
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed StepContextInstance
 */
/* jshint ignore:end */
StepContextContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new StepContextInstance(
      this._version,
      payload,
      this._solution.flowSid,
      this._solution.engagementSid,
      this._solution.stepSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V1.FlowContext.EngagementContext.StepContext.StepContextContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
StepContextContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

StepContextContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  StepContextList: StepContextList,
  StepContextPage: StepContextPage,
  StepContextInstance: StepContextInstance,
  StepContextContext: StepContextContext
};
