/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the TrustProductsEntityAssignmentsList
 *
 * @param version - Version of the resource
 * @param trustProductSid - The unique string that identifies the TrustProduct resource.
 */
declare function TrustProductsEntityAssignmentsList(version: V1, trustProductSid: string): TrustProductsEntityAssignmentsListInstance;

interface TrustProductsEntityAssignmentsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrustProductsEntityAssignmentsContext;
  /**
   * create a TrustProductsEntityAssignmentsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TrustProductsEntityAssignmentsListInstanceCreateOptions, callback?: (error: Error | null, item: TrustProductsEntityAssignmentsInstance) => any): Promise<TrustProductsEntityAssignmentsInstance>;
  /**
   * Streams TrustProductsEntityAssignmentsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TrustProductsEntityAssignmentsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TrustProductsEntityAssignmentsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TrustProductsEntityAssignmentsListInstanceEachOptions, callback?: (item: TrustProductsEntityAssignmentsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a trust_products_entity_assignments
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): TrustProductsEntityAssignmentsContext;
  /**
   * Retrieve a single target page of TrustProductsEntityAssignmentsInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsPage) => any): Promise<TrustProductsEntityAssignmentsPage>;
  /**
   * Retrieve a single target page of TrustProductsEntityAssignmentsInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TrustProductsEntityAssignmentsPage) => any): Promise<TrustProductsEntityAssignmentsPage>;
  /**
   * Lists TrustProductsEntityAssignmentsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance[]) => any): Promise<TrustProductsEntityAssignmentsInstance[]>;
  /**
   * Lists TrustProductsEntityAssignmentsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TrustProductsEntityAssignmentsListInstanceOptions, callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance[]) => any): Promise<TrustProductsEntityAssignmentsInstance[]>;
  /**
   * Retrieve a single page of TrustProductsEntityAssignmentsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsPage) => any): Promise<TrustProductsEntityAssignmentsPage>;
  /**
   * Retrieve a single page of TrustProductsEntityAssignmentsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TrustProductsEntityAssignmentsListInstancePageOptions, callback?: (error: Error | null, items: TrustProductsEntityAssignmentsPage) => any): Promise<TrustProductsEntityAssignmentsPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property objectSid - The sid of an object bag
 */
interface TrustProductsEntityAssignmentsListInstanceCreateOptions {
  objectSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TrustProductsEntityAssignmentsListInstanceEachOptions {
  callback?: (item: TrustProductsEntityAssignmentsInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TrustProductsEntityAssignmentsListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TrustProductsEntityAssignmentsListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TrustProductsEntityAssignmentsPayload extends TrustProductsEntityAssignmentsResource, Page.TwilioResponsePayload {
}

interface TrustProductsEntityAssignmentsResource {
  account_sid: string;
  date_created: Date;
  object_sid: string;
  sid: string;
  trust_product_sid: string;
  url: string;
}

interface TrustProductsEntityAssignmentsSolution {
  trustProductSid?: string;
}


declare class TrustProductsEntityAssignmentsContext {
  /**
   * Initialize the TrustProductsEntityAssignmentsContext
   *
   * @param version - Version of the resource
   * @param trustProductSid - The unique string that identifies the resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, trustProductSid: string, sid: string);

  /**
   * fetch a TrustProductsEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance) => any): Promise<TrustProductsEntityAssignmentsInstance>;
  /**
   * remove a TrustProductsEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TrustProductsEntityAssignmentsInstance extends SerializableClass {
  /**
   * Initialize the TrustProductsEntityAssignmentsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param trustProductSid - The unique string that identifies the TrustProduct resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: TrustProductsEntityAssignmentsPayload, trustProductSid: string, sid: string);

  private _proxy: TrustProductsEntityAssignmentsContext;
  accountSid: string;
  dateCreated: Date;
  /**
   * fetch a TrustProductsEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance) => any): Promise<TrustProductsEntityAssignmentsInstance>;
  objectSid: string;
  /**
   * remove a TrustProductsEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsEntityAssignmentsInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trustProductSid: string;
  url: string;
}


declare class TrustProductsEntityAssignmentsPage extends Page<V1, TrustProductsEntityAssignmentsPayload, TrustProductsEntityAssignmentsResource, TrustProductsEntityAssignmentsInstance> {
  /**
   * Initialize the TrustProductsEntityAssignmentsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TrustProductsEntityAssignmentsSolution);

  /**
   * Build an instance of TrustProductsEntityAssignmentsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrustProductsEntityAssignmentsPayload): TrustProductsEntityAssignmentsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrustProductsEntityAssignmentsContext, TrustProductsEntityAssignmentsInstance, TrustProductsEntityAssignmentsList, TrustProductsEntityAssignmentsListInstance, TrustProductsEntityAssignmentsListInstanceCreateOptions, TrustProductsEntityAssignmentsListInstanceEachOptions, TrustProductsEntityAssignmentsListInstanceOptions, TrustProductsEntityAssignmentsListInstancePageOptions, TrustProductsEntityAssignmentsPage, TrustProductsEntityAssignmentsPayload, TrustProductsEntityAssignmentsResource, TrustProductsEntityAssignmentsSolution }
